/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.dimension;

import com.telepathicgrunt.world_blender.mixin.worldgen.ChunkGeneratorAccessor;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IStructureReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;

public class ChunkGeneratorBehavior {
    private static final Map<Biome, Map<Structure<?>, List<StructureFeature<?, ?>>>> MULTIPLE_CONFIGURED_STRUCTURE_BIOMES = new Reference2ObjectOpenHashMap();

    public static boolean placeAllConfiguredStructures(ChunkGenerator chunkGenerator, StructureFeature<?, ?> configuredStructureFeature, DynamicRegistries dynamicRegistryManager, StructureManager structureAccessor, IChunk chunk, TemplateManager structureManager, long worldSeed, ChunkPos chunkPos, Biome biome) {
        if (!MULTIPLE_CONFIGURED_STRUCTURE_BIOMES.containsKey(biome)) {
            MULTIPLE_CONFIGURED_STRUCTURE_BIOMES.put(biome, (Map<Structure<?>, List<StructureFeature<?, ?>>>)new Reference2ObjectOpenHashMap());
            Map<Structure<?>, List<StructureFeature<?, ?>>> structureMap = MULTIPLE_CONFIGURED_STRUCTURE_BIOMES.get(biome);
            for (Supplier supplierCS : biome.func_242440_e().func_242487_a()) {
                Structure structure = ((StructureFeature)supplierCS.get()).field_236268_b_;
                if (!structureMap.containsKey(structure)) {
                    structureMap.put(structure, new ArrayList());
                }
                structureMap.get(structure).add((StructureFeature<?, ?>)supplierCS.get());
            }
        }
        if (MULTIPLE_CONFIGURED_STRUCTURE_BIOMES.get(biome).containsKey(configuredStructureFeature.field_236268_b_)) {
            StructureStart structureStart = structureAccessor.func_235013_a_(SectionPos.func_218156_a((ChunkPos)chunk.func_76632_l(), (int)0), configuredStructureFeature.field_236268_b_, (IStructureReader)chunk);
            int ref = structureStart != null ? structureStart.func_227457_j_() : 0;
            StructureSeparationSettings structureConfig = chunkGenerator.func_235957_b_().func_236197_a_(configuredStructureFeature.field_236268_b_);
            if (structureConfig != null) {
                List<StructureFeature<?, ?>> randomStructureList = MULTIPLE_CONFIGURED_STRUCTURE_BIOMES.get(biome).get(configuredStructureFeature.field_236268_b_);
                Random random = new Random();
                random.setSeed(worldSeed + chunkPos.func_201841_a());
                StructureStart structureStart2 = randomStructureList.get(random.nextInt(randomStructureList.size())).func_242771_a(dynamicRegistryManager, chunkGenerator, ((ChunkGeneratorAccessor)chunkGenerator).getPopulationSource(), structureManager, worldSeed, chunkPos, biome, ref, structureConfig);
                structureAccessor.func_235014_a_(SectionPos.func_218156_a((ChunkPos)chunk.func_76632_l(), (int)0), configuredStructureFeature.field_236268_b_, structureStart2, (IStructureReader)chunk);
            }
            return true;
        }
        return false;
    }
}

