/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.surfacebuilder;

import com.telepathicgrunt.world_blender.WorldBlender;
import com.telepathicgrunt.world_blender.mixin.worldgen.CarverAccessor;
import com.telepathicgrunt.world_blender.the_blender.ConfigBlacklisting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class BlendedSurfaceBuilder
extends SurfaceBuilder<SurfaceBuilderConfig> {
    private static List<SurfaceBuilderConfig> threeLayerSurfaceList;
    private static List<ISurfaceBuilderConfig> allSurfaceList;
    private static PerlinNoiseGenerator perlinGen;
    public static long perlinSeed;
    private static double baseScale;
    public static final SurfaceBuilderConfig SAND_SAND_UNDERWATER_CONFIG;

    public BlendedSurfaceBuilder() {
        super(SurfaceBuilderConfig.field_237203_a_);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, SurfaceBuilderConfig config) {
        BlendedSurfaceBuilder.setPerlinSeed(seed);
        ISurfaceBuilderConfig chosenConfig = allSurfaceList.get(this.weightedIndex(x, z));
        if (chosenConfig instanceof SurfaceBuilderConfig) {
            this.buildSurface(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, chosenConfig.func_204108_a(), chosenConfig.func_204109_b(), ((SurfaceBuilderConfig)chosenConfig).func_204110_c(), seaLevel);
        } else {
            this.buildSurface(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, chosenConfig.func_204108_a(), chosenConfig.func_204109_b(), chosenConfig.func_204109_b(), seaLevel);
        }
    }

    protected void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, BlockState top, BlockState middle, BlockState bottom, int sealevel) {
        boolean replaceEntireColumn = false;
        if (bottom.func_177230_c() == Blocks.field_150377_bs || bottom.func_177230_c() == Blocks.field_150424_aL || !Registry.field_212618_g.func_177774_c((Object)bottom.func_177230_c()).func_110624_b().equals("minecraft")) {
            replaceEntireColumn = true;
        }
        BlockState topBlockstate = top;
        BlockState middleBlockstate = middle;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        int depth = -1;
        int maxNoiseDepth = (int)(noise / 3.0 + 3.0 + random.nextDouble() * 0.25);
        int xInChunk = x & 0xF;
        int zInChunk = z & 0xF;
        for (int y = startHeight; y >= 0; --y) {
            blockpos$mutable.func_181079_c(xInChunk, y, zInChunk);
            BlockState currentBlockstate = chunk.func_180495_p((BlockPos)blockpos$mutable);
            if (currentBlockstate.func_185904_a() == Material.field_151579_a) {
                depth = -1;
                continue;
            }
            if (currentBlockstate.func_177230_c() != defaultBlock.func_177230_c()) continue;
            if (depth == -1) {
                if (maxNoiseDepth <= 0) {
                    topBlockstate = Blocks.field_150350_a.func_176223_P();
                    middleBlockstate = defaultBlock;
                } else if (y >= sealevel - 4 && y <= sealevel + 1) {
                    topBlockstate = top;
                    middleBlockstate = middle;
                }
                if (y < sealevel && (topBlockstate == null || topBlockstate.func_185904_a() == Material.field_151579_a)) {
                    topBlockstate = biome.func_225486_c((BlockPos)blockpos$mutable.func_181079_c(x, y, z)) < 0.15f ? Blocks.field_150432_aD.func_176223_P() : defaultFluid;
                    blockpos$mutable.func_181079_c(xInChunk, y, zInChunk);
                }
                depth = maxNoiseDepth;
                if (y >= sealevel - 1) {
                    chunk.func_177436_a((BlockPos)blockpos$mutable, topBlockstate, false);
                    continue;
                }
                if (y < sealevel - 7 - maxNoiseDepth) {
                    topBlockstate = Blocks.field_150350_a.func_176223_P();
                    middleBlockstate = defaultBlock;
                    chunk.func_177436_a((BlockPos)blockpos$mutable, bottom, false);
                    continue;
                }
                chunk.func_177436_a((BlockPos)blockpos$mutable, middleBlockstate, false);
                continue;
            }
            if (depth > 0) {
                chunk.func_177436_a((BlockPos)blockpos$mutable, middleBlockstate, false);
                if (--depth != 0 || middleBlockstate.func_177230_c() != Blocks.field_150354_m || maxNoiseDepth <= 1) continue;
                depth = random.nextInt(4) + Math.max(0, y - 63);
                middleBlockstate = middleBlockstate.func_177230_c() == Blocks.field_196611_F ? Blocks.field_180395_cM.func_176223_P() : Blocks.field_150322_A.func_176223_P();
                continue;
            }
            if (!replaceEntireColumn) continue;
            chunk.func_177436_a((BlockPos)blockpos$mutable, bottom, false);
        }
    }

    public static void setPerlinSeed(long seed) {
        if (perlinGen == null || perlinSeed != seed) {
            perlinGen = new PerlinNoiseGenerator(new SharedSeedRandom(seed), IntStream.rangeClosed(-1, 0));
            perlinSeed = seed;
        }
    }

    public boolean containsConfig(SurfaceBuilderConfig configIn) {
        return threeLayerSurfaceList.stream().anyMatch(configEntry -> configEntry.func_204108_a() == configIn.func_204108_a() && configEntry.func_204109_b() == configIn.func_204109_b() && configEntry.func_204110_c() == configIn.func_204110_c());
    }

    public boolean containsConfig(ISurfaceBuilderConfig configIn) {
        return allSurfaceList.stream().anyMatch(configEntry -> configEntry.func_204108_a() == configIn.func_204108_a() && configEntry.func_204109_b() == configIn.func_204109_b());
    }

    public void addConfig(SurfaceBuilderConfig configIn) {
        threeLayerSurfaceList.add(configIn);
        allSurfaceList.add((ISurfaceBuilderConfig)configIn);
    }

    public void addConfig(ISurfaceBuilderConfig configIn) {
        allSurfaceList.add(configIn);
    }

    public static void resetSurfaceList() {
        threeLayerSurfaceList = new ArrayList<SurfaceBuilderConfig>();
        allSurfaceList = new ArrayList<ISurfaceBuilderConfig>();
        threeLayerSurfaceList.add(field_215394_E);
        threeLayerSurfaceList.add(field_215395_F);
        if (WorldBlender.WBBlendingConfig.allowVanillaSurfaces.get().booleanValue() && WorldBlender.WBBlendingConfig.allowVanillaBiomeImport.get().booleanValue()) {
            threeLayerSurfaceList.add(field_215425_v);
            threeLayerSurfaceList.add(field_215423_t);
            threeLayerSurfaceList.add(field_215392_C);
            threeLayerSurfaceList.add(SAND_SAND_UNDERWATER_CONFIG);
            threeLayerSurfaceList.add(field_215393_D);
            threeLayerSurfaceList.add(new SurfaceBuilderConfig(Blocks.field_196604_cC.func_176223_P(), Blocks.field_150346_d.func_176223_P(), Blocks.field_150351_n.func_176223_P()));
            threeLayerSurfaceList.add(field_237185_P_);
            threeLayerSurfaceList.add(field_237186_Q_);
            threeLayerSurfaceList.add(field_237187_R_);
            threeLayerSurfaceList.add(field_215428_y);
            threeLayerSurfaceList.add(field_215424_u);
        }
        for (int i = threeLayerSurfaceList.size() - 1; i > 1; --i) {
            if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, Registry.field_212618_g.func_177774_c((Object)threeLayerSurfaceList.get(i).func_204108_a().func_177230_c()))) continue;
            threeLayerSurfaceList.remove(i);
        }
        baseScale = 0.6 / (double)threeLayerSurfaceList.size();
        allSurfaceList.addAll(threeLayerSurfaceList);
    }

    public static Set<Block> blocksToCarve() {
        HashSet<Block> carvableBlocks = new HashSet<Block>(((CarverAccessor)WorldCarver.field_222711_c).wb_getalwaysCarvableBlocks());
        carvableBlocks.add(Blocks.field_150424_aL);
        carvableBlocks.add(Blocks.field_150377_bs);
        for (int i = threeLayerSurfaceList.size() - 1; i > 1; --i) {
            if (Registry.field_212618_g.func_177774_c((Object)threeLayerSurfaceList.get(i).func_204110_c().func_177230_c()).func_110624_b().equals("minecraft")) continue;
            carvableBlocks.add(threeLayerSurfaceList.get(i).func_204110_c().func_177230_c());
        }
        threeLayerSurfaceList = new ArrayList<SurfaceBuilderConfig>();
        return carvableBlocks;
    }

    private int weightedIndex(int x, int z) {
        int chosenConfigIndex = 2;
        double noiseScale = WorldBlender.WBDimensionConfig.surfaceScale.get();
        for (int configIndex = 0; configIndex < allSurfaceList.size(); ++configIndex) {
            if (configIndex == 0) {
                if (!(Math.abs(perlinGen.func_215464_a((double)x / noiseScale, (double)z / noiseScale, true)) < 0.035)) continue;
                chosenConfigIndex = 0;
                break;
            }
            if (configIndex == 1) {
                if (!(Math.abs(perlinGen.func_215464_a((double)x / noiseScale, (double)z / noiseScale, true)) < 0.06)) continue;
                chosenConfigIndex = 1;
                break;
            }
            double offset = 200.0 * (double)configIndex;
            double scaling = 200.0 + (double)configIndex * 4.0;
            double threshold = baseScale + Math.min((double)configIndex / 150.0, 0.125);
            if (!(Math.abs(perlinGen.func_215464_a(((double)x + offset) / scaling, ((double)z + offset) / scaling, true)) < threshold)) continue;
            chosenConfigIndex = configIndex;
            break;
        }
        return Math.min(chosenConfigIndex, allSurfaceList.size() - 1);
    }

    static {
        SAND_SAND_UNDERWATER_CONFIG = new SurfaceBuilderConfig(Blocks.field_150354_m.func_176223_P(), Blocks.field_150354_m.func_176223_P(), Blocks.field_150322_A.func_176223_P());
    }
}

