/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.the_blender;

import com.telepathicgrunt.world_blender.WorldBlender;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;

public class ConfigBlacklisting {
    private static List<String> blanketBL;
    private static List<String> featureBL;
    private static List<String> structureBL;
    private static List<String> carverBL;
    private static List<String> spawnBL;
    private static List<String> surfaceBL;

    public static void setupBlackLists() {
        blanketBL = ConfigBlacklisting.parseConfigAndAssignEntries(WorldBlender.WBBlendingConfig.blanketBlacklist.get());
        featureBL = ConfigBlacklisting.parseConfigAndAssignEntries(WorldBlender.WBBlendingConfig.blacklistedFeatures.get());
        structureBL = ConfigBlacklisting.parseConfigAndAssignEntries(WorldBlender.WBBlendingConfig.blacklistedStructures.get());
        carverBL = ConfigBlacklisting.parseConfigAndAssignEntries(WorldBlender.WBBlendingConfig.blacklistedCarvers.get());
        spawnBL = ConfigBlacklisting.parseConfigAndAssignEntries(WorldBlender.WBBlendingConfig.blacklistedSpawns.get());
        surfaceBL = ConfigBlacklisting.parseConfigAndAssignEntries(WorldBlender.WBBlendingConfig.blacklistedBiomeSurfaces.get());
    }

    private static List<String> parseConfigAndAssignEntries(String configEntry) {
        String[] entriesArray = configEntry.split(",");
        Arrays.parallelSetAll(entriesArray, i -> entriesArray[i].trim().toLowerCase(Locale.ROOT).replace(' ', '_'));
        return Arrays.asList(entriesArray);
    }

    private static boolean matchFound(String blacklistedEntry, ResourceLocation resourceLocationToCheck) {
        if (resourceLocationToCheck == null || blacklistedEntry.isEmpty()) {
            return false;
        }
        if (blacklistedEntry.contains(":")) {
            return blacklistedEntry.equals(resourceLocationToCheck.toString());
        }
        if (blacklistedEntry.contains("*")) {
            return blacklistedEntry.substring(0, blacklistedEntry.length() - 1).equals(resourceLocationToCheck.func_110624_b());
        }
        return resourceLocationToCheck.func_110623_a().contains(blacklistedEntry);
    }

    public static boolean isResourceLocationBlacklisted(BlacklistType type, ResourceLocation incomingRL) {
        List<String> listToUse;
        switch (type) {
            case BLANKET: {
                listToUse = blanketBL;
                break;
            }
            case FEATURE: {
                listToUse = featureBL;
                break;
            }
            case STRUCTURE: {
                listToUse = structureBL;
                break;
            }
            case CARVER: {
                listToUse = carverBL;
                break;
            }
            case SPAWN: {
                listToUse = spawnBL;
                break;
            }
            case SURFACE_BLOCK: {
                listToUse = surfaceBL;
                break;
            }
            default: {
                return false;
            }
        }
        return listToUse.stream().anyMatch(banEntry -> ConfigBlacklisting.matchFound(banEntry, incomingRL));
    }

    public static enum BlacklistType {
        BLANKET,
        FEATURE,
        STRUCTURE,
        CARVER,
        SPAWN,
        SURFACE_BLOCK;

    }
}

