/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.world_blender.the_blender;

import com.telepathicgrunt.world_blender.WBIdentifiers;
import com.telepathicgrunt.world_blender.WorldBlender;
import com.telepathicgrunt.world_blender.features.WBConfiguredFeatures;
import com.telepathicgrunt.world_blender.mixin.worldgen.CarverAccessor;
import com.telepathicgrunt.world_blender.mixin.worldgen.ConfiguredCarverAccessor;
import com.telepathicgrunt.world_blender.mixin.worldgen.DimensionStructureSettingsAccessor;
import com.telepathicgrunt.world_blender.mixin.worldgen.GenerationSettingsAccessor;
import com.telepathicgrunt.world_blender.mixin.worldgen.MobSpawnInfoAccessor;
import com.telepathicgrunt.world_blender.surfacebuilder.BlendedSurfaceBuilder;
import com.telepathicgrunt.world_blender.surfacebuilder.WBSurfaceBuilders;
import com.telepathicgrunt.world_blender.the_blender.ConfigBlacklisting;
import com.telepathicgrunt.world_blender.the_blender.FeatureGrouping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;

public class TheBlender {
    private static final Set<Supplier<?>> CHECKED_WORLDGEN_OBJECTS = new HashSet();
    private static final Set<MobSpawnInfo.Spawners> CHECKED_MOBS = new HashSet<MobSpawnInfo.Spawners>();
    private static final Map<EntityClassification, Integer> MAX_WEIGHT_PER_GROUP = TheBlender.createWeightMap();
    private static Map<Structure<?>, StructureSeparationSettings> tempMap = new HashMap();

    private static Map<EntityClassification, Integer> createWeightMap() {
        HashMap<EntityClassification, Integer> tempMap = new HashMap<EntityClassification, Integer>();
        tempMap.put(EntityClassification.CREATURE, 15);
        tempMap.put(EntityClassification.MONSTER, 120);
        tempMap.put(EntityClassification.WATER_AMBIENT, 30);
        tempMap.put(EntityClassification.WATER_CREATURE, 12);
        tempMap.put(EntityClassification.AMBIENT, 15);
        return tempMap;
    }

    public static void blendTheWorld(DynamicRegistries.Impl registryManager) {
        if (!registryManager.func_230521_a_(Registry.field_239720_u_).isPresent()) {
            return;
        }
        List<Biome> worldBlenderBiomes = ((MutableRegistry)registryManager.func_230521_a_(Registry.field_239720_u_).get()).func_239659_c_().stream().filter(entry -> ((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b().equals("world_blender")).map(Map.Entry::getValue).collect(Collectors.toList());
        worldBlenderBiomes.forEach(TheBlender::makeBiomeMutable);
        if (WorldBlender.WBBlendingConfig.cleanSlateWBBiomesAtStartup.get().booleanValue()) {
            worldBlenderBiomes.forEach(biome -> {
                biome.func_242440_e().func_242498_c().forEach(List::clear);
                biome.func_242440_e().func_242487_a().clear();
                ((GenerationSettingsAccessor)biome.func_242440_e()).wb_getCarvers().forEach((stage, list) -> list.clear());
                ((MobSpawnInfoAccessor)biome.func_242433_b()).wb_getSpawnCosts().clear();
                ((MobSpawnInfoAccessor)biome.func_242433_b()).wb_getSpawners().forEach((group, list) -> list.clear());
            });
        }
        ConfigBlacklisting.setupBlackLists();
        FeatureGrouping.setupFeatureMaps();
        BlendedSurfaceBuilder.resetSurfaceList();
        for (Map.Entry biomeEntry : ((MutableRegistry)registryManager.func_230521_a_(Registry.field_239720_u_).get()).func_239659_c_()) {
            if (((RegistryKey)biomeEntry.getKey()).func_240901_a_().func_110624_b().equals("world_blender")) continue;
            TheBlender.mainBlending((Biome)biomeEntry.getValue(), worldBlenderBiomes, ((RegistryKey)biomeEntry.getKey()).func_240901_a_(), registryManager);
        }
        TheBlender.completeBlending(worldBlenderBiomes, registryManager.func_243612_b(Registry.field_243552_au));
        FeatureGrouping.clearFeatureMaps();
        CHECKED_WORLDGEN_OBJECTS.clear();
        CHECKED_MOBS.clear();
    }

    private static void mainBlending(Biome biome, List<Biome> worldBlenderBiomes, ResourceLocation biomeID, DynamicRegistries.Impl dynamicRegistryManager) {
        if (biomeID.func_110624_b().equals("world_blender")) {
            return;
        }
        if (biomeID.func_110624_b().equals("minecraft") && !WorldBlender.WBBlendingConfig.allowVanillaBiomeImport.get().booleanValue()) {
            return;
        }
        if (!biomeID.func_110624_b().equals("minecraft") && !WorldBlender.WBBlendingConfig.allowModdedBiomeImport.get().booleanValue()) {
            return;
        }
        if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.BLANKET, biomeID)) {
            return;
        }
        TheBlender.addBiomeFeatures(biome, worldBlenderBiomes, dynamicRegistryManager.func_243612_b(Registry.field_243552_au));
        TheBlender.addBiomeStructures(biome, worldBlenderBiomes, dynamicRegistryManager.func_243612_b(Registry.field_243553_av));
        TheBlender.addBiomeCarvers(biome, worldBlenderBiomes, dynamicRegistryManager.func_243612_b(Registry.field_243551_at));
        TheBlender.addBiomeNaturalMobs(biome, worldBlenderBiomes);
        TheBlender.addBiomeSurfaceConfig(biome, biomeID);
    }

    public static void completeBlending(List<Biome> worldBlenderBiomes, MutableRegistry<ConfiguredFeature<?, ?>> configuredFeaturesRegistry) {
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("minecraft:end_spike"))) {
            worldBlenderBiomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.SURFACE_STRUCTURES.ordinal())).add(() -> (ConfiguredFeature)configuredFeaturesRegistry.func_82594_a(new ResourceLocation("minecraft", "end_spike"))));
        }
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            for (ConfiguredFeature<?, ?> grassyFlowerFeature : FeatureGrouping.SMALL_PLANT_MAP.get(stage)) {
                if (!((List)worldBlenderBiomes.get(0).func_242440_e().func_242498_c().get(stage.ordinal())).stream().noneMatch(addedConfigFeature -> FeatureGrouping.serializeAndCompareFeature((ConfiguredFeature)addedConfigFeature.get(), grassyFlowerFeature, true))) continue;
                worldBlenderBiomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(() -> grassyFlowerFeature));
            }
        }
        if (!WorldBlender.WBBlendingConfig.disallowLaggyFeatures.get().booleanValue() && FeatureGrouping.bambooFound) {
            worldBlenderBiomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.VEGETAL_DECORATION.ordinal())).add(() -> (ConfiguredFeature)configuredFeaturesRegistry.func_82594_a(new ResourceLocation("minecraft", "bamboo"))));
        }
        if (WorldBlender.WBDimensionConfig.carversCanCarveMoreBlocks.get().booleanValue()) {
            Set<Block> allBlocksToCarve = BlendedSurfaceBuilder.blocksToCarve();
            for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
                for (Supplier carver : worldBlenderBiomes.get(0).func_242440_e().func_242489_a(carverStage)) {
                    allBlocksToCarve.addAll(((CarverAccessor)((ConfiguredCarverAccessor)carver.get()).wb_getcarver()).wb_getalwaysCarvableBlocks());
                }
            }
            for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
                for (Supplier carver : worldBlenderBiomes.get(0).func_242440_e().func_242489_a(carverStage)) {
                    ((CarverAccessor)((ConfiguredCarverAccessor)carver.get()).wb_getcarver()).wb_setalwaysCarvableBlocks(allBlocksToCarve);
                }
            }
        }
        if (!ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, new ResourceLocation("world_blender:anti_floating_blocks_and_separate_liquids"))) {
            worldBlenderBiomes.forEach(blendedBiome -> ((List)blendedBiome.func_242440_e().func_242498_c().get(GenerationStage.Decoration.LOCAL_MODIFICATIONS.ordinal())).add(() -> WBConfiguredFeatures.ANTI_FLOATING_BLOCKS_AND_SEPARATE_LIQUIDS));
        }
    }

    private static void makeBiomeMutable(Biome biome) {
        List<List<Supplier<ConfiguredFeature<?, ?>>>> tempFeature = ((GenerationSettingsAccessor)biome.func_242440_e()).wb_getGSFeatures();
        ArrayList mutableGenerationStages = new ArrayList();
        for (int currentStageIndex = 0; currentStageIndex < Math.max(GenerationStage.Decoration.values().length, tempFeature.size()); ++currentStageIndex) {
            if (currentStageIndex >= tempFeature.size()) {
                mutableGenerationStages.add(new ArrayList());
                continue;
            }
            mutableGenerationStages.add(new ArrayList(tempFeature.get(currentStageIndex)));
        }
        ((GenerationSettingsAccessor)biome.func_242440_e()).wb_setGSFeatures(mutableGenerationStages);
        ((GenerationSettingsAccessor)biome.func_242440_e()).wb_setGSStructureFeatures(new ArrayList(((GenerationSettingsAccessor)biome.func_242440_e()).wb_getGSStructureFeatures()));
        ((GenerationSettingsAccessor)biome.func_242440_e()).wb_setGSStructureFeatures(new ArrayList(((GenerationSettingsAccessor)biome.func_242440_e()).wb_getGSStructureFeatures()));
        ((GenerationSettingsAccessor)biome.func_242440_e()).wb_setCarvers(new HashMap(((GenerationSettingsAccessor)biome.func_242440_e()).wb_getCarvers()));
        for (GenerationStage.Carving carving : GenerationStage.Carving.values()) {
            ((GenerationSettingsAccessor)biome.func_242440_e()).wb_getCarvers().put(carving, new ArrayList(biome.func_242440_e().func_242489_a(carving)));
        }
        ((MobSpawnInfoAccessor)biome.func_242433_b()).wb_setSpawners(new HashMap<EntityClassification, List<MobSpawnInfo.Spawners>>(((MobSpawnInfoAccessor)biome.func_242433_b()).wb_getSpawners()));
        for (GenerationStage.Carving carving : EntityClassification.values()) {
            ((MobSpawnInfoAccessor)biome.func_242433_b()).wb_getSpawners().put((EntityClassification)carving, new ArrayList(biome.func_242433_b().func_242559_a((EntityClassification)carving)));
        }
        ((MobSpawnInfoAccessor)biome.func_242433_b()).wb_setSpawnCosts(new HashMap(((MobSpawnInfoAccessor)biome.func_242433_b()).wb_getSpawnCosts()));
    }

    private static void addBiomeFeatures(Biome biome, List<Biome> worldBlenderBiomes, MutableRegistry<ConfiguredFeature<?, ?>> configuredFeaturesRegistry) {
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            if (stage.ordinal() >= biome.func_242440_e().func_242498_c().size()) break;
            for (Supplier configuredFeatureSupplier : (List)biome.func_242440_e().func_242498_c().get(stage.ordinal())) {
                ConfiguredFeature configuredFeature = (ConfiguredFeature)configuredFeatureSupplier.get();
                if (CHECKED_WORLDGEN_OBJECTS.contains(configuredFeatureSupplier)) continue;
                if (((List)worldBlenderBiomes.get(0).func_242440_e().func_242498_c().get(stage.ordinal())).stream().noneMatch(arg_0 -> TheBlender.lambda$addBiomeFeatures$13((Supplier)configuredFeatureSupplier, arg_0))) {
                    ResourceLocation configuredFeatureID = configuredFeaturesRegistry.func_177774_c((Object)configuredFeature);
                    if (configuredFeatureID == null) {
                        configuredFeatureID = WorldGenRegistries.field_243653_e.func_177774_c((Object)configuredFeature);
                    }
                    if (configuredFeatureID == null || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.FEATURE, configuredFeatureID)) continue;
                    if (configuredFeatureID.func_110624_b().equals("minecraft")) {
                        if (WorldBlender.WBBlendingConfig.allowVanillaFeatures.get().booleanValue()) {
                            if (FeatureGrouping.checksAndAddSmallPlantFeatures(stage, configuredFeature)) continue;
                            if (!FeatureGrouping.isLaggyFeature(configuredFeature) || !WorldBlender.WBBlendingConfig.disallowLaggyFeatures.get().booleanValue()) {
                                worldBlenderBiomes.forEach(arg_0 -> TheBlender.lambda$addBiomeFeatures$14(stage, (Supplier)configuredFeatureSupplier, arg_0));
                            }
                        }
                    } else if (WorldBlender.WBBlendingConfig.allowModdedFeatures.get().booleanValue()) {
                        if (!FeatureGrouping.checksAndAddSmallPlantFeatures(stage, configuredFeature) && FeatureGrouping.checksAndAddLargePlantFeatures(stage, configuredFeature)) {
                            worldBlenderBiomes.forEach(arg_0 -> TheBlender.lambda$addBiomeFeatures$15(stage, (Supplier)configuredFeatureSupplier, arg_0));
                        } else if (!FeatureGrouping.isLaggyFeature(configuredFeature) || !WorldBlender.WBBlendingConfig.disallowLaggyFeatures.get().booleanValue()) {
                            worldBlenderBiomes.forEach(arg_0 -> TheBlender.lambda$addBiomeFeatures$16(stage, (Supplier)configuredFeatureSupplier, arg_0));
                        }
                    }
                }
                CHECKED_WORLDGEN_OBJECTS.add(configuredFeatureSupplier);
            }
        }
    }

    private static void addBiomeStructures(Biome biome, List<Biome> worldBlenderBiomes, MutableRegistry<StructureFeature<?, ?>> configuredStructuresRegistry) {
        for (Supplier configuredStructureSupplier : biome.func_242440_e().func_242487_a()) {
            StructureFeature configuredStructure = (StructureFeature)configuredStructureSupplier.get();
            if (CHECKED_WORLDGEN_OBJECTS.contains(configuredStructureSupplier)) continue;
            if (worldBlenderBiomes.get(0).func_242440_e().func_242487_a().stream().noneMatch(addedConfiguredStructure -> addedConfiguredStructure.get() == configuredStructure)) {
                ResourceLocation configuredStructureID = configuredStructuresRegistry.func_177774_c((Object)configuredStructure);
                if (configuredStructureID == null) {
                    configuredStructureID = WorldGenRegistries.field_243654_f.func_177774_c((Object)configuredStructure);
                }
                if (configuredStructureID == null || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.STRUCTURE, configuredStructureID)) continue;
                if (configuredStructureID.func_110624_b().equals("minecraft")) {
                    if (WorldBlender.WBBlendingConfig.allowVanillaStructures.get().booleanValue()) {
                        worldBlenderBiomes.forEach(arg_0 -> TheBlender.lambda$addBiomeStructures$18((Supplier)configuredStructureSupplier, arg_0));
                    }
                } else if (WorldBlender.WBBlendingConfig.allowModdedStructures.get().booleanValue()) {
                    worldBlenderBiomes.forEach(arg_0 -> TheBlender.lambda$addBiomeStructures$19((Supplier)configuredStructureSupplier, arg_0));
                }
            }
            CHECKED_WORLDGEN_OBJECTS.add(configuredStructureSupplier);
        }
    }

    private static void addBiomeCarvers(Biome biome, List<Biome> worldBlenderBiomes, MutableRegistry<ConfiguredCarver<?>> configuredCarversRegistry) {
        for (GenerationStage.Carving carverStage : GenerationStage.Carving.values()) {
            for (Supplier configuredCarverSupplier : biome.func_242440_e().func_242489_a(carverStage)) {
                ConfiguredCarver configuredCarver = (ConfiguredCarver)configuredCarverSupplier.get();
                if (CHECKED_WORLDGEN_OBJECTS.contains(configuredCarverSupplier)) continue;
                if (worldBlenderBiomes.get(0).func_242440_e().func_242489_a(carverStage).stream().noneMatch(addedConfiguredCarver -> addedConfiguredCarver.get() == configuredCarver)) {
                    ResourceLocation configuredCarverID = configuredCarversRegistry.func_177774_c((Object)configuredCarver);
                    if (configuredCarverID == null) {
                        configuredCarverID = WorldGenRegistries.field_243652_d.func_177774_c((Object)configuredCarver);
                    }
                    if (configuredCarverID == null || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.CARVER, configuredCarverID)) continue;
                    if (configuredCarverID.func_110624_b().equals("minecraft")) {
                        if (WorldBlender.WBBlendingConfig.allowVanillaCarvers.get().booleanValue()) {
                            worldBlenderBiomes.forEach(arg_0 -> TheBlender.lambda$addBiomeCarvers$21(carverStage, (Supplier)configuredCarverSupplier, arg_0));
                        }
                    } else if (WorldBlender.WBBlendingConfig.allowModdedCarvers.get().booleanValue()) {
                        worldBlenderBiomes.forEach(arg_0 -> TheBlender.lambda$addBiomeCarvers$22(carverStage, (Supplier)configuredCarverSupplier, arg_0));
                    }
                }
                CHECKED_WORLDGEN_OBJECTS.add(configuredCarverSupplier);
            }
        }
    }

    private static void addBiomeNaturalMobs(Biome biome, List<Biome> worldBlenderBiomes) {
        for (EntityClassification spawnGroup : EntityClassification.values()) {
            for (MobSpawnInfo.Spawners spawnEntry : biome.func_242433_b().func_242559_a(spawnGroup)) {
                if (CHECKED_MOBS.contains(spawnEntry)) continue;
                if (worldBlenderBiomes.get(0).func_242433_b().func_242559_a(spawnGroup).stream().noneMatch(spawn -> spawn.field_242588_c == spawnEntry.field_242588_c)) {
                    ResourceLocation entityTypeID = Registry.field_212629_r.func_177774_c((Object)spawnEntry.field_242588_c);
                    if (ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SPAWN, entityTypeID)) continue;
                    int maxWeight = MAX_WEIGHT_PER_GROUP.getOrDefault(spawnGroup, spawnEntry.field_76292_a);
                    MobSpawnInfo.Spawners newEntry = new MobSpawnInfo.Spawners(spawnEntry.field_242588_c, Math.max(Math.min(spawnEntry.field_76292_a, maxWeight), 1), spawnEntry.field_242589_d, spawnEntry.field_242590_e);
                    if (entityTypeID.func_110624_b().equals("minecraft")) {
                        if (WorldBlender.WBBlendingConfig.allowVanillaSpawns.get().booleanValue()) {
                            worldBlenderBiomes.forEach(blendedBiome -> blendedBiome.func_242433_b().func_242559_a(spawnGroup).add(newEntry));
                        }
                    } else if (WorldBlender.WBBlendingConfig.allowModdedSpawns.get().booleanValue()) {
                        worldBlenderBiomes.forEach(blendedBiome -> blendedBiome.func_242433_b().func_242559_a(spawnGroup).add(newEntry));
                    }
                }
                CHECKED_MOBS.add(spawnEntry);
            }
        }
    }

    private static void addBiomeSurfaceConfig(Biome biome, ResourceLocation biomeID) {
        if (biomeID.func_110624_b().equals("minecraft") ? WorldBlender.WBBlendingConfig.allowVanillaSurfaces.get() == false : WorldBlender.WBBlendingConfig.allowModdedSurfaces.get() == false) {
            return;
        }
        if (biome.func_242440_e().func_242502_e() instanceof SurfaceBuilderConfig) {
            SurfaceBuilderConfig surfaceConfig = (SurfaceBuilderConfig)biome.func_242440_e().func_242502_e();
            if (surfaceConfig.func_204108_a() == null || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, Registry.field_212618_g.func_177774_c((Object)surfaceConfig.func_204108_a().func_177230_c()))) {
                return;
            }
            if (!((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER.get()).containsConfig(surfaceConfig)) {
                ((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER.get()).addConfig(surfaceConfig);
            }
        } else {
            ISurfaceBuilderConfig surfaceConfig = biome.func_242440_e().func_242502_e();
            if (surfaceConfig.func_204108_a() == null || ConfigBlacklisting.isResourceLocationBlacklisted(ConfigBlacklisting.BlacklistType.SURFACE_BLOCK, Registry.field_212618_g.func_177774_c((Object)surfaceConfig.func_204108_a().func_177230_c()))) {
                return;
            }
            if (!((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER.get()).containsConfig(surfaceConfig)) {
                ((BlendedSurfaceBuilder)WBSurfaceBuilders.BLENDED_SURFACE_BUILDER.get()).addConfig(surfaceConfig);
            }
        }
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            tempMap.putAll(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            ServerWorld wbServerWorld = serverWorld.func_73046_m().func_71218_a(WBIdentifiers.WB_WORLD_KEY);
            if (wbServerWorld != null) {
                tempMap.putAll(wbServerWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
                tempMap.values().removeIf(Objects::isNull);
                ((DimensionStructureSettingsAccessor)wbServerWorld.func_72863_F().field_186029_c.func_235957_b_()).wb_setStructureConfigMap(tempMap);
                tempMap = new HashMap();
            }
        }
    }

    private static /* synthetic */ void lambda$addBiomeCarvers$22(GenerationStage.Carving carverStage, Supplier configuredCarverSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242489_a(carverStage).add(configuredCarverSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeCarvers$21(GenerationStage.Carving carverStage, Supplier configuredCarverSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242489_a(carverStage).add(configuredCarverSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeStructures$19(Supplier configuredStructureSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242487_a().add(configuredStructureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeStructures$18(Supplier configuredStructureSupplier, Biome blendedBiome) {
        blendedBiome.func_242440_e().func_242487_a().add(configuredStructureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeFeatures$16(GenerationStage.Decoration stage, Supplier configuredFeatureSupplier, Biome blendedBiome) {
        ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(configuredFeatureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeFeatures$15(GenerationStage.Decoration stage, Supplier configuredFeatureSupplier, Biome blendedBiome) {
        ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(0, configuredFeatureSupplier);
    }

    private static /* synthetic */ void lambda$addBiomeFeatures$14(GenerationStage.Decoration stage, Supplier configuredFeatureSupplier, Biome blendedBiome) {
        ((List)blendedBiome.func_242440_e().func_242498_c().get(stage.ordinal())).add(configuredFeatureSupplier);
    }

    private static /* synthetic */ boolean lambda$addBiomeFeatures$13(Supplier configuredFeatureSupplier, Supplier addedConfigFeature) {
        return FeatureGrouping.serializeAndCompareFeature((ConfiguredFeature)addedConfigFeature.get(), (ConfiguredFeature)configuredFeatureSupplier.get(), true);
    }
}

