/*
 * Decompiled with CFR 0.152.
 */
package wraith.harvest_scythes;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import wraith.harvest_scythes.EnchantsRegistry;
import wraith.harvest_scythes.Utils;

public class ScytheTool
extends class_1794 {
    protected int harvestRadius;
    protected boolean circleHarvest;
    private int mineLevel = -1;

    public ScytheTool(class_1832 material, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        this(material, attackDamage, attackSpeed, ScytheTool.getRadius(material), ScytheTool.shouldBeCircle(material), settings);
        this.mineLevel = material.method_8024();
    }

    public ScytheTool(class_1832 material, int attackDamage, float attackSpeed, int harvestRadius, boolean circleHarvest, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
        this.harvestRadius = harvestRadius;
        this.circleHarvest = circleHarvest;
    }

    private static int getRadius(class_1832 material) {
        return (int)(Math.floor((double)material.method_8024() / 2.0) + 1.0);
    }

    private static boolean shouldBeCircle(class_1832 material) {
        return material.method_8024() % 2 == 0;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return ScytheTool.harvest(this.harvestRadius, this.circleHarvest, world, user, hand);
    }

    public static class_1271<class_1799> harvest(int harvestRadius, boolean circleHarvest, class_1937 world, class_1657 user, class_1268 hand) {
        class_2338 blockPos = user.method_24515();
        class_1792 item = user.method_5998(hand).method_7909();
        int lvl = class_1890.method_8225((class_1887)EnchantsRegistry.ENCHANTMENTS.get("crop_reaper"), (class_1799)user.method_5998(hand));
        int radius = (int)(Math.floor((double)lvl / 2.0) + (double)harvestRadius);
        circleHarvest = (harvestRadius + lvl) % 2 == 0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    int unbreaking;
                    class_2338 newBlockPos = new class_2338(blockPos.method_10263() + x, blockPos.method_10264() + y, blockPos.method_10260() + z);
                    if (circleHarvest && (y == -1 && newBlockPos.method_19455((class_2382)blockPos.method_10074()) > radius || y == 0 && newBlockPos.method_19455((class_2382)blockPos) > radius || y == 1 && newBlockPos.method_19455((class_2382)blockPos.method_10084()) > radius)) continue;
                    class_2680 blockState = world.method_8320(newBlockPos);
                    class_2248 block = blockState.method_26204();
                    int damageTool = 0;
                    if (block instanceof class_2302 && ((class_2302)block).method_9825(blockState)) {
                        class_2302 cropBlock = (class_2302)block;
                        class_2248.method_9497((class_2680)blockState, (class_1937)world, (class_2338)newBlockPos);
                        world.method_8501(newBlockPos, cropBlock.method_9828(0));
                        damageTool = 1;
                    } else if (block.equals(class_2246.field_10479) || block.equals(class_2246.field_10214) || block.equals(class_2246.field_10112) || block.equals(class_2246.field_10313)) {
                        world.method_8651(newBlockPos, true, (class_1297)user);
                        damageTool = 1;
                    }
                    if (damageTool <= 0 || Utils.getRandomIntInRange(0, unbreaking = class_1890.method_8225((class_1887)class_1893.field_9119, (class_1799)user.method_5998(hand))) > 0) continue;
                    user.method_5998(hand).method_7956(damageTool, (class_1309)user, e -> e.method_20235(class_1304.field_6173));
                    if (user.method_5998(hand).method_7909() == item) continue;
                    return class_1271.method_22427((Object)user.method_5998(hand));
                }
            }
        }
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    public int getHarvestRadius() {
        return this.harvestRadius;
    }

    public boolean hasCircleHarvset() {
        return this.circleHarvest;
    }
}

