/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.screen;

import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class DebugScreen
extends Screen {
    public final AbstractDragonEntity dragon;

    public DebugScreen(AbstractDragonEntity dragon) {
        super((ITextComponent)new StringTextComponent("debug_screen"));
        this.dragon = dragon;
    }

    protected void init() {
        Animation[] animations = this.dragon.getAnimations();
        if (animations != null && animations.length > 0) {
            for (int i = 0; i < animations.length; ++i) {
                final Animation animation = animations[i];
                this.addButton((Widget)new AbstractButton(i * 50 + this.width / 2 - animations.length * 25, 200, 50, 12, "Anim: " + i){

                    public void onPress() {
                        DebugScreen.this.dragon.setAnimation(animation);
                        DebugScreen.this.onClose();
                    }
                });
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        String gender = this.dragon.isMale() ? "male" : "female";
        this.drawCenteredString(this.font, this.dragon.func_145748_c_().func_150261_e(), this.width / 2, 15, 0xFFFFFF);
        this.drawCenteredString(this.font, "isSleeping: " + this.dragon.func_70608_bn(), this.width / 2 + 50, 50, 0xFFFFFF);
        this.drawCenteredString(this.font, "isTamed: " + this.dragon.func_70909_n(), this.width / 2 - 50, 50, 0xFFFFFF);
        this.drawCenteredString(this.font, "isSitting: " + this.dragon.func_70906_o(), this.width / 2 - 50, 75, 0xFFFFFF);
        this.drawCenteredString(this.font, "isFlying: " + this.dragon.isFlying(), this.width / 2 + 50, 75, 0xFFFFFF);
        this.drawCenteredString(this.font, "variant: " + this.dragon.getVariant(), this.width / 2 - 50, 100, 0xFFFFFF);
        this.drawCenteredString(this.font, "gender: " + gender, this.width / 2 + 50, 100, 0xFFFFFF);
        this.drawCenteredString(this.font, "health: " + this.dragon.func_110143_aJ() + " / " + this.dragon.func_110138_aP(), this.width / 2 - 50, 125, 0xFFFFFF);
        this.drawCenteredString(this.font, "noAI: " + this.dragon.func_175446_cd(), this.width / 2 + 50, 125, 0xFFFFFF);
        this.drawCenteredString(this.font, "position: " + this.dragon.func_213303_ch(), this.width / 2, 150, 0xFFFFFF);
        this.drawCenteredString(this.font, "motion: " + this.dragon.func_213322_ci(), this.width / 2, 175, 0xFFFFFF);
    }

    public boolean isPauseScreen() {
        return true;
    }

    public static void open(AbstractDragonEntity dragon) {
        Minecraft.func_71410_x().func_147108_a((Screen)new DebugScreen(dragon));
    }
}

