/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.screen;

import com.github.wolfshotz.wyrmroost.client.screen.widgets.NameFieldWidget;
import com.github.wolfshotz.wyrmroost.client.screen.widgets.StaffActionButton;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.items.staff.DragonStaffItem;
import com.github.wolfshotz.wyrmroost.items.staff.StaffAction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class StaffScreen
extends Screen {
    private final AbstractDragonEntity dragon;
    public final List<String> toolTip = new ArrayList<String>();
    public final List<StaffAction> actions = new ArrayList<StaffAction>();

    public StaffScreen(AbstractDragonEntity dragon) {
        super((ITextComponent)new StringTextComponent("Staff Screen"));
        this.dragon = dragon;
    }

    protected void init() {
        this.actions.clear();
        this.toolTip.clear();
        this.dragon.addScreenInfo(this);
        this.addButton((Widget)new NameFieldWidget(this.font, this.width / 2 - 63, this.height / 2 + 25, 120, 12, this.dragon));
        this.initActions();
    }

    public void initActions() {
        int size = this.actions.size();
        int radius = Math.max(size * 20, 100);
        for (int i = 0; i < size; ++i) {
            StaffAction action = this.actions.get(i);
            TranslationTextComponent name = action.getTranslation(this.dragon);
            double deg = Math.PI * 2 * (double)i / (double)size - Math.toRadians(90.0);
            int x = (int)((double)radius * Math.cos(deg));
            int y = (int)((double)radius * Math.sin(deg));
            this.addButton((Widget)new StaffActionButton(x += this.width / 2 - 50, y += this.height / 2 - 10, (ITextComponent)name, action));
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        for (Widget b : this.buttons) {
            b.render(mouseX, mouseY, partialTicks);
        }
        int x = this.width / 2;
        int y = this.height / 2 + (int)(this.dragon.func_213302_cg() / 2.0f);
        if (this.dragon.getVariant() < 0) {
            this.drawString(this.font, Character.toString('\u2726'), x - 40, y - 40, 0xFFFF00);
        }
        int scale = (int)(-(this.dragon.func_213311_cf() * this.dragon.func_213302_cg())) + 23;
        InventoryScreen.func_228187_a_((int)x, (int)y, (int)scale, (float)(x - mouseX), (float)(y - mouseY), (LivingEntity)this.dragon);
        if (mouseX >= x - 40 && mouseY >= y - 40 && mouseX < x + 45 && mouseY < y + 15) {
            this.renderTooltip(this.toolTip, mouseX, mouseY);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void addAction(StaffAction action) {
        this.actions.add(action);
    }

    public void addTooltip(String string) {
        this.toolTip.add(string);
    }

    public static void open(AbstractDragonEntity dragon, ItemStack stack) {
        DragonStaffItem.bindDragon(dragon, stack);
        if (dragon.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((Screen)new StaffScreen(dragon));
        }
    }
}

