/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.data;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.items.LazySpawnEggItem;
import com.github.wolfshotz.wyrmroost.registry.WRBlocks;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;

class RecipeData
extends RecipeProvider {
    private static final Set<IItemProvider> REGISTERED = new HashSet<IItemProvider>();
    private Consumer<IFinishedRecipe> consumer;

    RecipeData(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        super.func_200398_a(cache);
        Set registered = REGISTERED.stream().map(IItemProvider::func_199767_j).collect(Collectors.toSet());
        for (Item item : ModUtils.getRegistryEntries(WRItems.REGISTRY)) {
            if (registered.contains(item)) continue;
            Wyrmroost.LOG.warn("Item '{}' does not have a recipe associated with it!", (Object)item.getRegistryName());
        }
    }

    private ShapedRecipeBuilder shaped(IItemProvider result, int count) {
        REGISTERED.add(result);
        return ShapedRecipeBuilder.func_200468_a((IItemProvider)result, (int)count);
    }

    private ShapedRecipeBuilder shaped(IItemProvider result) {
        return this.shaped(result, 1);
    }

    private ShapelessRecipeBuilder shapeless(IItemProvider result, int count) {
        REGISTERED.add(result);
        return ShapelessRecipeBuilder.func_200488_a((IItemProvider)result, (int)count);
    }

    private ShapelessRecipeBuilder shapeless(IItemProvider result) {
        return this.shapeless(result, 1);
    }

    private void shapeless(IItemProvider result, ShapelessPair ... ingredients) {
        ShapelessRecipeBuilder builder = this.shapeless(result);
        for (ShapelessPair ingredient : ingredients) {
            builder.func_200491_b(ingredient.item, ingredient.count);
        }
        IItemProvider firstIngredient = ingredients[0].item;
        builder.func_200483_a("has_" + firstIngredient.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200403_a(firstIngredient)).func_200482_a(this.consumer);
    }

    private void armorSet(IItemProvider material, IItemProvider helmet, IItemProvider chest, IItemProvider legs, IItemProvider boots) {
        this.shaped(helmet).func_200462_a(Character.valueOf('X'), material).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
        this.shaped(chest).func_200462_a(Character.valueOf('X'), material).func_200472_a("X X").func_200472_a("XXX").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200472_a("XXX").func_200464_a(this.consumer);
        this.shaped(legs).func_200462_a(Character.valueOf('X'), material).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200472_a("X X").func_200464_a(this.consumer);
        this.shaped(boots).func_200462_a(Character.valueOf('X'), material).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
    }

    private void armorSet(Tag<Item> materials, IItemProvider helmet, IItemProvider chest, IItemProvider legs, IItemProvider boots) {
        this.shaped(helmet).func_200469_a(Character.valueOf('X'), materials).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200464_a(this.consumer);
        this.shaped(chest).func_200469_a(Character.valueOf('X'), materials).func_200472_a("X X").func_200472_a("XXX").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200472_a("XXX").func_200464_a(this.consumer);
        this.shaped(legs).func_200469_a(Character.valueOf('X'), materials).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200472_a("X X").func_200464_a(this.consumer);
        this.shaped(boots).func_200469_a(Character.valueOf('X'), materials).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200464_a(this.consumer);
    }

    private void toolSet(IItemProvider material, IItemProvider sword, IItemProvider pick, IItemProvider axe, IItemProvider shovel, IItemProvider hoe) {
        this.shaped(sword).func_200462_a(Character.valueOf('X'), material).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("X").func_200472_a("X").func_200472_a("|").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
        this.shaped(pick).func_200462_a(Character.valueOf('X'), material).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("XXX").func_200472_a(" | ").func_200472_a(" | ").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
        this.shaped(axe).func_200462_a(Character.valueOf('X'), material).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("XX").func_200472_a("X|").func_200472_a(" |").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
        this.shaped(shovel).func_200462_a(Character.valueOf('X'), material).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("X").func_200472_a("|").func_200472_a("|").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
        this.shaped(hoe).func_200462_a(Character.valueOf('X'), material).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("XX").func_200472_a(" |").func_200472_a(" |").func_200465_a("has_material", (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
    }

    private void toolSet(Tag<Item> materials, IItemProvider sword, IItemProvider pick, IItemProvider axe, IItemProvider shovel, IItemProvider hoe) {
        this.shaped(sword).func_200469_a(Character.valueOf('X'), materials).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("X").func_200472_a("X").func_200472_a("|").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200464_a(this.consumer);
        this.shaped(pick).func_200469_a(Character.valueOf('X'), materials).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("XXX").func_200472_a(" | ").func_200472_a(" | ").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200464_a(this.consumer);
        this.shaped(axe).func_200469_a(Character.valueOf('X'), materials).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("XX").func_200472_a("X|").func_200472_a(" |").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200464_a(this.consumer);
        this.shaped(shovel).func_200469_a(Character.valueOf('X'), materials).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("X").func_200472_a("|").func_200472_a("|").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200464_a(this.consumer);
        this.shaped(hoe).func_200469_a(Character.valueOf('X'), materials).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("XX").func_200472_a(" |").func_200472_a(" |").func_200465_a("has_material", (ICriterionInstance)this.func_200409_a(materials)).func_200464_a(this.consumer);
    }

    private void storageBlock(IItemProvider material, IItemProvider block) {
        this.shaped(block).func_200462_a(Character.valueOf('X'), material).func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_" + material.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200403_a(material)).func_200464_a(this.consumer);
        this.shapeless(material, 9).func_200487_b(block).func_200483_a("has_" + block.func_199767_j().getRegistryName().func_110623_a(), (ICriterionInstance)this.func_200403_a(block)).func_200482_a(this.consumer);
    }

    private void smelt(IItemProvider ingredient, IItemProvider result, float experience, int time, boolean food) {
        String id = result.func_199767_j().getRegistryName().func_110623_a();
        String criterion = "has_" + ingredient.func_199767_j().getRegistryName().func_110623_a();
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), (IItemProvider)result, (float)experience, (int)time).func_218628_a(criterion, (ICriterionInstance)this.func_200403_a(ingredient)).func_218635_a(this.consumer, Wyrmroost.rl(id + "_from_smelting"));
        if (food) {
            CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), (IItemProvider)result, (float)experience, (int)(time + 500), (CookingRecipeSerializer)CookingRecipeSerializer.field_222174_r).func_218628_a(criterion, (ICriterionInstance)this.func_200403_a(ingredient)).func_218635_a(this.consumer, Wyrmroost.rl(id + "_from_campfire"));
            CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), (IItemProvider)result, (float)experience, (int)(time - 100), (CookingRecipeSerializer)CookingRecipeSerializer.field_222173_q).func_218628_a(criterion, (ICriterionInstance)this.func_200403_a(ingredient)).func_218635_a(this.consumer, Wyrmroost.rl(id + "_from_smoking"));
        } else {
            CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ingredient}), (IItemProvider)result, (float)experience, (int)(time - 100)).func_218628_a(criterion, (ICriterionInstance)this.func_200403_a(ingredient)).func_218635_a(this.consumer, Wyrmroost.rl(id + "_from_blasting"));
        }
        REGISTERED.add(result);
    }

    private void smelt(IItemProvider ingredient, IItemProvider result, float experience, int time) {
        this.smelt(ingredient, result, experience, time, false);
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.consumer = consumer;
        RecipeData.exempt(LazySpawnEggItem.class);
        RecipeData.exempt((IItemProvider)WRItems.DRAGON_EGG.get(), (IItemProvider)WRItems.DRAKE_BACKPLATE.get(), (IItemProvider)WRItems.LDWYRM.get(), (IItemProvider)WRItems.RAW_LOWTIER_MEAT.get(), (IItemProvider)WRItems.RAW_COMMON_MEAT.get(), (IItemProvider)WRItems.RAW_APEX_MEAT.get(), (IItemProvider)WRItems.RAW_BEHEMOTH_MEAT.get(), (IItemProvider)WRBlocks.BLUE_GEODE_ORE.get(), (IItemProvider)WRBlocks.RED_GEODE_ORE.get(), (IItemProvider)WRBlocks.PURPLE_GEODE_ORE.get(), (IItemProvider)WRBlocks.PLATINUM_ORE.get());
        this.shaped((IItemProvider)WRItems.SOUL_CRYSTAL.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)WRItems.BLUE_GEODE.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151061_bv).func_200472_a(" X ").func_200472_a("X#X").func_200472_a(" X ").func_200465_a("has_eye", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151061_bv)).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_STAFF.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)WRItems.RED_GEODE.get()).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151072_bj).func_200472_a("X").func_200472_a("|").func_200465_a("has_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.RED_GEODE.get())).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.BLUE_GEODE_ARROW.get(), 8).func_200462_a(Character.valueOf('G'), (IItemProvider)WRItems.BLUE_GEODE.get()).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_151008_G).func_200472_a("G").func_200472_a("|").func_200472_a("F").func_200465_a("has_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.BLUE_GEODE.get())).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.RED_GEODE_ARROW.get(), 8).func_200462_a(Character.valueOf('G'), (IItemProvider)WRItems.RED_GEODE.get()).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_151008_G).func_200472_a("G").func_200472_a("|").func_200472_a("F").func_200465_a("has_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.RED_GEODE.get())).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.PURPLE_GEODE_ARROW.get(), 8).func_200462_a(Character.valueOf('G'), (IItemProvider)WRItems.PURPLE_GEODE.get()).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_151008_G).func_200472_a("G").func_200472_a("|").func_200472_a("F").func_200465_a("has_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.PURPLE_GEODE.get())).func_200464_a(consumer);
        this.storageBlock((IItemProvider)WRItems.BLUE_GEODE.get(), (IItemProvider)WRBlocks.BLUE_GEODE_BLOCK.get());
        this.smelt((IItemProvider)WRBlocks.BLUE_GEODE_ORE.get(), (IItemProvider)WRItems.BLUE_GEODE.get(), 1.0f, 200);
        this.storageBlock((IItemProvider)WRItems.RED_GEODE.get(), (IItemProvider)WRBlocks.RED_GEODE_BLOCK.get());
        this.smelt((IItemProvider)WRBlocks.RED_GEODE_ORE.get(), (IItemProvider)WRItems.RED_GEODE.get(), 1.5f, 200);
        this.storageBlock((IItemProvider)WRItems.PURPLE_GEODE.get(), (IItemProvider)WRBlocks.PURPLE_GEODE_BLOCK.get());
        this.smelt((IItemProvider)WRBlocks.PURPLE_GEODE_ORE.get(), (IItemProvider)WRItems.PURPLE_GEODE.get(), 2.0f, 200);
        this.shaped((IItemProvider)WRBlocks.PLATINUM_BLOCK.get()).func_200469_a(Character.valueOf('X'), WRItems.Tags.PLATINUM).func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_platinum", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.PLATINUM_INGOT.get())).func_200464_a(consumer);
        this.shapeless((IItemProvider)WRItems.PLATINUM_INGOT.get(), 9).func_200487_b((IItemProvider)WRBlocks.PLATINUM_BLOCK.get()).func_200483_a("has_platinum", (ICriterionInstance)this.func_200403_a((IItemProvider)WRBlocks.PLATINUM_BLOCK.get())).func_200482_a(consumer);
        this.smelt((IItemProvider)WRBlocks.PLATINUM_ORE.get(), (IItemProvider)WRItems.PLATINUM_INGOT.get(), 0.7f, 200);
        this.toolSet((IItemProvider)WRItems.BLUE_GEODE.get(), (IItemProvider)WRItems.BLUE_GEODE_SWORD.get(), (IItemProvider)WRItems.BLUE_GEODE_PICKAXE.get(), (IItemProvider)WRItems.BLUE_GEODE_AXE.get(), (IItemProvider)WRItems.BLUE_GEODE_SHOVEL.get(), (IItemProvider)WRItems.BLUE_GEODE_HOE.get());
        this.toolSet((IItemProvider)WRItems.RED_GEODE.get(), (IItemProvider)WRItems.RED_GEODE_SWORD.get(), (IItemProvider)WRItems.RED_GEODE_PICKAXE.get(), (IItemProvider)WRItems.RED_GEODE_AXE.get(), (IItemProvider)WRItems.RED_GEODE_SHOVEL.get(), (IItemProvider)WRItems.RED_GEODE_HOE.get());
        this.toolSet((IItemProvider)WRItems.PURPLE_GEODE.get(), (IItemProvider)WRItems.PURPLE_GEODE_SWORD.get(), (IItemProvider)WRItems.PURPLE_GEODE_PICKAXE.get(), (IItemProvider)WRItems.PURPLE_GEODE_AXE.get(), (IItemProvider)WRItems.PURPLE_GEODE_SHOVEL.get(), (IItemProvider)WRItems.PURPLE_GEODE_HOE.get());
        this.toolSet(WRItems.Tags.PLATINUM, (IItemProvider)WRItems.PLATINUM_SWORD.get(), (IItemProvider)WRItems.PLATINUM_PICKAXE.get(), (IItemProvider)WRItems.PLATINUM_AXE.get(), (IItemProvider)WRItems.PLATINUM_SHOVEL.get(), (IItemProvider)WRItems.PLATINUM_HOE.get());
        this.armorSet((IItemProvider)WRItems.BLUE_GEODE.get(), (IItemProvider)WRItems.BLUE_GEODE_HELMET.get(), (IItemProvider)WRItems.BLUE_GEODE_CHESTPLATE.get(), (IItemProvider)WRItems.BLUE_GEODE_LEGGINGS.get(), (IItemProvider)WRItems.BLUE_GEODE_BOOTS.get());
        this.armorSet((IItemProvider)WRItems.RED_GEODE.get(), (IItemProvider)WRItems.RED_GEODE_HELMET.get(), (IItemProvider)WRItems.RED_GEODE_CHESTPLATE.get(), (IItemProvider)WRItems.RED_GEODE_LEGGINGS.get(), (IItemProvider)WRItems.RED_GEODE_BOOTS.get());
        this.armorSet((IItemProvider)WRItems.PURPLE_GEODE.get(), (IItemProvider)WRItems.PURPLE_GEODE_HELMET.get(), (IItemProvider)WRItems.PURPLE_GEODE_CHESTPLATE.get(), (IItemProvider)WRItems.PURPLE_GEODE_LEGGINGS.get(), (IItemProvider)WRItems.PURPLE_GEODE_BOOTS.get());
        this.armorSet(WRItems.Tags.PLATINUM, (IItemProvider)WRItems.PLATINUM_HELMET.get(), (IItemProvider)WRItems.PLATINUM_CHESTPLATE.get(), (IItemProvider)WRItems.PLATINUM_LEGGINGS.get(), (IItemProvider)WRItems.PLATINUM_BOOTS.get());
        this.shapeless((IItemProvider)WRItems.DRAKE_HELMET.get(), new ShapelessPair((IItemProvider)WRItems.DRAKE_BACKPLATE.get(), 3), new ShapelessPair((IItemProvider)WRItems.PLATINUM_HELMET.get()));
        this.shapeless((IItemProvider)WRItems.DRAKE_CHESTPLATE.get(), new ShapelessPair((IItemProvider)WRItems.DRAKE_BACKPLATE.get(), 6), new ShapelessPair((IItemProvider)WRItems.PLATINUM_CHESTPLATE.get()));
        this.shapeless((IItemProvider)WRItems.DRAKE_LEGGINGS.get(), new ShapelessPair((IItemProvider)WRItems.DRAKE_BACKPLATE.get(), 5), new ShapelessPair((IItemProvider)WRItems.PLATINUM_LEGGINGS.get()));
        this.shapeless((IItemProvider)WRItems.DRAKE_BOOTS.get(), new ShapelessPair((IItemProvider)WRItems.DRAKE_BACKPLATE.get(), 2), new ShapelessPair((IItemProvider)WRItems.PLATINUM_BOOTS.get()));
        this.smelt((IItemProvider)WRItems.LDWYRM.get(), (IItemProvider)WRItems.COOKED_MINUTUS.get(), 0.35f, 200, true);
        this.smelt((IItemProvider)WRItems.RAW_LOWTIER_MEAT.get(), (IItemProvider)WRItems.COOKED_LOWTIER_MEAT.get(), 0.35f, 150, true);
        this.smelt((IItemProvider)WRItems.RAW_COMMON_MEAT.get(), (IItemProvider)WRItems.COOKED_COMMON_MEAT.get(), 0.35f, 200, true);
        this.smelt((IItemProvider)WRItems.RAW_APEX_MEAT.get(), (IItemProvider)WRItems.COOKED_APEX_MEAT.get(), 0.35f, 200, true);
        this.smelt((IItemProvider)WRItems.RAW_BEHEMOTH_MEAT.get(), (IItemProvider)WRItems.COOKED_BEHEMOTH_MEAT.get(), 0.5f, 250, true);
        this.shaped((IItemProvider)WRItems.JEWELLED_APPLE.get()).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_151034_e).func_200469_a(Character.valueOf('G'), WRItems.Tags.GEODES).func_200472_a(" G ").func_200472_a("GAG").func_200472_a(" G ").func_200465_a("has_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.BLUE_GEODE.get())).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_ARMOR_IRON.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221698_bk).func_200472_a("X# ").func_200472_a("X #").func_200472_a(" X ").func_200465_a("has_iron", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151042_j)).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_ARMOR_GOLD.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221696_bj).func_200472_a("X# ").func_200472_a("X #").func_200472_a(" X ").func_200465_a("has_gold", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151043_k)).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_ARMOR_DIAMOND.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221732_cb).func_200472_a("X# ").func_200472_a("X #").func_200472_a(" X ").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151045_i)).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_ARMOR_PLATINUM.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)WRItems.PLATINUM_INGOT.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)WRBlocks.PLATINUM_BLOCK.get()).func_200472_a("X# ").func_200472_a("X #").func_200472_a(" X ").func_200465_a("has_platinum", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.PLATINUM_INGOT.get())).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_ARMOR_BLUE_GEODE.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)WRItems.BLUE_GEODE.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)WRBlocks.BLUE_GEODE_BLOCK.get()).func_200472_a("X# ").func_200472_a("X #").func_200472_a(" X ").func_200465_a("has_blue_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.BLUE_GEODE.get())).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_ARMOR_RED_GEODE.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)WRItems.RED_GEODE.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)WRBlocks.RED_GEODE_BLOCK.get()).func_200472_a("X# ").func_200472_a("X #").func_200472_a(" X ").func_200465_a("has_red_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.RED_GEODE.get())).func_200464_a(consumer);
        this.shaped((IItemProvider)WRItems.DRAGON_ARMOR_PURPLE_GEODE.get()).func_200462_a(Character.valueOf('X'), (IItemProvider)WRItems.PURPLE_GEODE.get()).func_200462_a(Character.valueOf('#'), (IItemProvider)WRBlocks.PURPLE_GEODE_BLOCK.get()).func_200472_a("X# ").func_200472_a("X #").func_200472_a(" X ").func_200465_a("has_purple_geode", (ICriterionInstance)this.func_200403_a((IItemProvider)WRItems.PURPLE_GEODE.get())).func_200464_a(consumer);
    }

    private static void exempt(IItemProvider ... exempts) {
        Collections.addAll(REGISTERED, exempts);
    }

    private static void exempt(Class<? extends IItemProvider> exemptClass) {
        HashSet<Item> set = new HashSet<Item>();
        for (Item item : ModUtils.getRegistryEntries(WRItems.REGISTRY)) {
            if (!exemptClass.isInstance(item)) continue;
            set.add(item);
        }
        REGISTERED.addAll(set);
    }

    private static class ShapelessPair {
        IItemProvider item;
        int count;

        public ShapelessPair(IItemProvider item, int count) {
            this.item = item;
            this.count = count;
        }

        public ShapelessPair(IItemProvider item) {
            this.item = item;
            this.count = 1;
        }
    }
}

