/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.data;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.registry.WRSounds;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.generators.ExistingFileHelper;

public class SoundData
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<SoundEvent> REGISTERED = new HashSet<SoundEvent>();
    private final Builder soundBuilder = new Builder();
    private final DataGenerator generator;
    private final ExistingFileHelper existingFileHelper;

    public SoundData(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.existingFileHelper = existingFileHelper;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        JsonObject json = new JsonObject();
        this.registerSounds(json);
        for (SoundEvent value : ModUtils.getRegistryEntries(WRSounds.REGISTRY)) {
            if (REGISTERED.contains(value)) continue;
            throw new IllegalArgumentException("Unregistered Sound event: " + value.func_187503_a());
        }
        IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)json, (Path)this.generator.func_200391_b().resolve("assets/wyrmroost/sounds.json"));
    }

    public void registerSounds(JsonObject json) {
        this.getBuilder((SoundEvent)WRSounds.WING_FLAP.get()).subtitle("Dragon Wing Flap").sounds(Wyrmroost::rl, "entity/other/wings/%s", "flap1", "flap2", "flap3").build(json);
        this.getBuilder((SoundEvent)WRSounds.FIRE_BREATH.get()).subtitle("Dragon Fire Breath").sound(Wyrmroost.rl("entity/other/breath/fire_breath")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_LDWYRM_IDLE.get()).subtitle("Desertwyrm Click").sounds(Wyrmroost::rl, "entity/lesser_desertwyrm/%s", "idle1", "idle2").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_SILVERGLIDER_IDLE.get()).subtitle("Silver Glider Whistles").sounds(Wyrmroost::rl, "entity/silver_glider/%s", "idle1", "idle2", "idle3", "idle4").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_SILVERGLIDER_HURT.get()).subtitle("Silver Glider Screech").sound(Wyrmroost.rl("entity/silver_glider/hurt")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_SILVERGLIDER_DEATH.get()).subtitle("Silver Glider Moan").sound(Wyrmroost.rl("entity/silver_glider/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_OWDRAKE_IDLE.get()).subtitle("Overworld Drake Snorts").sounds(Wyrmroost::rl, "entity/overworld_drake/%s", "idle1", "idle2", "idle3").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_OWDRAKE_HURT.get()).subtitle("Overworld Drake Outcry").sounds(Wyrmroost::rl, "entity/overworld_drake/%s", "idle1", "idle2", "idle3").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_OWDRAKE_DEATH.get()).subtitle("Overworld Drake Moan").sound(Wyrmroost.rl("entity/overworld_drake/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_OWDRAKE_ROAR.get()).subtitle("Overworld Drake Roar").sound(Wyrmroost.rl("entity/overworld_drake/roar")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_STALKER_IDLE.get()).subtitle("Rooststalker Clicks").sounds(Wyrmroost::rl, "entity/roost_stalker/%s", "idle1", "idle2", "idle3").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_STALKER_HURT.get()).subtitle("Rooststalker Screech").sound(Wyrmroost.rl("entity/roost_stalker/hurt")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_STALKER_DEATH.get()).subtitle("Rooststalker Moan").sound(Wyrmroost.rl("entity/roost_stalker/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_BFLY_IDLE.get()).subtitle("Butterfly Leviathan Trumpets").sounds(Wyrmroost::rl, "entity/butterfly_leviathan/%s", "idle1", "idle2", "idle3").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_BFLY_HURT.get()).subtitle("Butterfly Leviathan Outcry").sounds(Wyrmroost::rl, "entity/butterfly_leviathan/%s", "hurt1", "hurt2").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_BFLY_ROAR.get()).subtitle("Butterfly Leviathan Ascension").sound(Wyrmroost.rl("entity/butterfly_leviathan/roar")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_BFLY_DEATH.get()).subtitle("Butterfly Leviathan Death").sound(Wyrmroost.rl("entity/butterfly_leviathan/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_CANARI_IDLE.get()).subtitle("Canari Wyvern Chirps").sounds(Wyrmroost::rl, "entity/canari_wyvern/%s", "idle1", "idle2", "idle3", "idle4").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_CANARI_HURT.get()).subtitle("Canari Wyvern Screech").sounds(Wyrmroost::rl, "entity/canari_wyvern/%s", "hurt1", "hurt2", "hurt3").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_CANARI_DEATH.get()).subtitle("Canari Wyvern Death").sound(Wyrmroost.rl("entity/canari_wyvern/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_DFD_IDLE.get()).subtitle("Dragon Fruit Mumble").sounds(Wyrmroost::rl, "entity/dragonfruit_drake/%s", "idle1", "idle2", "idle3", "idle4").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_DFD_HURT.get()).subtitle("Dragon Fruit Screech").sounds(Wyrmroost::rl, "entity/dragonfruit_drake/%s", "hurt", "hurt1", "hurt2", "hurt3").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_DFD_DEATH.get()).subtitle("Dragon Fruit Moan").sound(Wyrmroost.rl("entity/dragonfruit_drake/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ROYALRED_IDLE.get()).subtitle("Royal Red Grunts").sounds(Wyrmroost::rl, "entity/royal_red/%s", "idle1", "idle2").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ROYALRED_HURT.get()).subtitle("Royal Red Scream").sounds(Wyrmroost::rl, "entity/royal_red/%s", "hurt1", "hurt2").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ROYALRED_DEATH.get()).subtitle("Royal Red Outcry").sound(Wyrmroost.rl("entity/royal_red/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ROYALRED_ROAR.get()).subtitle("Royal Red Roar").sound(Wyrmroost.rl("entity/royal_red/roar")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ALPINE_IDLE.get()).subtitle("Alpine Growls").sounds(Wyrmroost::rl, "entity/alpine/%s", "idle1", "idle2").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ALPINE_HURT.get()).subtitle("Alpine Whine").sounds(Wyrmroost::rl, "entity/alpine/%s", "hurt1", "hurt2", "hurt3").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ALPINE_ROAR.get()).subtitle("Alpine Roar").sounds(Wyrmroost::rl, "entity/alpine/%s", "roar", "roar1", "roar2").build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_ALPINE_DEATH.get()).subtitle("Alpine Screech").sound(Wyrmroost.rl("entity/alpine/death")).build(json);
        this.getBuilder((SoundEvent)WRSounds.ENTITY_COINDRAGON_IDLE.get()).subtitle("Coin Dragon Chirps").sounds(Wyrmroost::rl, "entity/coin_dragon/%s", "idle", "idle1", "idle2").build(json);
    }

    private Builder getBuilder(SoundEvent sound) {
        this.soundBuilder.sound = sound;
        this.soundBuilder.json = new JsonObject();
        return this.soundBuilder;
    }

    public String func_200397_b() {
        return "WR Sounds";
    }

    private class Builder {
        private SoundEvent sound;
        private JsonObject json;

        private Builder() {
        }

        public Builder category(SoundCategory category) {
            this.json.addProperty("category", category.func_187948_a());
            return this;
        }

        public Builder subtitle(String subtitle) {
            this.json.addProperty("subtitle", subtitle);
            return this;
        }

        public Builder sound(ResourceLocation sound, double volume, double pitch) {
            JsonArray array;
            Preconditions.checkArgument((boolean)SoundData.this.existingFileHelper.exists(sound, ResourcePackType.CLIENT_RESOURCES, ".ogg", "sounds"), (String)"Sound does not exist in any known Resourcepack: %s", (Object)sound);
            boolean flag = false;
            if (this.json.has("sounds")) {
                array = this.json.getAsJsonArray("sounds");
            } else {
                array = new JsonArray();
                flag = true;
            }
            JsonObject object = new JsonObject();
            object.addProperty("name", sound.toString());
            if (volume != 1.0) {
                object.addProperty("volume", (Number)volume);
            }
            if (pitch != 1.0) {
                object.addProperty("pitch", (Number)pitch);
            }
            array.add((JsonElement)object);
            if (flag) {
                this.json.add("sounds", (JsonElement)array);
            }
            return this;
        }

        public Builder sound(ResourceLocation path) {
            return this.sound(path, 1.0, 1.0);
        }

        public Builder sounds(Function<String, ResourceLocation> rlFunction, String path, String ... sounds) {
            for (String s : sounds) {
                this.sound(rlFunction.apply(path.replace("%s", s)), 1.0, 1.0);
            }
            return this;
        }

        public void build(JsonObject soundsFile) {
            soundsFile.add(this.sound.func_187503_a().func_110623_a(), (JsonElement)this.json);
            REGISTERED.add(this.sound);
        }
    }
}

