/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon;

import com.github.wolfshotz.wyrmroost.client.screen.StaffScreen;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.SleepController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.DefendHomeGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.FlyerWanderGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.MoveToHomeGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import com.github.wolfshotz.wyrmroost.entities.util.EntityDataEntry;
import com.github.wolfshotz.wyrmroost.items.staff.StaffAction;
import com.github.wolfshotz.wyrmroost.network.packets.AnimationPacket;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.registry.WRSounds;
import com.github.wolfshotz.wyrmroost.util.Mafs;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class CanariWyvernEntity
extends AbstractDragonEntity {
    public static final Animation FLAP_WINGS_ANIMATION = new Animation(22);
    public static final Animation PREEN_ANIMATION = new Animation(36);
    public static final Animation THREAT_ANIMATION = new Animation(40);
    public static final Animation ATTACK_ANIMATION = new Animation(15);
    public PlayerEntity pissedOffTarget;

    public CanariWyvernEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.registerDataEntry("Gender", EntityDataEntry.BOOLEAN, GENDER, true);
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
        this.registerDataEntry("Variant", EntityDataEntry.INTEGER, VARIANT, 0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new ThreatenGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new DragonBreedGoal(this));
        this.field_70714_bg.func_75776_a(8, (Goal)new FlyerWanderGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new DefendHomeGoal(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @Override
    protected BodyController func_184650_s() {
        return new BodyController((MobEntity)this);
    }

    @Override
    protected SleepController createSleepController() {
        return new SleepController(this).setHomeDefender().addSleepCondition(() -> !this.isPissed());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!(this.field_70170_p.field_72995_K || this.isPissed() || this.func_70608_bn() || this.isFlying() || this.isRiding() || !this.noActiveAnimation())) {
            double rand = this.func_70681_au().nextDouble();
            if (rand < 0.001) {
                AnimationPacket.send(this, FLAP_WINGS_ANIMATION);
            } else if (rand < 0.002) {
                AnimationPacket.send(this, PREEN_ANIMATION);
            }
        }
        if (this.getAnimation() == FLAP_WINGS_ANIMATION) {
            int tick = this.getAnimationTick();
            if (tick == 5 || tick == 12) {
                this.playSound(SoundEvents.field_206944_gn, 0.7f, 2.0f, true);
            }
            if (!this.field_70170_p.field_72995_K && tick == 9 && this.func_70681_au().nextDouble() <= 0.25) {
                this.func_70099_a(new ItemStack((IItemProvider)Items.field_151008_G), 0.5f);
            }
        } else if (this.getAnimation() == THREAT_ANIMATION && this.isPissed()) {
            this.field_70761_aq = this.field_70759_as = (float)Mafs.getAngle((Entity)this, (Entity)this.pissedOffTarget) - 270.0f;
            this.field_70177_z = this.field_70759_as;
        }
    }

    @Override
    public boolean playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        if (super.playerInteraction(player, hand, stack)) {
            return true;
        }
        if (!this.func_70909_n() && this.isFoodItem(stack) && (this.isPissed() || player.func_184812_l_() || this.func_70631_g_())) {
            this.eat(stack);
            if (!this.field_70170_p.field_72995_K) {
                this.tame(this.func_70681_au().nextDouble() < 0.2, player);
            }
            return true;
        }
        if (this.func_152114_e((LivingEntity)player) && player.func_184188_bt().size() < 3 && !player.func_225608_bj_()) {
            this.setSit(true);
            this.setFlying(false);
            this.clearAI();
            this.func_184205_a((Entity)player, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity) && entity instanceof LivingEntity) {
            int i = 5;
            switch (this.field_70170_p.func_175659_aa()) {
                case HARD: {
                    i = 15;
                    break;
                }
                case NORMAL: {
                    i = 8;
                    break;
                }
            }
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 20));
            return true;
        }
        return false;
    }

    @Override
    public void addScreenInfo(StaffScreen screen) {
        super.addScreenInfo(screen);
        screen.addAction(StaffAction.TARGET);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_CANARI_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_CANARI_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_CANARI_DEATH.get();
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, FLAP_WINGS_ANIMATION, PREEN_ANIMATION, THREAT_ANIMATION, ATTACK_ANIMATION};
    }

    @Override
    public int determineVariant() {
        return this.func_70681_au().nextInt(5);
    }

    @Override
    public int getYawRotationSpeed() {
        return this.isFlying() ? 12 : 75;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return stack.func_77973_b() == Items.field_222112_pR;
    }

    public boolean isPissed() {
        return this.pissedOffTarget != null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e).func_111128_a(0.1);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(0.1);
    }

    public static void setSpawnBiomes(Biome biome) {
        if (biome.func_201856_r() == Biome.Category.SWAMP) {
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry((EntityType)WREntities.CANARI_WYVERN.get(), 9, 2, 5));
        }
    }

    public class AttackGoal
    extends Goal {
        private int repathTimer = 10;
        private int attackDelay = 0;

        public AttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            LivingEntity target = CanariWyvernEntity.this.func_70638_az();
            return target != null && target.func_70089_S();
        }

        public boolean func_75253_b() {
            LivingEntity target = CanariWyvernEntity.this.func_70638_az();
            return target != null && target.func_70089_S() && CanariWyvernEntity.this.func_213389_a(target.func_180425_c()) && EntityPredicates.field_188444_d.test(target);
        }

        public void func_75246_d() {
            LivingEntity target = CanariWyvernEntity.this.func_70638_az();
            if ((++this.repathTimer >= 10 || CanariWyvernEntity.this.func_70661_as().func_75500_f()) && CanariWyvernEntity.this.func_70635_at().func_75522_a((Entity)target)) {
                this.repathTimer = 0;
                if (!CanariWyvernEntity.this.isFlying()) {
                    CanariWyvernEntity.this.setFlying(true);
                }
                CanariWyvernEntity.this.func_70661_as().func_75492_a(target.func_226277_ct_(), target.func_174813_aQ().field_72337_e - 2.0, target.func_226281_cx_(), 1.0);
                CanariWyvernEntity.this.func_70671_ap().func_75651_a((Entity)target, 90.0f, 90.0f);
            }
            if (--this.attackDelay <= 0 && CanariWyvernEntity.this.func_195048_a(target.func_213303_ch().func_72441_c(0.0, target.func_174813_aQ().func_216360_c(), 0.0)) <= 2.25 + (double)target.func_213311_cf()) {
                this.attackDelay = 20 + CanariWyvernEntity.this.func_70681_au().nextInt(10);
                AnimationPacket.send(CanariWyvernEntity.this, ATTACK_ANIMATION);
                CanariWyvernEntity.this.func_70652_k((Entity)target);
            }
        }

        public void func_75251_c() {
            this.repathTimer = 10;
            this.attackDelay = 0;
        }
    }

    public class ThreatenGoal
    extends Goal {
        public PlayerEntity target;

        public ThreatenGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            if (CanariWyvernEntity.this.func_70909_n()) {
                return false;
            }
            if (CanariWyvernEntity.this.isFlying()) {
                return false;
            }
            if (CanariWyvernEntity.this.func_70638_az() != null) {
                return false;
            }
            this.target = CanariWyvernEntity.this.field_70170_p.func_217366_a(CanariWyvernEntity.this.func_226277_ct_(), CanariWyvernEntity.this.func_226278_cu_(), CanariWyvernEntity.this.func_226281_cx_(), 12.0, true);
            if (this.target == null) {
                return false;
            }
            return CanariWyvernEntity.this.func_213336_c((LivingEntity)this.target);
        }

        public void func_75246_d() {
            double distFromTarget = CanariWyvernEntity.this.func_70068_e((Entity)this.target);
            if (distFromTarget > 30.0 && !CanariWyvernEntity.this.isPissed()) {
                Vec3d vec3d;
                if (CanariWyvernEntity.this.func_70661_as().func_75500_f() && (vec3d = RandomPositionGenerator.func_75461_b((CreatureEntity)CanariWyvernEntity.this, (int)16, (int)7, (Vec3d)this.target.func_213303_ch())) != null) {
                    CanariWyvernEntity.this.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.5);
                }
            } else {
                CanariWyvernEntity.this.func_70671_ap().func_75651_a((Entity)this.target, 90.0f, 90.0f);
                if (!CanariWyvernEntity.this.isPissed()) {
                    CanariWyvernEntity.this.pissedOffTarget = this.target;
                    AnimationPacket.send(CanariWyvernEntity.this, THREAT_ANIMATION);
                    CanariWyvernEntity.this.clearAI();
                }
                if (distFromTarget < 6.0) {
                    CanariWyvernEntity.this.func_70624_b((LivingEntity)this.target);
                }
            }
        }

        public void func_75251_c() {
            this.target = null;
            CanariWyvernEntity.this.pissedOffTarget = null;
        }
    }
}

