/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai;

import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import java.util.function.BooleanSupplier;

public class SleepController {
    private final AbstractDragonEntity dragon;
    public int coolDown;
    private double sleepChance = 0.01;
    private boolean nocturnal = false;
    private boolean defendsHome = false;
    private BooleanSupplier sleepConditions;
    private BooleanSupplier wakeConditions;

    public SleepController(AbstractDragonEntity dragon) {
        this.dragon = dragon;
    }

    public SleepController setSleepChance(double sleepChance) {
        this.sleepChance = sleepChance;
        return this;
    }

    public SleepController setNocturnal() {
        this.nocturnal = true;
        return this;
    }

    public SleepController setHomeDefender() {
        this.defendsHome = true;
        return this;
    }

    public SleepController addSleepCondition(BooleanSupplier sup) {
        this.sleepConditions = this.sleepConditions == null ? sup : () -> this.sleepConditions.getAsBoolean() && sup.getAsBoolean();
        return this;
    }

    public SleepController addWakeConditions(BooleanSupplier sup) {
        this.wakeConditions = this.wakeConditions == null ? sup : () -> this.wakeConditions.getAsBoolean() && sup.getAsBoolean();
        return this;
    }

    public void tick() {
        if (this.coolDown > 0) {
            --this.coolDown;
            return;
        }
        if (this.dragon.func_70608_bn()) {
            if (this.shouldWakeUp() && this.dragon.func_70681_au().nextDouble() < this.sleepChance * 0.5) {
                this.dragon.setSleeping(false);
            }
        } else if (this.shouldSleep() && this.dragon.func_70681_au().nextDouble() < this.sleepChance) {
            this.dragon.setSleeping(true);
        }
    }

    public boolean shouldSleep() {
        if (this.dragon.isIdling() && this.dragon.field_70170_p.func_72935_r() == this.nocturnal && (this.sleepConditions == null || this.sleepConditions.getAsBoolean())) {
            if (this.dragon.func_70909_n()) {
                return this.dragon.func_70906_o() || this.dragon.isAtHome() && (!this.defendsHome || (double)this.dragon.func_110143_aJ() <= (double)this.dragon.func_110138_aP() * 0.25);
            }
            return true;
        }
        return false;
    }

    public boolean shouldWakeUp() {
        return this.dragon.field_70170_p.func_72935_r() != this.nocturnal && (this.wakeConditions == null || this.wakeConditions.getAsBoolean());
    }
}

