/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals;

import com.github.wolfshotz.wyrmroost.WRConfig;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import java.util.Comparator;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.server.ServerWorld;

public class DragonBreedGoal
extends Goal {
    protected final AbstractDragonEntity dragon;
    protected final EntityPredicate predicate;
    protected AbstractDragonEntity targetMate;
    protected int spawnBabyDelay;

    public DragonBreedGoal(AbstractDragonEntity dragon) {
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.dragon = dragon;
        this.predicate = new EntityPredicate().func_221013_a((double)(dragon.func_213311_cf() * 8.0f)).func_221008_a().func_221011_b().func_221014_c().func_221012_a(e -> ((AbstractDragonEntity)e).func_70878_b((AnimalEntity)dragon));
    }

    public boolean func_75250_a() {
        if (!this.dragon.func_70880_s()) {
            return false;
        }
        int breedLimit = WRConfig.breedLimits.getOrDefault(this.dragon.func_200600_R().getRegistryName().func_110623_a(), 0);
        if (breedLimit > 0 && this.dragon.breedCount >= breedLimit) {
            this.dragon.func_70875_t();
            return false;
        }
        this.targetMate = this.getNearbyMate();
        return this.targetMate != null;
    }

    public boolean func_75253_b() {
        return this.targetMate.func_70089_S() && this.targetMate.func_70880_s() && this.dragon.func_70880_s() && this.spawnBabyDelay < 60;
    }

    public void func_75251_c() {
        this.targetMate = null;
        this.spawnBabyDelay = 0;
    }

    public void func_75246_d() {
        this.dragon.func_70671_ap().func_75651_a((Entity)this.targetMate, 10.0f, (float)this.dragon.func_70646_bf());
        this.dragon.func_70661_as().func_75497_a((Entity)this.targetMate, 1.0);
        if (++this.spawnBabyDelay >= 60 && this.dragon.func_70032_d((Entity)this.targetMate) < this.dragon.func_213311_cf() * 2.0f) {
            this.dragon.mate((ServerWorld)this.dragon.field_70170_p, (AnimalEntity)this.targetMate);
        }
    }

    @Nullable
    protected AbstractDragonEntity getNearbyMate() {
        return this.dragon.field_70170_p.func_217374_a(this.dragon.getClass(), this.predicate, (LivingEntity)this.dragon, this.dragon.func_174813_aQ().func_186662_g((double)(this.dragon.func_213311_cf() * 8.0f))).stream().min(Comparator.comparingDouble(arg_0 -> ((AbstractDragonEntity)this.dragon).func_70068_e(arg_0))).orElse(null);
    }
}

