/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragonegg;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggProperties;
import com.github.wolfshotz.wyrmroost.items.DragonEggItem;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import com.github.wolfshotz.wyrmroost.util.TickFloat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class DragonEggEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final int HATCH_ID = 1;
    private static final int WIGGLE_ID = 2;
    public static final String DATA_HATCH_TIME = "HatchTime";
    public static final String DATA_DRAGON_TYPE = "DragonType";
    private static final int UPDATE_CONDITIONS_INTERVAL = 50;
    public EntityType<AbstractDragonEntity> containedDragon;
    public DragonEggProperties properties;
    public Direction wiggleDirection = Direction.NORTH;
    public TickFloat wiggleTime = new TickFloat().setLimit(0.0f, 1.0f);
    public boolean correctConditions = false;
    public boolean wiggling = false;
    public int hatchTime;

    public DragonEggEntity(EntityType<? extends DragonEggEntity> type, World world) {
        super(type, world);
    }

    public DragonEggEntity(EntityType<AbstractDragonEntity> type, int hatchTime, World world) {
        super((EntityType)WREntities.DRAGON_EGG.get(), world);
        this.containedDragon = type;
        this.hatchTime = hatchTime;
    }

    public DragonEggEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        super((EntityType)WREntities.DRAGON_EGG.get(), world);
        this.containedDragon = ModUtils.getEntityTypeByKey(packet.getAdditionalData().func_218666_n());
    }

    protected void func_70088_a() {
    }

    public void func_70037_a(CompoundNBT compound) {
        this.containedDragon = ModUtils.getEntityTypeByKey(compound.func_74779_i(DATA_DRAGON_TYPE));
        this.hatchTime = compound.func_74762_e(DATA_HATCH_TIME);
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a(DATA_DRAGON_TYPE, this.getDragonKey());
        compound.func_74768_a(DATA_HATCH_TIME, this.hatchTime);
    }

    public String getDragonKey() {
        return EntityType.func_200718_a(this.containedDragon).toString();
    }

    public void func_70071_h_() {
        boolean flag;
        if (!this.field_70170_p.field_72995_K && this.containedDragon == null) {
            this.safeError();
            return;
        }
        super.func_70071_h_();
        this.updateMotion();
        if (this.field_70173_aa % 50 == 0 && (flag = this.getProperties().getConditions().test(this)) != this.correctConditions) {
            this.correctConditions = flag;
        }
        if (this.correctConditions) {
            if (this.field_70170_p.field_72995_K) {
                if (this.field_70173_aa % 3 == 0) {
                    double x = this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 0.2;
                    double y = this.func_226278_cu_() + this.field_70146_Z.nextDouble() + (double)(this.func_213302_cg() / 2.0f);
                    double z = this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 0.2;
                    this.field_70170_p.func_195594_a((IParticleData)new RedstoneParticleData(1.0f, 1.0f, 0.0f, 0.5f), x, y, z, 0.0, 0.0, 0.0);
                }
                this.wiggleTime.add(this.wiggling ? 0.4f : -0.4f);
                if (this.wiggleTime.get() == 1.0f) {
                    this.wiggling = false;
                }
            } else if (--this.hatchTime <= 0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)1);
                this.hatch();
            } else if (this.field_70146_Z.nextInt(Math.max(this.hatchTime / 2, 5)) == 0) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)2);
            }
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (distance > 3.0f) {
            this.crack(5);
            return true;
        }
        return false;
    }

    private void updateMotion() {
        boolean flag = this.func_213322_ci().field_72448_b <= 0.0;
        double d1 = this.func_226278_cu_();
        double d0 = 0.5;
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (!this.func_189652_ae() && !this.func_70051_ag()) {
            Vec3d vec3d2 = this.func_213322_ci();
            double d2 = flag && Math.abs(vec3d2.field_72448_b - 0.005) >= 0.003 && Math.abs(vec3d2.field_72448_b - d0 / 16.0) < 0.003 ? -0.003 : vec3d2.field_72448_b - d0 / 16.0;
            this.func_213293_j(vec3d2.field_72450_a, d2, vec3d2.field_72449_c);
        }
        Vec3d vec3d6 = this.func_213322_ci();
        if (this.field_70123_F && this.func_70038_c(vec3d6.field_72450_a, vec3d6.field_72448_b + (double)0.6f - this.func_226278_cu_() + d1, vec3d6.field_72449_c)) {
            this.func_213293_j(vec3d6.field_72450_a, 0.3f, vec3d6.field_72449_c);
        }
    }

    public void func_70103_a(byte id) {
        switch (id) {
            case 1: {
                this.hatch();
                break;
            }
            case 2: {
                this.wiggle();
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public void hatch() {
        if (!this.field_70170_p.field_72995_K) {
            AbstractDragonEntity newDragon = (AbstractDragonEntity)this.containedDragon.func_200721_a(this.field_70170_p);
            if (newDragon == null) {
                this.safeError();
                return;
            }
            newDragon.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            newDragon.func_70873_a(this.getProperties().getGrowthTime());
            newDragon.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_180425_c()), SpawnReason.BREEDING, null, null);
            this.field_70170_p.func_217376_c((Entity)newDragon);
        } else {
            this.crack(25);
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_203279_ix, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        this.func_70106_y();
    }

    public void crack(int intensity) {
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_203280_iy, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        float width = this.func_213311_cf();
        int i = 0;
        while ((float)i < width * (float)intensity) {
            double xMot = this.field_70146_Z.nextGaussian() * (double)0.2f;
            double yMot = this.field_70146_Z.nextDouble() * (double)0.45f;
            double zMot = this.field_70146_Z.nextGaussian() * (double)0.2f;
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)WRItems.DRAGON_EGG.get())), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), xMot, yMot, zMot);
            ++i;
        }
    }

    public void wiggle() {
        if (this.wiggleTime.get() > 0.0f) {
            return;
        }
        this.wiggleDirection = Direction.Plane.HORIZONTAL.func_179518_a(this.field_70146_Z);
        this.wiggling = true;
        this.crack(5);
    }

    private void safeError() {
        Wyrmroost.LOG.error("THIS ISNT A DRAGON WTF KIND OF ABOMINATION IS THIS HATCHING?!?! Unknown Entity Type for Dragon Egg @ {}", (Object)this.func_180425_c());
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack stack = DragonEggItem.getStack(this.containedDragon, this.hatchTime);
        InventoryHelper.func_180173_a((World)this.field_70170_p, (double)this.func_226277_ct_(), (double)this.func_226278_cu_(), (double)this.func_226281_cx_(), (ItemStack)stack);
        this.func_70106_y();
        return true;
    }

    public DragonEggProperties getProperties() {
        if (this.properties == null) {
            this.properties = DragonEggProperties.get(this.containedDragon);
            return this.properties;
        }
        return this.properties;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return DragonEggItem.getStack(this.containedDragon);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.getProperties().getSize();
    }

    public EntitySize getSize() {
        return this.getProperties().getSize();
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_180714_a(this.getDragonKey());
    }

    public void readSpawnData(PacketBuffer buffer) {
    }
}

