/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragonegg;

import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;

public class DragonEggProperties {
    public static final Map<EntityType<?>, DragonEggProperties> MAP = new HashMap();
    private final EntitySize size;
    private final int hatchTime;
    private Predicate<DragonEggEntity> conditions = e -> true;

    public DragonEggProperties(float width, float height, int hatchTime) {
        this.size = EntitySize.func_220311_c((float)width, (float)height);
        this.hatchTime = hatchTime;
    }

    public EntitySize getSize() {
        return this.size;
    }

    public int getHatchTime() {
        return this.hatchTime;
    }

    public int getGrowthTime() {
        return -this.hatchTime * 2;
    }

    public Predicate<DragonEggEntity> getConditions() {
        return this.conditions;
    }

    public DragonEggProperties setConditions(Predicate<DragonEggEntity> conditions) {
        this.conditions = conditions;
        return this;
    }

    public static DragonEggProperties get(EntityType<?> type) {
        DragonEggProperties props = MAP.get(type);
        if (props == null) {
            throw new NullPointerException(String.format("Missing Egg Properties for key: %s, Wolf did a hickup go scream at him", type.func_212546_e().func_150261_e()));
        }
        return props;
    }
}

