/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.registry;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.blocks.base.EXPBlock;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class WRBlocks {
    public static final DeferredRegister<Block> REGISTRY = new DeferredRegister(ForgeRegistries.BLOCKS, "wyrmroost");
    public static final RegistryObject<Block> PLATINUM_ORE = WRBlocks.register("platinum_ore", new Block(WRBlocks.builder(Material.field_151576_e).harvestLevel(1).func_200943_b(3.0f).func_200947_a(SoundType.field_185851_d)));
    public static final RegistryObject<Block> PLATINUM_BLOCK = WRBlocks.register("platinum_block", new Block(WRBlocks.builder(Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
    public static final RegistryObject<Block> BLUE_GEODE_ORE = WRBlocks.register("blue_geode_ore", (Block)new EXPBlock(3, 7, WRBlocks.builder(Material.field_151576_e).harvestLevel(2).func_200943_b(3.0f).func_200947_a(SoundType.field_185851_d)));
    public static final RegistryObject<Block> BLUE_GEODE_BLOCK = WRBlocks.register("blue_geode_block", new Block(WRBlocks.builder(Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(2).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
    public static final RegistryObject<Block> RED_GEODE_ORE = WRBlocks.register("red_geode_ore", (Block)new EXPBlock(4, 8, WRBlocks.builder(Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(3).func_200943_b(5.0f).func_200947_a(SoundType.field_185851_d)));
    public static final RegistryObject<Block> RED_GEODE_BLOCK = WRBlocks.register("red_geode_block", new Block(WRBlocks.builder(Material.field_151576_e).harvestLevel(3).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));
    public static final RegistryObject<Block> PURPLE_GEODE_ORE = WRBlocks.register("purple_geode_ore", (Block)new EXPBlock(8, 11, WRBlocks.builder(Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(4).func_200943_b(5.0f).func_200947_a(SoundType.field_185851_d)));
    public static final RegistryObject<Block> PURPLE_GEODE_BLOCK = WRBlocks.register("purple_geode_block", new Block(WRBlocks.builder(Material.field_151576_e).harvestLevel(4).func_200943_b(5.0f).func_200947_a(SoundType.field_185852_e)));

    public static RegistryObject<Block> register(String name, Block block) {
        return WRBlocks.register(name, block, () -> new BlockItem(block, WRItems.builder()));
    }

    public static RegistryObject<Block> register(String name, Block block, Supplier<Item> itemBlock) {
        WRItems.register(name, itemBlock);
        return REGISTRY.register(name, () -> block);
    }

    public static Block.Properties builder(Material material) {
        Block.Properties properties = Block.Properties.func_200945_a((Material)material);
        if (material == Material.field_151575_d) {
            properties.harvestTool(ToolType.AXE).func_200943_b(2.0f).func_200947_a(SoundType.field_185848_a);
        } else if (material == Material.field_151576_e) {
            properties.harvestTool(ToolType.PICKAXE);
        } else if (material == Material.field_151595_p) {
            properties.harvestTool(ToolType.SHOVEL).func_200947_a(SoundType.field_185855_h);
        }
        return properties;
    }

    public static class Tags {
        public static final Map<Tag<Block>, Tag<Item>> ITEM_BLOCK_TAGS = new HashMap<Tag<Block>, Tag<Item>>();
        public static final Tag<Block> STORAGE_BLOCKS_GEODE = Tags.tag(new ResourceLocation("forge", "storage_blocks/geode"));
        public static final Tag<Block> STORAGE_BLOCKS_PLATINUM = Tags.tag(new ResourceLocation("forge", "storage_blocks/platinum"));

        public static Tag<Block> tag(String name) {
            return Tags.tag(Wyrmroost.rl(name));
        }

        public static Tag<Block> tag(ResourceLocation name) {
            BlockTags.Wrapper tag = new BlockTags.Wrapper(name);
            ITEM_BLOCK_TAGS.put((Tag<Block>)tag, (Tag<Item>)new ItemTags.Wrapper(name));
            return tag;
        }
    }
}

