/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.registry;

import com.github.wolfshotz.wyrmroost.registry.WRBlocks;
import com.github.wolfshotz.wyrmroost.world.features.NoExposureReplacementFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.registries.ForgeRegistries;

public class WRWorld {
    public static List<Consumer<Biome>> BIOME_LISTENERS = new ArrayList<Consumer<Biome>>();

    public static void onBiomeLoad() {
        block4: for (Biome biome : ForgeRegistries.BIOMES) {
            BIOME_LISTENERS.forEach(e -> e.accept(biome));
            switch (biome.func_201856_r()) {
                case NETHER: {
                    biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NETHERRACK, ((Block)WRBlocks.RED_GEODE_ORE.get()).func_176223_P(), 4)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 128))));
                    continue block4;
                }
                case THEEND: {
                    biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Features.NO_EXPOSURE_REPLACE.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150377_bs.func_176223_P(), ((Block)WRBlocks.PURPLE_GEODE_ORE.get()).func_176223_P())).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(40, 0, 0, 80))));
                    continue block4;
                }
            }
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)WRBlocks.PLATINUM_ORE.get()).func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 64))));
            biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, ((Block)WRBlocks.BLUE_GEODE_ORE.get()).func_176223_P(), 10)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 0, 0, 16))));
        }
    }

    public static class Features {
        public static final Feature<ReplaceBlockConfig> NO_EXPOSURE_REPLACE = new NoExposureReplacementFeature();
    }
}

