/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.util;

import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public final class Mafs {
    public static final float PI = (float)Math.PI;

    private Mafs() {
    }

    public static double nextDouble(Random rand) {
        return 2.0 * rand.nextDouble() - 1.0;
    }

    public static Vec3d getYawVec(float yaw, double xOffset, double zOffset) {
        return new Vec3d(xOffset, 0.0, zOffset).func_178785_b(-yaw * ((float)Math.PI / 180));
    }

    public static double getAngle(double sourceX, double sourceZ, double targetX, double targetZ) {
        return MathHelper.func_181159_b((double)(targetZ - sourceZ), (double)(targetX - sourceX)) * 180.0 / Math.PI + 180.0;
    }

    public static double getAngle(Entity source, Entity target) {
        return MathHelper.func_181159_b((double)(target.func_226281_cx_() - source.func_226281_cx_()), (double)(target.func_226277_ct_() - source.func_226277_ct_())) * 57.29577951308232 + 180.0;
    }

    public static float linTerp(float a, float b, float x) {
        if (x <= 0.0f) {
            return a;
        }
        if (x >= 1.0f) {
            return b;
        }
        return a + x * (b - a);
    }

    @Nullable
    public static EntityRayTraceResult rayTraceEntities(Entity shooter, double range, @Nullable Predicate<Entity> filter) {
        Vec3d eyes = shooter.func_174824_e(1.0f);
        Vec3d end = eyes.func_178787_e(shooter.func_70040_Z().func_216372_d(range, range, range));
        Entity result = null;
        double distance = range * range;
        for (Entity entity : shooter.field_70170_p.func_175674_a(shooter, shooter.func_174813_aQ().func_186662_g(range), filter)) {
            double dist;
            Optional opt = entity.func_174813_aQ().func_186662_g(0.3).func_216365_b(eyes, end);
            if (!opt.isPresent() || !((dist = eyes.func_72436_e((Vec3d)opt.get())) < distance)) continue;
            result = entity;
            distance = dist;
        }
        return result == null ? null : new EntityRayTraceResult(result);
    }
}

