/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.util;

import com.github.wolfshotz.wyrmroost.util.Mafs;
import net.minecraft.util.math.MathHelper;

public class TickFloat {
    private float min;
    private float max;
    private float current;
    private float previous;
    private boolean clamp = false;

    public TickFloat() {
        this.previous = 0.0f;
        this.current = 0.0f;
    }

    public TickFloat(float value) {
        this.current = this.previous = value;
    }

    public TickFloat setLimit(float min, float max) {
        this.clamp = true;
        this.min = min;
        this.max = max;
        this.set(this.current);
        return this;
    }

    public float get(float x) {
        return Mafs.linTerp(this.previous, this.current, x);
    }

    public float get() {
        return this.current;
    }

    public void set(float value) {
        this.sync();
        this.current = this.clamp ? MathHelper.func_76131_a((float)value, (float)this.min, (float)this.max) : value;
    }

    public void add(float value) {
        this.sync();
        this.current += value;
        if (this.clamp) {
            this.current = MathHelper.func_76131_a((float)this.current, (float)this.min, (float)this.max);
        }
    }

    public void sync() {
        this.previous = this.current;
    }

    public float getPrevious() {
        return this.previous;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }
}

