/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.util.animation;

import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;

public interface IAnimatable {
    public static final Animation NO_ANIMATION = new Animation(0){

        @Override
        public String toString() {
            return "NO_ANIMATION";
        }
    };

    public int getAnimationTick();

    public void setAnimationTick(int var1);

    public Animation getAnimation();

    public void setAnimation(Animation var1);

    public Animation[] getAnimations();

    default public boolean noActiveAnimation() {
        return this.getAnimation() == NO_ANIMATION;
    }

    default public void updateAnimations() {
        Animation current = this.getAnimation();
        if (current != NO_ANIMATION) {
            int tick = this.getAnimationTick() + 1;
            if (tick >= current.getDuration()) {
                this.setAnimation(NO_ANIMATION);
                tick = 0;
            }
            this.setAnimationTick(tick);
        }
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IAnimatable.class, (Capability.IStorage)new Capability.IStorage<IAnimatable>(){

            @Nullable
            public INBT writeNBT(Capability<IAnimatable> capability, IAnimatable instance, Direction side) {
                return null;
            }

            public void readNBT(Capability<IAnimatable> capability, IAnimatable instance, Direction side, INBT nbt) {
            }
        }, CapImpl::new);
    }

    public static class CapImpl
    implements IAnimatable {
        @CapabilityInject(value=IAnimatable.class)
        public static final Capability<IAnimatable> CAPABILITY = null;
        private int animationTick = 0;
        private Animation animation;

        @Override
        public int getAnimationTick() {
            return this.animationTick;
        }

        @Override
        public void setAnimationTick(int tick) {
            this.animationTick = tick;
        }

        @Override
        public Animation getAnimation() {
            return this.animation;
        }

        @Override
        public void setAnimation(Animation animation) {
            this.animation = animation;
        }

        @Override
        public Animation[] getAnimations() {
            return new Animation[0];
        }
    }
}

