/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client;

import com.github.wolfshotz.wyrmroost.client.render.RenderHelper;
import com.github.wolfshotz.wyrmroost.client.render.entity.projectile.BreathWeaponRenderer;
import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.items.LazySpawnEggItem;
import com.github.wolfshotz.wyrmroost.registry.WRIO;
import com.github.wolfshotz.wyrmroost.registry.WRKeybind;
import com.github.wolfshotz.wyrmroost.util.animation.IAnimatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientEvents {
    public static final List<Runnable> CALLBACKS = new ArrayList<Runnable>();

    public static void load() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        bus.addListener(ClientEvents::clientSetup);
        bus.addListener(ClientEvents::stitchTextures);
        bus.addListener(ClientEvents::itemColors);
        forgeBus.addListener(RenderHelper::renderWorld);
        forgeBus.addListener(RenderHelper::renderEntities);
        forgeBus.addListener(ClientEvents::cameraPerspective);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        CALLBACKS.forEach(Runnable::run);
        CALLBACKS.clear();
        WRKeybind.registerKeys();
        WRIO.screenSetup();
    }

    public static void stitchTextures(TextureStitchEvent.Pre evt) {
        if (evt.getMap().func_229223_g_() == AtlasTexture.field_110575_b) {
            evt.addSprite(BreathWeaponRenderer.BLUE_FIRE);
        }
    }

    public static void itemColors(ColorHandlerEvent.Item evt) {
        ItemColors handler = evt.getItemColors();
        IItemColor eggColor = (stack, tintIndex) -> ((LazySpawnEggItem)stack.func_77973_b()).getColor(tintIndex);
        for (LazySpawnEggItem e : LazySpawnEggItem.EGG_TYPES) {
            handler.func_199877_a(eggColor, new IItemProvider[]{e});
        }
    }

    public static void cameraPerspective(EntityViewRenderEvent.CameraSetup event) {
        Minecraft mc = ClientEvents.getClient();
        Entity entity = mc.field_71439_g.func_184187_bx();
        if (!(entity instanceof AbstractDragonEntity)) {
            return;
        }
        PointOfView view = mc.field_71474_y.func_243230_g();
        if (view != PointOfView.FIRST_PERSON) {
            ((AbstractDragonEntity)entity).setMountCameraAngles(view == PointOfView.THIRD_PERSON_BACK, event);
        }
    }

    public static Minecraft getClient() {
        return Minecraft.func_71410_x();
    }

    public static ClientWorld getWorld() {
        return ClientEvents.getClient().field_71441_e;
    }

    public static PlayerEntity getPlayer() {
        return ClientEvents.getClient().field_71439_g;
    }

    public static Vector3d getProjectedView() {
        return ClientEvents.getClient().field_71460_t.func_215316_n().func_216785_c();
    }

    public static float getPartialTicks() {
        return ClientEvents.getClient().func_184121_ak();
    }

    public static boolean handleAnimationPacket(int entityID, int animationIndex) {
        ClientWorld world = ClientEvents.getWorld();
        IAnimatable entity = (IAnimatable)world.func_73045_a(entityID);
        if (animationIndex < 0) {
            entity.setAnimation(IAnimatable.NO_ANIMATION);
        } else {
            entity.setAnimation(entity.getAnimations()[animationIndex]);
        }
        return true;
    }
}

