/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.render;

import com.github.wolfshotz.wyrmroost.client.ClientEvents;
import com.github.wolfshotz.wyrmroost.client.model.ModelAnimator;
import com.github.wolfshotz.wyrmroost.client.model.WRModelRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.fog_wraith.FogWraithModel;
import com.github.wolfshotz.wyrmroost.client.render.entity.fog_wraith.FogWraithRenderer;
import com.github.wolfshotz.wyrmroost.items.FogWraithTailsItem;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import com.github.wolfshotz.wyrmroost.util.animation.IAnimatable;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FogWraithTailsStackRenderer
extends ItemStackTileEntityRenderer {
    public static final Animation TAIL_SWIPE_ANIMATION = new Animation(15);
    public static final Animation GRAPPLE_ANIMATION = new Animation(13);
    public static final FogWraithModel MODEL = new FogWraithModel();

    public void func_239207_a_(ItemStack stack, ItemCameraTransforms.TransformType transforms, MatrixStack ms, IRenderTypeBuffer typeBuffer, int light, int overlay) {
        IVertexBuilder buffer = ItemRenderer.func_229113_a_((IRenderTypeBuffer)typeBuffer, (RenderType)RenderType.func_228638_b_((ResourceLocation)FogWraithRenderer.TEXTURE), (boolean)false, (boolean)stack.func_77962_s());
        float partialTicks = ClientEvents.getPartialTicks();
        float tick = (float)ClientEvents.getPlayer().field_70173_aa + partialTicks;
        float timer = 0.0f;
        int tailUseNum = 1;
        MODEL.resetToDefaultPose();
        switch (transforms) {
            case THIRD_PERSON_LEFT_HAND: 
            case FIRST_PERSON_LEFT_HAND: {
                tailUseNum = 0;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case FIRST_PERSON_RIGHT_HAND: {
                timer = FogWraithTailsItem.getCapability((ItemStack)stack).transition.get(partialTicks);
                IAnimatable animCap = (IAnimatable)stack.getCapability(IAnimatable.CapImpl.CAPABILITY).orElseThrow(NullPointerException::new);
                ModelAnimator animator = FogWraithTailsStackRenderer.MODEL.animator;
                ModelRenderer[] parts = FogWraithTailsStackRenderer.MODEL.tails[tailUseNum];
                FogWraithTailsStackRenderer.MODEL.animator.update(animCap, partialTicks);
                if (timer > 0.0f) {
                    MODEL.setTime(timer);
                    MODEL.chainWave(parts, 0.1f, 0.05f, -2.0, tick, timer * 0.5f);
                    MODEL.rotate(parts[0], 0.8f, 0.15f, 0.0f);
                    for (ModelRenderer part : parts) {
                        MODEL.rotate(part, -0.2f, 0.0f, 0.0f);
                    }
                }
                if (animator.setAnimation(GRAPPLE_ANIMATION)) {
                    animator.startKeyframe(5);
                    animator.rotate(parts[0], -1.6f, 0.0f, 0.0f);
                    for (ModelRenderer part : parts) {
                        animator.rotate((WRModelRenderer)part, 0.2f, 0.0f, 0.0f);
                    }
                    animator.endKeyframe();
                    animator.setStaticKeyframe(5);
                    animator.resetKeyframe(3);
                    break;
                }
                if (!animator.setAnimation(TAIL_SWIPE_ANIMATION)) break;
                animator.startKeyframe(2);
                animator.rotate((WRModelRenderer)parts[0], -1.3f, 0.0f, 0.0f);
                for (ModelRenderer part : parts) {
                    animator.rotate((WRModelRenderer)part, 0.2f, 0.0f, 0.0f);
                }
                animator.endKeyframe();
                animator.setStaticKeyframe(9);
                animator.resetKeyframe(2);
                MODEL.chainSwing(parts, 0.6f, 0.75f, -2.0, (float)animCap.getAnimationTick() + partialTicks, 0.5f);
            }
        }
        for (int i = 0; i < FogWraithTailsStackRenderer.MODEL.tails.length; ++i) {
            MODEL.animateTail(i, tick, (i == tailUseNum ? -timer + 1.0f : 1.0f) * 0.5f);
            FogWraithTailsStackRenderer.MODEL.tails[i][0].func_228308_a_(ms, buffer, light, overlay);
        }
    }
}

