/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.render.entity.butterfly;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.client.render.RenderHelper;
import com.github.wolfshotz.wyrmroost.client.render.entity.AbstractDragonRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.butterfly.ButterflyLeviathanModel;
import com.github.wolfshotz.wyrmroost.entities.dragon.ButterflyLeviathanEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class ButterflyLeviathanRenderer
extends AbstractDragonRenderer<ButterflyLeviathanEntity, ButterflyLeviathanModel> {
    public static final ResourceLocation BLUE = ButterflyLeviathanRenderer.resource("body_blue.png");
    public static final ResourceLocation PURPLE = ButterflyLeviathanRenderer.resource("body_purple.png");
    public static final ResourceLocation ALBINO = ButterflyLeviathanRenderer.resource("body_albino.png");
    public static final ResourceLocation GLOW = ButterflyLeviathanRenderer.resource("activated.png");
    private static final RenderMaterial CONDUIT_CAGE_TEXTURE = new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation("entity/conduit/cage"));
    private static final RenderMaterial CONDUIT_WIND_TEXTURE = new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation("entity/conduit/wind"));
    private static final RenderMaterial CONDUIT_VERTICAL_WIND_TEXTURE = new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation("entity/conduit/wind_vertical"));
    private static final RenderMaterial CONDUIT_OPEN_EYE_TEXTURE = new RenderMaterial(PlayerContainer.field_226615_c_, new ResourceLocation("entity/conduit/open_eye"));

    public ButterflyLeviathanRenderer(EntityRendererManager manager) {
        super(manager, new ButterflyLeviathanModel(), 2.0f);
        this.func_177094_a(new LightningLayer());
        this.func_177094_a(new ConduitLayer());
    }

    @Nullable
    public ResourceLocation getEntityTexture(ButterflyLeviathanEntity entity) {
        switch (entity.getVariant()) {
            default: {
                return BLUE;
            }
            case 1: {
                return PURPLE;
            }
            case -1: 
        }
        return ALBINO;
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/butterfly_leviathan/" + png);
    }

    public class ConduitLayer
    extends LayerRenderer<ButterflyLeviathanEntity, ButterflyLeviathanModel> {
        public ModelRenderer conduitEye;
        public ModelRenderer conduitWind;
        public ModelRenderer conduitCage;

        public ConduitLayer() {
            super((IEntityRenderer)ButterflyLeviathanRenderer.this);
            this.conduitEye = new ModelRenderer(16, 16, 0, 0);
            this.conduitWind = new ModelRenderer(64, 32, 0, 0);
            this.conduitCage = new ModelRenderer(32, 16, 0, 0);
            this.conduitEye.func_228301_a_(-4.0f, -4.0f, 0.0f, 8.0f, 8.0f, 0.0f, 0.01f);
            this.conduitWind.func_228300_a_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f);
            this.conduitCage.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
        }

        public void render(MatrixStack ms, IRenderTypeBuffer buffer, int light, ButterflyLeviathanEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float tick, float netHeadYaw, float headPitch) {
            if (entity.getAnimation() == ButterflyLeviathanEntity.CONDUIT_ANIMATION && entity.getAnimationTick() < 15 || !entity.hasConduit()) {
                return;
            }
            int overlay = LivingRenderer.func_229117_c_((LivingEntity)entity, (float)ButterflyLeviathanRenderer.this.func_225625_b_((LivingEntity)entity, partialTicks));
            float rotation = tick * -0.0375f * 57.295776f;
            float translation = MathHelper.func_76126_a((float)(tick * 0.1f)) / 2.0f + 0.5f;
            translation = translation * translation + translation;
            if (!entity.func_204231_K()) {
                headPitch /= 2.0f;
            }
            ms.func_227860_a_();
            ms.func_227861_a_((double)(((ButterflyLeviathanModel)((ButterflyLeviathanRenderer)ButterflyLeviathanRenderer.this).field_77045_g).head.field_78800_c / 16.0f), (double)(((ButterflyLeviathanModel)((ButterflyLeviathanRenderer)ButterflyLeviathanRenderer.this).field_77045_g).head.field_78797_d / 16.0f), (double)(((ButterflyLeviathanModel)((ButterflyLeviathanRenderer)ButterflyLeviathanRenderer.this).field_77045_g).head.field_78798_e / 16.0f));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(netHeadYaw / 2.0f));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(headPitch));
            ms.func_227861_a_(0.0, (double)(-2.25f - entity.beachedTimer.get(partialTicks) * 1.1f), -3.65);
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)(0.3f + translation * 0.2f), 0.0);
            Vector3f vector3f = new Vector3f(0.5f, 1.0f, 0.5f);
            vector3f.func_229194_d_();
            ms.func_227863_a_(new Quaternion(vector3f, rotation, true));
            this.conduitCage.func_228308_a_(ms, CONDUIT_CAGE_TEXTURE.func_229311_a_(buffer, RenderType::func_228640_c_), light, overlay);
            ms.func_227865_b_();
            int gen = entity.field_70173_aa / 66 % 3;
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, 0.5, 0.0);
            if (gen == 1) {
                ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            } else if (gen == 2) {
                ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
            }
            IVertexBuilder builder = (gen == 1 ? CONDUIT_VERTICAL_WIND_TEXTURE : CONDUIT_WIND_TEXTURE).func_229311_a_(buffer, RenderType::func_228640_c_);
            this.conduitWind.func_228308_a_(ms, builder, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227862_a_(0.875f, 0.875f, 0.875f);
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            this.conduitWind.func_228308_a_(ms, builder, light, overlay);
            ms.func_227865_b_();
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, (double)(0.3f + translation * 0.2f), 0.0);
            ms.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(entity.field_70177_z));
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(ButterflyLeviathanRenderer.this.func_177068_d().field_217783_c.func_216778_f()));
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(ButterflyLeviathanRenderer.this.func_177068_d().field_217783_c.func_216777_e()));
            ms.func_227862_a_(0.8f, 0.8f, 0.8f);
            this.conduitEye.func_228308_a_(ms, CONDUIT_OPEN_EYE_TEXTURE.func_229311_a_(buffer, RenderType::func_228640_c_), light, overlay);
            ms.func_227865_b_();
            ms.func_227865_b_();
        }
    }

    public class LightningLayer
    extends LayerRenderer<ButterflyLeviathanEntity, ButterflyLeviathanModel> {
        public LightningLayer() {
            super((IEntityRenderer)ButterflyLeviathanRenderer.this);
        }

        public void render(MatrixStack ms, IRenderTypeBuffer buffer, int packedLight, ButterflyLeviathanEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            float alpha = MathHelper.func_76125_a((int)entity.lightningCooldown, (int)1, (int)255);
            IVertexBuilder builder = buffer.getBuffer(RenderHelper.getTranslucentGlow(GLOW));
            ((ButterflyLeviathanModel)this.func_215332_c()).func_225598_a_(ms, builder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, alpha);
        }
    }
}

