/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.render.entity.owdrake;

import com.github.wolfshotz.wyrmroost.client.model.ModelAnimator;
import com.github.wolfshotz.wyrmroost.client.model.WREntityModel;
import com.github.wolfshotz.wyrmroost.client.model.WRModelRenderer;
import com.github.wolfshotz.wyrmroost.entities.dragon.OWDrakeEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.util.math.MathHelper;

public class OWDrakeModel
extends WREntityModel<OWDrakeEntity> {
    public WRModelRenderer body1;
    public WRModelRenderer body2;
    public WRModelRenderer neck1;
    public WRModelRenderer arm1L;
    public WRModelRenderer arm1R;
    public WRModelRenderer tail1;
    public WRModelRenderer leg1L;
    public WRModelRenderer leg1R;
    public WRModelRenderer tail2;
    public WRModelRenderer tail3;
    public WRModelRenderer tail4;
    public WRModelRenderer tail5;
    public WRModelRenderer leg2L;
    public WRModelRenderer leg3L;
    public WRModelRenderer footL;
    public WRModelRenderer toe2L;
    public WRModelRenderer toe1L;
    public WRModelRenderer toe1L_1;
    public WRModelRenderer leg2R;
    public WRModelRenderer leg3R;
    public WRModelRenderer footR;
    public WRModelRenderer toe2R;
    public WRModelRenderer toe1R;
    public WRModelRenderer toe1R_1;
    public WRModelRenderer neck2;
    public WRModelRenderer head;
    public WRModelRenderer snout;
    public WRModelRenderer jaw;
    public WRModelRenderer eyeL;
    public WRModelRenderer eyeR;
    public WRModelRenderer horn11L;
    public WRModelRenderer horn11R;
    public WRModelRenderer horn31L;
    public WRModelRenderer horn31R;
    public WRModelRenderer horn51;
    public WRModelRenderer horn52;
    public WRModelRenderer horn53;
    public WRModelRenderer horn12L;
    public WRModelRenderer horn12R;
    public WRModelRenderer horn32L;
    public WRModelRenderer horn33L;
    public WRModelRenderer horn32R;
    public WRModelRenderer horn33R;
    public WRModelRenderer arm2L;
    public WRModelRenderer palmL;
    public WRModelRenderer claw21L;
    public WRModelRenderer claw11L;
    public WRModelRenderer claw22L;
    public WRModelRenderer claw12L;
    public WRModelRenderer arm2R;
    public WRModelRenderer palmR;
    public WRModelRenderer claw21R;
    public WRModelRenderer claw11R;
    public WRModelRenderer claw22R;
    public WRModelRenderer claw12R;
    private final WRModelRenderer[] headArray;
    private final WRModelRenderer[] tailArray;
    private final WRModelRenderer[] toeArray;
    private final ModelAnimator animator;
    private final float f = 0.5f;

    public OWDrakeModel() {
        this.field_78090_t = 200;
        this.field_78089_u = 200;
        this.claw12L = new WRModelRenderer(this, 129, 79);
        this.claw12L.func_78793_a(-0.05f, -0.4f, -2.2f);
        this.claw12L.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw12L, 0.91053826f, 0.0f, 0.0f);
        this.arm2L = new WRModelRenderer(this, 111, 76);
        this.arm2L.func_78793_a(1.45f, 5.5f, 0.5f);
        this.arm2L.addBox(-1.5f, 0.0f, -2.0f, 3, 7, 3, 0.0f);
        this.setRotateAngle(this.arm2L, -0.3642502f, 0.0f, 0.0f);
        this.leg3R = new WRModelRenderer(this, 60, 94);
        this.leg3R.func_78793_a(-0.05f, 4.0f, 1.8f);
        this.leg3R.addBox(-1.5f, 0.0f, -2.0f, 3, 6, 3, 0.0f);
        this.setRotateAngle(this.leg3R, -0.68294734f, 0.0f, 0.0f);
        this.eyeR = new WRModelRenderer(this, 67, 40);
        this.eyeR.field_78809_i = true;
        this.eyeR.func_78793_a(-3.5f, -2.0f, -4.0f);
        this.eyeR.addBox(-0.5f, -0.5f, -0.5f, 1, 1, 1, 0.0f);
        this.setRotateAngle(this.eyeR, 0.0f, 0.8651597f, 0.0f);
        this.claw22R = new WRModelRenderer(this, 129, 79);
        this.claw22R.func_78793_a(-0.05f, -0.4f, -2.2f);
        this.claw22R.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw22R, 0.91053826f, 0.0f, 0.0f);
        this.arm1R = new WRModelRenderer(this, 111, 61);
        this.arm1R.field_78809_i = true;
        this.arm1R.func_78793_a(-2.0f, 1.3f, -2.0f);
        this.arm1R.addBox(-3.0f, -1.0f, -2.0f, 3, 8, 4, 0.0f);
        this.setRotateAngle(this.arm1R, -0.22759093f, 0.31869712f, 0.0f);
        this.tail2 = new WRModelRenderer(this, 0, 55);
        this.tail2.func_78793_a(0.0f, 0.15f, 6.0f);
        this.tail2.addBox(-3.0f, -3.0f, 0.0f, 6, 5, 8, 0.0f);
        this.setRotateAngle(this.tail2, -0.22759093f, 0.0f, 0.0f);
        this.tail4 = new WRModelRenderer(this, 0, 85);
        this.tail4.func_78793_a(0.0f, -0.25f, 6.0f);
        this.tail4.addBox(-2.0f, -1.5f, 0.0f, 4, 3, 8, 0.0f);
        this.setRotateAngle(this.tail4, 0.18203785f, 0.0f, 0.0f);
        this.toe1R_1 = new WRModelRenderer(this, 77, 85);
        this.toe1R_1.func_78793_a(-1.4f, -0.5f, -2.5f);
        this.toe1R_1.addBox(-0.5f, -0.5f, -3.5f, 1, 2, 4, 0.0f);
        this.setRotateAngle(this.toe1R_1, -0.87266463f, 0.31869712f, 0.0f);
        this.horn12R = new WRModelRenderer(this, 95, 32);
        this.horn12R.func_78793_a(0.0f, 0.0f, 3.5f);
        this.horn12R.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 6, 0.0f);
        this.setRotateAngle(this.horn12R, -0.18203785f, 0.22759093f, 0.0f);
        this.toe2L = new WRModelRenderer(this, 77, 85);
        this.toe2L.func_78793_a(0.0f, -0.5f, -2.5f);
        this.toe2L.addBox(-0.5f, -0.5f, -3.5f, 1, 2, 4, 0.0f);
        this.setRotateAngle(this.toe2L, -0.87266463f, 0.0f, 0.0f);
        this.toe1L_1 = new WRModelRenderer(this, 77, 85);
        this.toe1L_1.func_78793_a(-1.4f, -0.5f, -2.5f);
        this.toe1L_1.addBox(-0.5f, -0.5f, -3.5f, 1, 2, 4, 0.0f);
        this.setRotateAngle(this.toe1L_1, -0.87266463f, 0.31869712f, 0.0f);
        this.footR = new WRModelRenderer(this, 60, 85);
        this.footR.func_78793_a(-0.0f, 5.5f, -0.3f);
        this.footR.addBox(-2.0f, -1.0f, -3.0f, 4, 2, 4, 0.0f);
        this.setRotateAngle(this.footR, 0.8651597f, 0.0f, 0.0f);
        this.claw12R = new WRModelRenderer(this, 129, 79);
        this.claw12R.func_78793_a(-0.05f, -0.4f, -2.2f);
        this.claw12R.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw12R, 0.91053826f, 0.0f, 0.0f);
        this.leg1L = new WRModelRenderer(this, 42, 79);
        this.leg1L.field_78809_i = true;
        this.leg1L.func_78793_a(3.0f, 1.8f, 6.0f);
        this.leg1L.addBox(0.2f, -1.2f, -2.5f, 3, 7, 5, 0.0f);
        this.toe2R = new WRModelRenderer(this, 77, 85);
        this.toe2R.func_78793_a(0.0f, -0.5f, -2.5f);
        this.toe2R.addBox(-0.5f, -0.5f, -3.5f, 1, 2, 4, 0.0f);
        this.setRotateAngle(this.toe2R, -0.87266463f, 0.0f, 0.0f);
        this.horn32R = new WRModelRenderer(this, 95, 24);
        this.horn32R.func_78793_a(0.0f, 0.0f, 3.2f);
        this.horn32R.addBox(-1.0f, -0.5f, 0.0f, 2, 1, 4, 0.0f);
        this.setRotateAngle(this.horn32R, 0.0f, -0.7740535f, -0.18203785f);
        this.horn52 = new WRModelRenderer(this, 97, 10);
        this.horn52.func_78793_a(0.05f, -3.6f, -0.2f);
        this.horn52.addBox(-1.0f, -3.0f, -1.0f, 2, 3, 2, 0.0f);
        this.setRotateAngle(this.horn52, -0.4553564f, 0.0f, 0.0f);
        this.palmR = new WRModelRenderer(this, 129, 61);
        this.palmR.func_78793_a(-0.5f, 6.5f, 0.0f);
        this.palmR.addBox(-1.5f, -1.0f, -3.0f, 4, 2, 4, 0.0f);
        this.setRotateAngle(this.palmR, 0.34906584f, 0.0f, 0.0f);
        this.leg2L = new WRModelRenderer(this, 42, 94);
        this.leg2L.field_78809_i = true;
        this.leg2L.func_78793_a(1.65f, 4.5f, -1.3f);
        this.leg2L.addBox(-1.5f, 0.0f, -1.5f, 3, 5, 4, 0.0f);
        this.setRotateAngle(this.leg2L, 0.63739425f, 0.0f, 0.0f);
        this.claw21R = new WRModelRenderer(this, 129, 71);
        this.claw21R.func_78793_a(-0.3f, 0.0f, -2.0f);
        this.claw21R.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw21R, -0.31869712f, 0.27314404f, 0.0f);
        this.horn11R = new WRModelRenderer(this, 79, 32);
        this.horn11R.func_78793_a(-3.0f, -2.0f, -0.5f);
        this.horn11R.addBox(-1.0f, -1.0f, 0.0f, 2, 2, 4, 0.0f);
        this.setRotateAngle(this.horn11R, 0.4098033f, -0.27314404f, -0.27314404f);
        this.horn12L = new WRModelRenderer(this, 95, 32);
        this.horn12L.func_78793_a(0.0f, 0.0f, 3.5f);
        this.horn12L.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 6, 0.0f);
        this.setRotateAngle(this.horn12L, -0.18203785f, -0.22759093f, 0.0f);
        this.neck1 = new WRModelRenderer(this, 40, 0);
        this.neck1.func_78793_a(0.0f, -0.5f, -3.0f);
        this.neck1.addBox(-3.5f, -3.0f, -5.0f, 7, 6, 5, 0.0f);
        this.setRotateAngle(this.neck1, -0.8196066f, 0.0f, 0.0f);
        this.horn31L = new WRModelRenderer(this, 79, 22);
        this.horn31L.func_78793_a(2.6f, 0.5f, -0.9f);
        this.horn31L.addBox(-1.5f, -1.0f, 0.0f, 3, 2, 4, 0.0f);
        this.setRotateAngle(this.horn31L, -0.3642502f, 2.003289f, 0.091106184f);
        this.horn51 = new WRModelRenderer(this, 80, 7);
        this.horn51.func_78793_a(0.0f, 0.0f, -2.6f);
        this.horn51.addBox(-1.0f, -4.0f, -1.5f, 2, 4, 3, 0.0f);
        this.setRotateAngle(this.horn51, 1.1383038f, 0.0f, 0.0f);
        this.horn32L = new WRModelRenderer(this, 95, 24);
        this.horn32L.func_78793_a(0.0f, 0.0f, 3.2f);
        this.horn32L.addBox(-1.0f, -0.5f, 0.0f, 2, 1, 4, 0.0f);
        this.setRotateAngle(this.horn32L, 0.0f, 0.7740535f, 0.18203785f);
        this.claw22L = new WRModelRenderer(this, 129, 79);
        this.claw22L.func_78793_a(-0.05f, -0.4f, -2.2f);
        this.claw22L.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw22L, 0.91053826f, 0.0f, 0.0f);
        this.eyeL = new WRModelRenderer(this, 67, 40);
        this.eyeL.func_78793_a(3.5f, -2.0f, -4.0f);
        this.eyeL.addBox(-0.5f, -0.5f, -0.5f, 1, 1, 1, 0.0f);
        this.setRotateAngle(this.eyeL, 0.0f, -0.8651597f, 0.0f);
        this.body2 = new WRModelRenderer(this, 0, 20);
        this.body2.func_78793_a(0.0f, -1.55f, 4.0f);
        this.body2.addBox(-4.5f, -2.0f, 0.0f, 9, 7, 10, 0.0f);
        this.setRotateAngle(this.body2, -0.18203785f, 0.0f, 0.0f);
        this.horn31R = new WRModelRenderer(this, 79, 22);
        this.horn31R.func_78793_a(-2.6f, 0.5f, -0.9f);
        this.horn31R.addBox(-1.5f, -1.0f, 0.0f, 3, 2, 4, 0.0f);
        this.setRotateAngle(this.horn31R, -0.3642502f, -2.003289f, -0.091106184f);
        this.horn11L = new WRModelRenderer(this, 79, 32);
        this.horn11L.func_78793_a(3.0f, -2.0f, -0.5f);
        this.horn11L.addBox(-1.0f, -1.0f, 0.0f, 2, 2, 4, 0.0f);
        this.setRotateAngle(this.horn11L, 0.4098033f, 0.27314404f, 0.27314404f);
        this.tail5 = new WRModelRenderer(this, 0, 102);
        this.tail5.func_78793_a(0.0f, -0.25f, 6.0f);
        this.tail5.addBox(-1.5f, -1.0f, 0.0f, 3, 2, 8, 0.0f);
        this.setRotateAngle(this.tail5, 0.27314404f, 0.0f, 0.0f);
        this.jaw = new WRModelRenderer(this, 72, 46);
        this.jaw.func_78793_a(0.0f, 1.35f, -4.0f);
        this.jaw.addBox(-3.0f, -1.0f, -5.0f, 6, 2, 6, 0.0f);
        this.setRotateAngle(this.jaw, 0.2f, 0.0f, 0.0f);
        this.head = new WRModelRenderer(this, 40, 29);
        this.head.func_78793_a(-0.05f, 0.05f, -4.0f);
        this.head.addBox(-4.0f, -3.0f, -4.0f, 8, 6, 4, 0.0f);
        this.setRotateAngle(this.head, 0.31869712f, 0.0f, 0.0f);
        this.tail3 = new WRModelRenderer(this, 0, 70);
        this.tail3.func_78793_a(0.0f, -0.85f, 6.0f);
        this.tail3.addBox(-2.5f, -2.0f, 0.0f, 5, 4, 8, 0.0f);
        this.setRotateAngle(this.tail3, -0.13665928f, 0.0f, 0.0f);
        this.leg1R = new WRModelRenderer(this, 42, 79);
        this.leg1R.func_78793_a(-3.0f, 1.8f, 6.0f);
        this.leg1R.addBox(-3.2f, -1.2f, -2.5f, 3, 7, 5, 0.0f);
        this.arm2R = new WRModelRenderer(this, 111, 76);
        this.arm2R.field_78809_i = true;
        this.arm2R.func_78793_a(-1.45f, 5.5f, 0.5f);
        this.arm2R.addBox(-1.5f, 0.0f, -2.0f, 3, 7, 3, 0.0f);
        this.setRotateAngle(this.arm2R, -0.3642502f, 0.0f, 0.0f);
        this.toe1L = new WRModelRenderer(this, 77, 85);
        this.toe1L.func_78793_a(1.4f, -0.5f, -2.5f);
        this.toe1L.addBox(-0.5f, -0.5f, -3.5f, 1, 2, 4, 0.0f);
        this.setRotateAngle(this.toe1L, -0.87266463f, -0.31869712f, 0.0f);
        this.claw21L = new WRModelRenderer(this, 129, 71);
        this.claw21L.func_78793_a(-0.3f, 0.0f, -2.0f);
        this.claw21L.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw21L, -0.31869712f, 0.27314404f, 0.0f);
        this.horn33R = new WRModelRenderer(this, 105, 24);
        this.horn33R.field_78809_i = true;
        this.horn33R.func_78793_a(0.5f, 0.0f, 3.5f);
        this.horn33R.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 3, 0.0f);
        this.setRotateAngle(this.horn33R, 0.0f, -0.7740535f, 0.18203785f);
        this.body1 = new WRModelRenderer(this, 0, 0);
        this.body1.func_78793_a(0.0f, -2.2f, 0.0f);
        this.body1.addBox(-4.0f, -3.5f, -5.0f, 8, 8, 10, 0.0f);
        this.setRotateAngle(this.body1, 0.22759093f, 0.0f, 0.0f);
        this.footL = new WRModelRenderer(this, 60, 85);
        this.footL.func_78793_a(-0.0f, 5.5f, -0.3f);
        this.footL.addBox(-2.0f, -1.0f, -3.0f, 4, 2, 4, 0.0f);
        this.setRotateAngle(this.footL, 0.8651597f, 0.0f, 0.0f);
        this.leg3L = new WRModelRenderer(this, 60, 94);
        this.leg3L.func_78793_a(0.05f, 4.0f, 1.8f);
        this.leg3L.addBox(-1.5f, 0.0f, -2.0f, 3, 6, 3, 0.0f);
        this.setRotateAngle(this.leg3L, -0.68294734f, 0.0f, 0.0f);
        this.toe1R = new WRModelRenderer(this, 77, 85);
        this.toe1R.func_78793_a(1.4f, -0.5f, -2.5f);
        this.toe1R.addBox(-0.5f, -0.5f, -3.5f, 1, 2, 4, 0.0f);
        this.setRotateAngle(this.toe1R, -0.87266463f, -0.31869712f, 0.0f);
        this.palmL = new WRModelRenderer(this, 129, 61);
        this.palmL.func_78793_a(-0.5f, 6.5f, 0.0f);
        this.palmL.addBox(-1.5f, -1.0f, -3.0f, 4, 2, 4, 0.0f);
        this.setRotateAngle(this.palmL, 0.34906584f, 0.0f, 0.0f);
        this.horn33L = new WRModelRenderer(this, 105, 24);
        this.horn33L.func_78793_a(-0.5f, 0.0f, 3.5f);
        this.horn33L.addBox(-0.5f, -0.5f, 0.0f, 1, 1, 3, 0.0f);
        this.setRotateAngle(this.horn33L, 0.0f, 0.7740535f, -0.18203785f);
        this.claw11R = new WRModelRenderer(this, 129, 71);
        this.claw11R.func_78793_a(1.3f, 0.0f, -2.0f);
        this.claw11R.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw11R, -0.31869712f, -0.27314404f, 0.0f);
        this.neck2 = new WRModelRenderer(this, 40, 15);
        this.neck2.func_78793_a(0.05f, 0.05f, -4.0f);
        this.neck2.addBox(-3.5f, -3.0f, -5.0f, 7, 6, 5, 0.0f);
        this.setRotateAngle(this.neck2, 0.31869712f, 0.0f, 0.0f);
        this.snout = new WRModelRenderer(this, 40, 44);
        this.snout.func_78793_a(-0.05f, -1.05f, -4.0f);
        this.snout.addBox(-3.5f, -1.5f, -6.0f, 7, 3, 7, 0.0f);
        this.setRotateAngle(this.snout, 0.18203785f, 0.0f, 0.0f);
        this.arm1L = new WRModelRenderer(this, 111, 61);
        this.arm1L.func_78793_a(2.0f, 1.3f, -2.0f);
        this.arm1L.addBox(0.0f, -1.0f, -2.0f, 3, 8, 4, 0.0f);
        this.setRotateAngle(this.arm1L, -0.22759093f, -0.31869712f, 0.0f);
        this.leg2R = new WRModelRenderer(this, 42, 94);
        this.leg2R.func_78793_a(-1.65f, 4.5f, -1.3f);
        this.leg2R.addBox(-1.5f, 0.0f, -1.5f, 3, 5, 4, 0.0f);
        this.setRotateAngle(this.leg2R, 0.63739425f, 0.0f, 0.0f);
        this.tail1 = new WRModelRenderer(this, 0, 39);
        this.tail1.func_78793_a(0.0f, 1.2f, 8.0f);
        this.tail1.addBox(-3.5f, -3.0f, 0.0f, 7, 6, 8, 0.0f);
        this.setRotateAngle(this.tail1, -0.13665928f, 0.0f, 0.0f);
        this.horn53 = new WRModelRenderer(this, 107, 10);
        this.horn53.func_78793_a(0.05f, -2.6f, -0.5f);
        this.horn53.addBox(-0.5f, -3.0f, -0.5f, 1, 3, 1, 0.0f);
        this.setRotateAngle(this.horn53, -0.68294734f, 0.0f, 0.0f);
        this.claw11L = new WRModelRenderer(this, 129, 71);
        this.claw11L.func_78793_a(1.3f, 0.0f, -2.0f);
        this.claw11L.addBox(-0.5f, -1.0f, -3.0f, 1, 2, 3, 0.0f);
        this.setRotateAngle(this.claw11L, -0.31869712f, -0.27314404f, 0.0f);
        this.claw11L.func_78792_a(this.claw12L);
        this.arm1L.func_78792_a(this.arm2L);
        this.leg2R.func_78792_a(this.leg3R);
        this.head.func_78792_a(this.eyeR);
        this.claw21R.func_78792_a(this.claw22R);
        this.body1.func_78792_a(this.arm1R);
        this.tail1.func_78792_a(this.tail2);
        this.tail3.func_78792_a(this.tail4);
        this.footR.func_78792_a(this.toe1R_1);
        this.horn11R.func_78792_a(this.horn12R);
        this.footL.func_78792_a(this.toe2L);
        this.footL.func_78792_a(this.toe1L_1);
        this.leg3R.func_78792_a(this.footR);
        this.claw11R.func_78792_a(this.claw12R);
        this.body2.func_78792_a(this.leg1L);
        this.footR.func_78792_a(this.toe2R);
        this.horn31R.func_78792_a(this.horn32R);
        this.horn51.func_78792_a(this.horn52);
        this.arm2R.func_78792_a(this.palmR);
        this.leg1L.func_78792_a(this.leg2L);
        this.palmR.func_78792_a(this.claw21R);
        this.head.func_78792_a(this.horn11R);
        this.horn11L.func_78792_a(this.horn12L);
        this.body1.func_78792_a(this.neck1);
        this.head.func_78792_a(this.horn31L);
        this.snout.func_78792_a(this.horn51);
        this.horn31L.func_78792_a(this.horn32L);
        this.claw21L.func_78792_a(this.claw22L);
        this.head.func_78792_a(this.eyeL);
        this.body1.func_78792_a(this.body2);
        this.head.func_78792_a(this.horn31R);
        this.head.func_78792_a(this.horn11L);
        this.tail4.func_78792_a(this.tail5);
        this.head.func_78792_a(this.jaw);
        this.neck2.func_78792_a(this.head);
        this.tail2.func_78792_a(this.tail3);
        this.body2.func_78792_a(this.leg1R);
        this.arm1R.func_78792_a(this.arm2R);
        this.footL.func_78792_a(this.toe1L);
        this.palmL.func_78792_a(this.claw21L);
        this.horn32R.func_78792_a(this.horn33R);
        this.leg3L.func_78792_a(this.footL);
        this.leg2L.func_78792_a(this.leg3L);
        this.footR.func_78792_a(this.toe1R);
        this.arm2L.func_78792_a(this.palmL);
        this.horn32L.func_78792_a(this.horn33L);
        this.palmR.func_78792_a(this.claw11R);
        this.neck1.func_78792_a(this.neck2);
        this.head.func_78792_a(this.snout);
        this.body1.func_78792_a(this.arm1L);
        this.leg1R.func_78792_a(this.leg2R);
        this.body2.func_78792_a(this.tail1);
        this.horn52.func_78792_a(this.horn53);
        this.palmL.func_78792_a(this.claw11L);
        this.setDefaultPose();
        this.headArray = new WRModelRenderer[]{this.neck1, this.neck2, this.head};
        this.tailArray = new WRModelRenderer[]{this.tail1, this.tail2, this.tail3, this.tail4, this.tail5};
        this.toeArray = new WRModelRenderer[]{this.toe1L, this.toe1L_1, this.toe1R, this.toe1R_1, this.toe2L, this.toe2R};
        this.animator = ModelAnimator.create();
    }

    public void func_225598_a_(MatrixStack ms, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        ms.func_227860_a_();
        ms.func_227862_a_(2.0f, 2.0f, 2.0f);
        this.body1.func_228309_a_(ms, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        ms.func_227865_b_();
    }

    public void setRotationAngles(OWDrakeEntity drake, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        netHeadYaw = MathHelper.func_76142_g((float)netHeadYaw);
        if (drake.getAnimation() != OWDrakeEntity.ROAR_ANIMATION && !drake.func_70608_bn()) {
            this.faceTarget(netHeadYaw, headPitch, 1.0f, this.neck1, this.head);
        }
    }

    public void setLivingAnimations(OWDrakeEntity drake, float limbSwing, float limbSwingAmount, float partialTick) {
        this.entity = drake;
        float frame = (float)drake.field_70173_aa + partialTick;
        this.resetToDefaultPose();
        this.animator.update(drake, partialTick);
        if (!drake.func_233684_eK_() && !drake.func_70608_bn()) {
            this.bob(this.body1, this.globalSpeed * 2.0f, 0.3f, false, limbSwing, limbSwingAmount);
            this.arm1L.walk(this.globalSpeed, 0.5f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.palmL.walk(this.globalSpeed, 0.5f, true, 2.5f, 0.0f, limbSwing, limbSwingAmount);
            this.arm1R.walk(this.globalSpeed, 0.5f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.palmR.walk(this.globalSpeed, 0.5f, false, 2.5f, 0.0f, limbSwing, limbSwingAmount);
            this.leg1L.walk(this.globalSpeed, 0.5f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.footL.walk(this.globalSpeed, 0.2f, false, 2.0f, 0.0f, limbSwing, limbSwingAmount);
            this.leg1R.walk(this.globalSpeed, 0.5f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.footR.walk(this.globalSpeed, 0.2f, true, 2.0f, 0.0f, limbSwing, limbSwingAmount);
        }
        this.sit(((OWDrakeEntity)this.entity).sitTimer.get(partialTick));
        this.sleep(((OWDrakeEntity)this.entity).sleepTimer.get(partialTick));
        if (this.animator.setAnimation(OWDrakeEntity.GRAZE_ANIMATION)) {
            this.grazeAnim(drake.getAnimationTick(), frame);
        }
        if (this.animator.setAnimation(OWDrakeEntity.HORN_ATTACK_ANIMATION)) {
            this.hornAttackAnim();
            return;
        }
        if (this.animator.setAnimation(OWDrakeEntity.ROAR_ANIMATION)) {
            this.roarAnim(drake, frame);
            return;
        }
        if (drake.func_70608_bn()) {
            this.eyeL.field_78796_g = 180.0f;
            this.eyeR.field_78796_g = 180.0f;
        }
        this.idle(frame);
    }

    @Override
    public void idle(float frame) {
        this.chainWave(this.headArray, 0.45f - this.globalSpeed, 0.05f, 0.0, frame, 0.5f);
        this.walk(this.head, 0.45f - this.globalSpeed, 0.08f, false, 2.5f, 0.0f, frame, 0.5f);
        this.walk(this.jaw, 0.45f - this.globalSpeed, 0.15f, false, 0.0f, 0.15f, frame, 0.5f);
        this.chainWave(this.tailArray, 0.45f - this.globalSpeed, 0.043f, 0.0, frame, 0.5f);
        this.chainSwing(this.tailArray, this.globalSpeed - 0.45f, 0.043f, 2.0, frame, 0.5f);
    }

    public void sit(float amount) {
        this.setTime(amount);
        this.move(this.body1, 0.0f, 5.5f, 0.0f);
        this.rotate(this.arm2L, -1.1f, 0.0f, 0.0f);
        this.rotate(this.palmL, 1.0f, 0.0f, 0.0f);
        this.rotate(this.arm2R, -1.1f, 0.0f, 0.0f);
        this.rotate(this.palmR, 1.0f, 0.0f, 0.0f);
        this.rotate(this.leg1L, 0.0f, -0.5f, 0.0f);
        this.rotate(this.leg2L, 0.35f, 0.0f, 0.0f);
        this.move(this.leg3L, 0.0f, 1.0f, -3.0f);
        this.rotate(this.leg3L, -1.9f, 0.0f, 0.0f);
        this.rotate(this.footL, 0.7f, 0.0f, 0.0f);
        this.rotate(this.leg1R, 0.0f, 0.5f, 0.0f);
        this.rotate(this.leg2R, 0.35f, 0.0f, 0.0f);
        this.move(this.leg3R, 0.0f, 1.0f, -3.0f);
        this.rotate(this.leg3R, -1.9f, 0.0f, 0.0f);
        this.rotate(this.footR, 0.7f, 0.0f, 0.0f);
        for (WRModelRenderer toeSegment : this.toeArray) {
            this.rotate(toeSegment, 0.8f, 0.0f, 0.0f);
        }
        for (WRModelRenderer tailSegment : this.tailArray) {
            this.rotate(tailSegment, 0.0f, -0.8f, 0.0f);
        }
        this.rotate(this.tail1, -0.2f, 0.0f, 0.0f);
        this.rotate(this.tail3, 0.0f, 0.0f, -0.2f);
        this.rotate(this.tail4, 0.0f, 0.0f, -0.4f);
        this.rotate(this.tail5, 0.0f, 0.8f, -0.3f);
    }

    private void sleep(float amount) {
        this.setTime(amount);
        this.rotate(this.neck1, 1.2f, 0.4f, 0.0f);
        this.rotate(this.neck2, -0.5f, 0.6f, 0.0f);
        this.rotate(this.head, -0.4f, 0.52f, -0.4f);
    }

    private void hornAttackAnim() {
        this.animator.setAnimation(OWDrakeEntity.HORN_ATTACK_ANIMATION);
        this.animator.startKeyframe(5);
        this.animator.move(this.body1, 0.0f, 2.0f, 1.0f);
        this.animator.rotate(this.body1, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.body2, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.neck1, -0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.8f, 0.0f, 0.0f);
        this.animator.rotate(this.arm1L, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.arm2L, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.palmL, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.arm1R, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.arm2R, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.palmR, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2L, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg3L, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2R, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg3R, -0.25f, 0.0f, 0.0f);
        for (WRModelRenderer segment : this.tailArray) {
            this.animator.rotate(segment, -0.05f, 0.0f, 0.0f);
        }
        this.animator.endKeyframe();
        this.animator.startKeyframe(3);
        this.animator.move(this.body1, 0.0f, 2.0f, 1.0f);
        this.animator.rotate(this.body1, 0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.body2, -0.3f, 0.0f, 0.0f);
        this.animator.rotate(this.arm1L, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.arm2L, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.palmL, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.arm1R, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.arm2R, -0.75f, 0.0f, 0.0f);
        this.animator.rotate(this.palmR, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2L, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg3L, -0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2R, 0.25f, 0.0f, 0.0f);
        this.animator.rotate(this.leg3R, -0.25f, 0.0f, 0.0f);
        for (WRModelRenderer segment : this.tailArray) {
            this.animator.rotate(segment, -0.05f, 0.0f, 0.0f);
        }
        this.animator.rotate(this.neck1, 0.3f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(2);
        this.animator.rotate(this.neck1, -0.2f, 0.0f, 0.0f);
        for (WRModelRenderer segment : this.tailArray) {
            this.animator.rotate(segment, 0.025f, 0.0f, 0.0f);
        }
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    private void grazeAnim(int animationTick, float frame) {
        this.animator.setAnimation(OWDrakeEntity.GRAZE_ANIMATION);
        this.animator.startKeyframe(12);
        this.animator.rotate(this.neck1, 1.0f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(15);
        this.animator.resetKeyframe(8);
        if (animationTick >= 8 && animationTick <= 27) {
            this.jaw.field_78795_f = (float)((double)this.jaw.field_78795_f - (6.0 + Math.sin(frame / 2.0f) * 0.25));
        }
    }

    private void roarAnim(OWDrakeEntity entity, float frame) {
        this.animator.setAnimation(OWDrakeEntity.ROAR_ANIMATION);
        this.animator.startKeyframe(14);
        this.animator.move(this.body1, 0.0f, 0.8f, 0.0f);
        this.animator.rotate(this.leg2L, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leg3L, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leg2R, 0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.leg3R, -0.2f, 0.0f, 0.0f);
        this.animator.rotate(this.neck1, -0.6f, -0.2f, 0.0f);
        this.animator.rotate(this.neck2, 0.5f, 0.0f, 0.0f);
        this.animator.rotate(this.head, 0.6f, -0.2f, 0.0f);
        this.animator.rotate(this.arm1R, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.arm2R, -0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.arm1L, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.arm2L, -0.4f, 0.0f, 0.0f);
        this.animator.endKeyframe();
        this.animator.startKeyframe(8);
        this.animator.rotate(this.neck1, 0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.neck2, -0.4f, 0.0f, 0.0f);
        this.animator.rotate(this.jaw, 0.9f, 0.0f, 0.0f);
        for (WRModelRenderer tailSegment : this.tailArray) {
            this.animator.rotate(tailSegment, 0.1f, 0.0f, 0.0f);
        }
        this.animator.endKeyframe();
        this.animator.setStaticKeyframe(60);
        this.animator.resetKeyframe(4);
        if (entity.getAnimationTick() > 10) {
            this.walk(this.jaw, this.globalSpeed + 1.5f, 0.02f, false, 0.0f, 0.0f, frame, 0.5f);
            this.swing(this.head, this.globalSpeed + 1.5f, 0.02f, false, 0.0f, 0.0f, frame, 0.5f);
            this.chainWave(this.tailArray, this.globalSpeed + 1.5f, 0.007f, 0.0, frame, 0.5f);
        }
    }
}

