/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.client.render.entity.rooststalker;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.client.model.WRModelRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.AbstractDragonRenderer;
import com.github.wolfshotz.wyrmroost.client.render.entity.rooststalker.RoostStalkerModel;
import com.github.wolfshotz.wyrmroost.entities.dragon.RoostStalkerEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.TieredItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class RoostStalkerRenderer
extends AbstractDragonRenderer<RoostStalkerEntity, RoostStalkerModel> {
    public static final ResourceLocation BODY = RoostStalkerRenderer.resource("body.png");
    public static final ResourceLocation BODY_SPE = RoostStalkerRenderer.resource("body_spe.png");
    public static final ResourceLocation BODY_XMAS = RoostStalkerRenderer.resource("body_christmas.png");
    public static final ResourceLocation BODY_GLOW = RoostStalkerRenderer.resource("body_glow.png");
    public static final ResourceLocation BODY_SPE_GLOW = RoostStalkerRenderer.resource("body_spe_glow.png");

    public RoostStalkerRenderer(EntityRendererManager manager) {
        super(manager, new RoostStalkerModel(), 0.5f);
        this.func_177094_a(new MouthItemLayer());
        this.func_177094_a(new AbstractDragonRenderer.GlowLayer(stalker -> stalker.getVariant() == -1 ? BODY_SPE_GLOW : BODY_GLOW).addCondition(r -> !r.func_70608_bn()));
    }

    @Nullable
    public ResourceLocation getEntityTexture(RoostStalkerEntity entity) {
        if (entity.getVariant() == -1) {
            return BODY_SPE;
        }
        return this.itsChristmasOMG ? BODY_XMAS : BODY;
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/roost_stalker/" + png);
    }

    class MouthItemLayer
    extends LayerRenderer<RoostStalkerEntity, RoostStalkerModel> {
        public MouthItemLayer() {
            super((IEntityRenderer)RoostStalkerRenderer.this);
        }

        public void render(MatrixStack ms, IRenderTypeBuffer bufferIn, int packedLightIn, RoostStalkerEntity stalker, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack stack = stalker.getItem();
            if (!stack.func_190926_b()) {
                ms.func_227860_a_();
                if (stalker.func_70608_bn()) {
                    ms.func_227861_a_(-0.4, 1.47, 0.1);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(135.0f));
                } else {
                    WRModelRenderer head = ((RoostStalkerModel)this.func_215332_c()).head;
                    ms.func_227861_a_((double)(head.field_78800_c / 8.0f), -((double)head.field_78797_d * 2.4), (double)(head.field_78798_e / 8.0f));
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(netHeadYaw));
                    ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(headPitch));
                    ms.func_227861_a_(0.0, stalker.func_233684_eK_() ? 0.11 : 0.03, -0.4);
                    if (stack.func_77973_b() instanceof TieredItem) {
                        ms.func_227861_a_(0.1, 0.0, 0.0);
                        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                    }
                }
                ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
                Minecraft.func_71410_x().func_175597_ag().func_228397_a_((LivingEntity)stalker, stack, ItemCameraTransforms.TransformType.GROUND, false, ms, bufferIn, packedLightIn);
                ms.func_227865_b_();
            }
        }
    }
}

