/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.data;

import com.github.wolfshotz.wyrmroost.Wyrmroost;
import com.github.wolfshotz.wyrmroost.items.CoinDragonItem;
import com.github.wolfshotz.wyrmroost.items.LazySpawnEggItem;
import com.github.wolfshotz.wyrmroost.registry.WRBlocks;
import com.github.wolfshotz.wyrmroost.registry.WRItems;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.TieredItem;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

class ModelData {
    private static ExistingFileHelper theGOODExistingFileHelper;

    ModelData() {
    }

    static void provide(DataGenerator gen, ExistingFileHelper fileHelper) {
        theGOODExistingFileHelper = fileHelper;
        gen.func_200390_a((IDataProvider)new Blocks(gen));
        gen.func_200390_a((IDataProvider)new Items(gen));
    }

    private static class Items
    extends ItemModelProvider {
        private final List<Item> REGISTERED = new ArrayList<Item>();

        public Items(DataGenerator generator) {
            super(generator, "wyrmroost", theGOODExistingFileHelper);
        }

        private static ResourceLocation resource(String path) {
            return Wyrmroost.rl("item/" + path);
        }

        public ItemModelBuilder item(Item item) {
            ItemModelBuilder builder = this.itemBare(item);
            String parent = item instanceof TieredItem ? "item/handheld" : "item/generated";
            builder.parent((ModelFile)new ModelFile.UncheckedModelFile(parent));
            ResourceLocation texture = Items.resource(item.getRegistryName().func_110623_a());
            if (theGOODExistingFileHelper.exists(texture, ResourcePackType.CLIENT_RESOURCES, ".png", "textures")) {
                builder.texture("layer0", texture);
            } else {
                Wyrmroost.LOG.warn("Missing Texture for Item: {} , model will not be registered.", (Object)texture.func_110623_a().replace("item/", ""));
            }
            return builder;
        }

        public ItemModelBuilder itemBare(Item item) {
            this.REGISTERED.add(item);
            return (ItemModelBuilder)this.getBuilder(item.getRegistryName().func_110623_a());
        }

        protected void registerModels() {
            ((ItemModelBuilder)((ItemModelBuilder)this.itemBare((Item)WRItems.DRAGON_EGG.get()).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).guiLight(BlockModel.GuiLight.FRONT)).transforms().transform(ModelBuilder.Perspective.GUI).rotation(160.0f, 8.0f, 30.0f).translation(21.0f, 6.0f, 0.0f).scale(1.5f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(180.0f, 10.0f, 4.0f).translation(13.0f, 10.0f, -10.0f).scale(1.0f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_LEFT).rotation(180.0f, 10.0f, 4.0f).translation(-2.0f, 11.0f, -12.0f).scale(1.0f).end().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(253.0f, 65.0f, 0.0f).translation(8.0f, 2.0f, 10.0f).scale(0.75f).end().transform(ModelBuilder.Perspective.THIRDPERSON_LEFT).rotation(253.0f, 65.0f, 0.0f).translation(3.0f, 13.0f, 7.0f).scale(0.75f).end().transform(ModelBuilder.Perspective.GROUND).rotation(180.0f, 0.0f, 0.0f).translation(4.0f, 8.0f, -5.0f).scale(0.55f).end();
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("desert_wyrm_alive")).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", Items.resource("desert_wyrm_alive"));
            this.item((Item)WRItems.LDWYRM.get()).override().predicate(Wyrmroost.rl("is_alive"), 1.0f).model((ModelFile)new ModelFile.UncheckedModelFile(Items.resource("desert_wyrm_alive")));
            ItemModelBuilder cdBuilder = this.item((Item)WRItems.COIN_DRAGON.get());
            IntStream.range(1, 5).forEach(i -> {
                String path = "coin_dragon" + i;
                ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", Items.resource(path));
                cdBuilder.override().predicate(CoinDragonItem.VARIANT_OVERRIDE, (float)i).model((ModelFile)new ModelFile.UncheckedModelFile(Items.resource(path)));
            });
            this.item((Item)WRItems.DRAGON_STAFF.get()).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"));
            for (LazySpawnEggItem i2 : LazySpawnEggItem.EGG_TYPES) {
                this.itemBare(i2).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/template_spawn_egg")));
            }
            for (Block block : ModUtils.getRegistryEntries(WRBlocks.REGISTRY)) {
                if (this.REGISTERED.contains(block.func_199767_j())) continue;
                if (block instanceof FlowingFluidBlock) {
                    this.itemBare(((FlowingFluidBlock)block).getFluid().func_204524_b()).parent((ModelFile)new ModelFile.UncheckedModelFile("forge:item/bucket"));
                    continue;
                }
                ResourceLocation path = block.getRegistryName();
                this.itemBare(block.func_199767_j()).parent((ModelFile)new ModelFile.UncheckedModelFile(path.func_110624_b() + ":block/" + path.func_110623_a()));
            }
            for (Item item : ModUtils.getRegistryEntries(WRItems.REGISTRY)) {
                if (this.REGISTERED.contains(item)) continue;
                this.item(item);
            }
        }

        public String func_200397_b() {
            return "Wyrmroost Item Models";
        }
    }

    private static class Blocks
    extends BlockStateProvider {
        private final List<String> MISSING_TEXTURES = new ArrayList<String>();

        public Blocks(DataGenerator generator) {
            super(generator, "wyrmroost", theGOODExistingFileHelper);
        }

        protected void registerStatesAndModels() {
            for (Block block : ModUtils.getRegistryEntries(WRBlocks.REGISTRY)) {
                if (this.registeredBlocks.containsKey(block) || block instanceof FlowingFluidBlock) continue;
                ResourceLocation name = block.getRegistryName();
                if (!theGOODExistingFileHelper.exists(new ResourceLocation(name.func_110624_b(), "block/" + name.func_110623_a()), ResourcePackType.CLIENT_RESOURCES, ".png", "textures")) {
                    this.MISSING_TEXTURES.add(name.func_110623_a().replace("block/", ""));
                    continue;
                }
                this.simpleBlock(block);
            }
            if (!this.MISSING_TEXTURES.isEmpty()) {
                Wyrmroost.LOG.error("Blocks are missing Textures! Models will not be registered: {}", (Object)this.MISSING_TEXTURES.toString());
            }
        }
    }
}

