/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon;

import com.github.wolfshotz.wyrmroost.WRConfig;
import com.github.wolfshotz.wyrmroost.client.render.RenderHelper;
import com.github.wolfshotz.wyrmroost.client.screen.StaffScreen;
import com.github.wolfshotz.wyrmroost.client.sounds.FlyingSound;
import com.github.wolfshotz.wyrmroost.containers.DragonInvContainer;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.DragonInvHandler;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.BetterPathNavigator;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.DragonBodyController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.FlyerMoveController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.FlyerPathNavigator;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.LessShitLookController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.SleepController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.WRSitGoal;
import com.github.wolfshotz.wyrmroost.entities.util.EntityDataEntry;
import com.github.wolfshotz.wyrmroost.items.DragonArmorItem;
import com.github.wolfshotz.wyrmroost.items.DragonEggItem;
import com.github.wolfshotz.wyrmroost.items.LazySpawnEggItem;
import com.github.wolfshotz.wyrmroost.items.staff.StaffAction;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.registry.WRSounds;
import com.github.wolfshotz.wyrmroost.util.Mafs;
import com.github.wolfshotz.wyrmroost.util.TickFloat;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import com.github.wolfshotz.wyrmroost.util.animation.IAnimatable;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.controller.BodyController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractDragonEntity
extends TameableEntity
implements IAnimatable {
    public static final byte HEAL_PARTICLES_DATA_ID = 8;
    public static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(AbstractDragonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(AbstractDragonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(AbstractDragonEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(AbstractDragonEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<ItemStack> ARMOR = EntityDataManager.func_187226_a(AbstractDragonEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final DataParameter<Optional<BlockPos>> HOME_POS = EntityDataManager.func_187226_a(AbstractDragonEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private final Set<String> immunes = new HashSet<String>();
    private final Set<EntityDataEntry<?>> dataEntries = new HashSet();
    public final Optional<DragonInvHandler> invHandler;
    public final TickFloat sleepTimer = new TickFloat().setLimit(0.0f, 1.0f);
    private final SleepController sleepController;
    public boolean wingsDown;
    public int breedCount;
    private Animation animation = NO_ANIMATION;
    private int animationTick;

    public AbstractDragonEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.field_70138_W = 1.0f;
        this.invHandler = Optional.ofNullable(this.createInv());
        this.sleepController = this.createSleepController();
        this.field_70749_g = new LessShitLookController((MobEntity)this);
        if (this.hasDataParameter(FLYING)) {
            this.field_70765_h = new FlyerMoveController(this);
        }
        if (this.isImmuneToArrows()) {
            this.setImmune(DamageSource.field_76367_g);
        }
        this.registerDataEntry("HomePos", EntityDataEntry.BLOCK_POS.optional(), HOME_POS, Optional.empty());
        this.registerDataEntry("BreedCount", EntityDataEntry.INTEGER, () -> this.breedCount, i -> {
            this.breedCount = i;
        });
        this.invHandler.ifPresent(i -> this.registerDataEntry("Inv", EntityDataEntry.COMPOUND, () -> ((DragonInvHandler)((Object)i)).serializeNBT(), arg_0 -> ((DragonInvHandler)((Object)i)).deserializeNBT(arg_0)));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new BetterPathNavigator((MobEntity)this);
    }

    protected BodyController func_184650_s() {
        return new DragonBodyController(this);
    }

    protected SleepController createSleepController() {
        return new SleepController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new WRSitGoal(this));
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        for (EntityDataEntry<?> entry : this.dataEntries) {
            entry.write(nbt);
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        for (EntityDataEntry<?> entry : this.dataEntries) {
            entry.read(nbt);
        }
        this.applyAttributes();
    }

    public <T> void registerDataEntry(String key, EntityDataEntry.SerializerType<T> type, Supplier<T> write, Consumer<T> read) {
        if (!this.field_70170_p.field_72995_K) {
            this.dataEntries.add(new EntityDataEntry<T>(key, type, write, read));
        }
    }

    public <T> void registerDataEntry(String key, EntityDataEntry.SerializerType<T> type, DataParameter<T> param, T value) {
        this.field_70180_af.func_187214_a(param, value);
        this.registerDataEntry(key, type, () -> this.field_70180_af.func_187225_a(param), v -> this.field_70180_af.func_187227_b(param, v));
    }

    public boolean hasDataParameter(DataParameter<?> param) {
        return this.field_70180_af.field_187234_c.containsKey(param.func_187155_a());
    }

    public int getVariant() {
        return this.hasDataParameter(VARIANT) ? (Integer)this.field_70180_af.func_187225_a(VARIANT) : 0;
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public boolean isMale() {
        return this.hasDataParameter(GENDER) ? (Boolean)this.field_70180_af.func_187225_a(GENDER) : true;
    }

    public void setGender(boolean sex) {
        this.field_70180_af.func_187227_b(GENDER, (Object)sex);
    }

    public boolean func_70608_bn() {
        return this.hasDataParameter(SLEEPING) ? (Boolean)this.field_70180_af.func_187225_a(SLEEPING) : false;
    }

    public void setSleeping(boolean sleep) {
        if (this.func_70608_bn() == sleep) {
            return;
        }
        this.field_70180_af.func_187227_b(SLEEPING, (Object)sleep);
        if (!this.field_70170_p.field_72995_K && sleep) {
            if (sleep) {
                this.clearAI();
            } else {
                this.sleepController.coolDown = 350;
            }
        }
    }

    public boolean isFlying() {
        return this.hasDataParameter(FLYING) ? (Boolean)this.field_70180_af.func_187225_a(FLYING) : false;
    }

    public void setFlying(boolean fly) {
        if (this.isFlying() == fly) {
            return;
        }
        this.field_70180_af.func_187227_b(FLYING, (Object)fly);
        if (fly) {
            if (this.liftOff()) {
                this.field_70699_by = new FlyerPathNavigator(this);
            }
        } else {
            this.field_70699_by = new BetterPathNavigator((MobEntity)this);
        }
    }

    public boolean hasArmor() {
        return this.hasDataParameter(ARMOR) && ((ItemStack)this.field_70180_af.func_187225_a(ARMOR)).func_77973_b() instanceof DragonArmorItem;
    }

    public ItemStack getArmor() {
        return this.hasDataParameter(ARMOR) ? (ItemStack)this.field_70180_af.func_187225_a(ARMOR) : ItemStack.field_190927_a;
    }

    public void setArmor(@Nullable ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof DragonArmorItem)) {
            stack = ItemStack.field_190927_a;
        }
        this.field_70180_af.func_187227_b(ARMOR, (Object)stack);
    }

    public void setSit(boolean sitting) {
        this.setSleeping(false);
        if (!this.field_70170_p.field_72995_K) {
            this.func_233687_w_(sitting);
            if (sitting) {
                this.clearAI();
            }
        }
    }

    public DragonInvHandler getInvHandler() {
        return this.invHandler.orElseThrow(() -> new NoSuchElementException("This boi doesn't have an inventory wtf are u doing"));
    }

    public DragonInvHandler createInv() {
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateAnimations();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70613_aW()) {
            boolean flying = this.shouldFly();
            if (flying != this.isFlying()) {
                this.setFlying(flying);
            }
            if (!this.func_175446_cd() && this.sleepController != null) {
                this.sleepController.tick();
            }
            if (this.func_70608_bn()) {
                ((LessShitLookController)this.func_70671_ap()).restore();
                if (this.func_110143_aJ() < this.func_110138_aP() && this.func_70681_au().nextDouble() < 0.005) {
                    this.func_70691_i(1.0f);
                }
            }
        } else {
            this.doSpecialEffects();
        }
    }

    public void func_70098_U() {
        super.func_70098_U();
        Entity entity = this.func_184187_bx();
        if (entity == null || !entity.func_70089_S()) {
            this.func_184210_p();
            return;
        }
        this.func_213317_d(Vector3d.field_186680_a);
        this.clearAI();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            int index = player.func_184188_bt().indexOf(this);
            if (player.func_225608_bj_() && !player.field_71075_bZ.field_75100_b || this.func_70090_H() || index > 2) {
                this.func_184210_p();
                this.setSit(false);
                return;
            }
            this.field_70127_C = this.field_70125_A = player.field_70125_A / 2.0f;
            this.field_70126_B = this.field_70177_z = player.field_70177_z;
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.func_70101_b(player.field_70759_as, this.field_70125_A);
            Vector3d vec3d = this.getRidingPosOffset(index);
            if (player.func_184613_cA()) {
                if (!this.canFly()) {
                    this.func_184210_p();
                    return;
                }
                vec3d = vec3d.func_186678_a(1.5);
                this.setFlying(true);
            }
            Vector3d pos = Mafs.getYawVec(player.field_70761_aq, vec3d.field_72450_a, vec3d.field_72449_c).func_72441_c(player.func_226277_ct_(), player.func_226278_cu_() + vec3d.field_72448_b, player.func_226281_cx_());
            this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    public Vector3d getRidingPosOffset(int passengerIndex) {
        double x = (double)this.func_213311_cf() * 0.5 + (double)this.func_184187_bx().func_213311_cf() * 0.5;
        switch (passengerIndex) {
            default: {
                return new Vector3d(0.0, 1.81, 0.0);
            }
            case 1: {
                return new Vector3d(x, 1.38, 0.0);
            }
            case 2: 
        }
        return new Vector3d(-x, 1.38, 0.0);
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            Vector3d offset = this.getPassengerPosOffset(passenger, this.func_184188_bt().indexOf(passenger));
            Vector3d pos = Mafs.getYawVec(this.field_70761_aq, offset.field_72450_a, offset.field_72449_c).func_72441_c(this.func_226277_ct_(), this.func_226278_cu_() + offset.field_72448_b + passenger.func_70033_W(), this.func_226281_cx_());
            passenger.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
    }

    public Vector3d getPassengerPosOffset(Entity entity, int index) {
        return new Vector3d(0.0, this.func_70042_X(), 0.0);
    }

    public ActionResultType playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        ActionResultType COMMON_SUCCESS = ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        if (this.func_152114_e((LivingEntity)player) && player.func_225608_bj_() && !this.isFlying()) {
            this.setSit(!this.func_233684_eK_());
            return COMMON_SUCCESS;
        }
        if (this.func_70909_n()) {
            if (this.isFoodItem(stack)) {
                boolean flag;
                boolean bl = flag = this.func_110143_aJ() < this.func_110138_aP();
                if (this.func_70631_g_()) {
                    this.func_175501_a((int)((float)(-this.func_70874_b() / 20) * 0.1f), true);
                    flag = true;
                }
                if (flag) {
                    this.eat(stack);
                    return COMMON_SUCCESS;
                }
            }
            if (this.func_70877_b(stack) && this.func_70874_b() == 0) {
                if (!this.field_70170_p.field_72995_K && !this.func_70880_s()) {
                    this.eat(stack);
                    this.func_146082_f(player);
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.CONSUME;
            }
        }
        if (this.func_184228_n((Entity)player) && !player.func_225608_bj_()) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184220_m((Entity)this);
                this.clearAI();
            }
            return COMMON_SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ActionResultType result = stack.func_111282_a_(player, (LivingEntity)this, hand);
        if (!result.func_226246_a_()) {
            result = this.playerInteraction(player, hand, stack);
        }
        if (result.func_226246_a_()) {
            this.setSleeping(false);
        }
        return result;
    }

    public void func_213352_e(Vector3d vec3d) {
        float speed = this.getTravelSpeed();
        if (this.func_184186_bw()) {
            LivingEntity entity = (LivingEntity)this.func_184179_bs();
            double moveY = vec3d.field_72448_b;
            double moveX = (double)entity.field_70702_br * 0.5;
            double moveZ = entity.field_191988_bg;
            this.field_70759_as = entity.field_70759_as;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            if (this.isFlying()) {
                if (entity.field_191988_bg != 0.0f) {
                    moveY = entity.func_70040_Z().field_72448_b * (double)speed * 18.0;
                }
                moveX = vec3d.field_72450_a;
                if (entity instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entity).field_71135_a.field_184345_D = false;
                }
            } else {
                speed *= 0.35f;
                if (entity.field_70703_bu && this.canFly()) {
                    this.setFlying(true);
                }
            }
            this.func_70659_e(speed);
            vec3d = new Vector3d(moveX, moveY, moveZ);
        }
        if (this.isFlying()) {
            this.func_213309_a(speed, vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)0.88f));
            Vector3d motion = this.func_213322_ci();
            if (motion.func_72433_c() < (double)0.04f) {
                this.func_213317_d(motion.func_72441_c(0.0, Math.cos((float)this.field_70173_aa * 0.1f) * (double)0.02f, 0.0));
            }
            float limbSpeed = 0.4f;
            float amount = 1.0f;
            if (this.func_226278_cu_() - this.field_70167_r < (double)-0.1f) {
                amount = 0.0f;
                limbSpeed = 0.2f;
            }
            this.field_184618_aE = this.field_70721_aZ;
            this.field_70721_aZ += (amount - this.field_70721_aZ) * limbSpeed;
            this.field_184619_aG += this.field_70721_aZ;
            return;
        }
        super.func_213352_e(vec3d);
    }

    public float getTravelSpeed() {
        return this.isFlying() ? (float)this.func_233637_b_(Attributes.field_233822_e_) : (float)this.func_233637_b_(Attributes.field_233821_d_);
    }

    public boolean shouldFly() {
        return this.canFly() && this.getAltitude() > (double)this.getFlightThreshold();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(SLEEPING) || key.equals(FLYING) || key.equals((Object)field_184755_bv)) {
            this.func_213323_x_();
            if (this.field_70170_p.field_72995_K && key == FLYING && this.isFlying() && this.func_184186_bw()) {
                FlyingSound.play(this);
            }
        } else if (key == ARMOR) {
            if (!this.field_70170_p.field_72995_K) {
                ModifiableAttributeInstance attribute = this.func_110148_a(Attributes.field_233826_i_);
                if (attribute.func_111127_a(DragonArmorItem.ARMOR_UUID) != null) {
                    attribute.func_188479_b(DragonArmorItem.ARMOR_UUID);
                }
                if (this.hasArmor()) {
                    attribute.func_233767_b_(new AttributeModifier(DragonArmorItem.ARMOR_UUID, "Armor Modifier", DragonArmorItem.getDmgReduction(this.getArmor()), AttributeModifier.Operation.ADDITION));
                    this.playSound(SoundEvents.field_187716_o, 1.0f, 1.0f, true);
                }
            }
        } else {
            super.func_184206_a(key);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 8) {
            int i = 0;
            while ((float)i < this.func_213311_cf() * this.func_213302_cg()) {
                double x = this.func_226277_ct_() + Mafs.nextDouble(this.func_70681_au()) * (double)this.func_213311_cf() + 0.4;
                double y = this.func_226278_cu_() + this.func_70681_au().nextDouble() * (double)this.func_213302_cg();
                double z = this.func_226281_cx_() + Mafs.nextDouble(this.func_70681_au()) * (double)this.func_213311_cf() + 0.4;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, x, y, z, 0.0, 0.0, 0.0);
                ++i;
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public ItemStack getStackInSlot(int slot) {
        return this.invHandler.map(i -> i.getStackInSlot(slot)).orElse(ItemStack.field_190927_a);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.invHandler.ifPresent(i -> i.setStackInSlot(slot, stack));
    }

    public void attackInBox(AxisAlignedBB box) {
        this.attackInBox(box, 0);
    }

    public void attackInBox(AxisAlignedBB box, int disabledShieldTime) {
        List attackables = this.field_70170_p.func_175647_a(LivingEntity.class, box, entity -> entity != this && !this.func_184196_w((Entity)entity) && this.func_142018_a((LivingEntity)entity, this.func_70902_q()));
        if (WRConfig.debugMode && this.field_70170_p.field_72995_K) {
            RenderHelper.DebugBox.INSTANCE.queue(box);
        }
        for (LivingEntity attacking : attackables) {
            PlayerEntity player;
            this.func_70652_k((Entity)attacking);
            if (disabledShieldTime <= 0 || !(attacking instanceof PlayerEntity) || !(player = (PlayerEntity)attacking).func_184587_cr() || !player.func_184607_cu().isShield((LivingEntity)player)) continue;
            player.func_184811_cZ().func_185145_a(Items.field_185159_cQ, disabledShieldTime);
            player.func_184602_cy();
            this.field_70170_p.func_72960_a((Entity)player, (byte)9);
        }
    }

    public AxisAlignedBB getOffsetBox(float offset) {
        return this.func_174813_aQ().func_191194_a(Vector3d.func_189986_a((float)0.0f, (float)this.field_70761_aq).func_186678_a((double)offset));
    }

    public boolean func_70652_k(Entity entity) {
        if (this.func_184191_r(entity)) {
            return false;
        }
        return super.func_70652_k(entity);
    }

    public boolean func_142018_a(LivingEntity target, @Nullable LivingEntity owner) {
        return !this.func_184191_r((Entity)target);
    }

    public boolean func_213336_c(LivingEntity target) {
        return !this.func_70631_g_() && !this.func_184186_bw() && super.func_213336_c(target);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isImmuneToArrows() && source.func_76364_f() != null) {
            EntityType attackSource = source.func_76364_f().func_200600_R();
            if (attackSource == EntityType.field_200790_d) {
                return false;
            }
            if (attackSource == WREntities.GEODE_TIPPED_ARROW.get()) {
                amount *= 0.5f;
            }
        }
        this.setSleeping(false);
        if (this.func_70902_q() != null && this.func_70902_q().func_70089_S() && amount != 0.0f) {
            this.setSit(false);
        }
        return super.func_70097_a(source, amount);
    }

    public void doSpecialEffects() {
    }

    public boolean tryTeleportToOwner() {
        if (this.func_70902_q() == null) {
            return false;
        }
        int CONSTRAINT = (int)((double)this.func_213311_cf() * 0.5) + 1;
        BlockPos pos = this.func_70902_q().func_233580_cy_();
        BlockPos.Mutable potentialPos = new BlockPos.Mutable();
        for (int x = -CONSTRAINT; x < CONSTRAINT; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = -CONSTRAINT; z < CONSTRAINT; ++z) {
                    potentialPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    if (!this.trySafeTeleport((BlockPos)potentialPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean trySafeTeleport(BlockPos pos) {
        if (this.field_70170_p.func_226665_a__((Entity)this, this.func_174813_aQ().func_186670_a(pos.func_177973_b((Vector3i)this.func_233580_cy_())))) {
            this.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, this.field_70177_z, this.field_70125_A);
            return true;
        }
        return false;
    }

    public BlockPos func_213384_dI() {
        return this.getHomePos().orElse(BlockPos.field_177992_a);
    }

    public Optional<BlockPos> getHomePos() {
        return (Optional)this.field_70180_af.func_187225_a(HOME_POS);
    }

    public void setHomePos(@Nullable BlockPos pos) {
        this.setHomePos(Optional.ofNullable(pos));
    }

    public void setHomePos(Optional<BlockPos> pos) {
        this.field_70180_af.func_187227_b(HOME_POS, pos);
    }

    public void clearHome() {
        this.setHomePos(Optional.empty());
    }

    public boolean func_213394_dL() {
        return this.getHomePos().isPresent();
    }

    public float func_213391_dJ() {
        return WRConfig.homeRadius * WRConfig.homeRadius;
    }

    public void func_213390_a(BlockPos pos, int distance) {
        this.setHomePos(pos);
    }

    public boolean func_213383_dH() {
        return this.func_213389_a(this.func_233580_cy_());
    }

    public boolean func_213389_a(BlockPos pos) {
        Optional<BlockPos> home = this.getHomePos();
        return home.map(h -> h.func_177951_i((Vector3i)pos) <= (double)this.func_213391_dJ()).orElse(true);
    }

    public boolean isAtHome() {
        return this.func_213394_dL() && this.func_213383_dH();
    }

    protected void func_213337_cE() {
        this.invHandler.ifPresent(i -> i.getStacks().forEach(arg_0 -> ((AbstractDragonEntity)this).func_199701_a_(arg_0)));
    }

    public void func_70101_b(float yaw, float pitch) {
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = pitch % 360.0f;
    }

    public double getAltitude() {
        BlockPos.Mutable pos = this.func_233580_cy_().func_239590_i_();
        while (pos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a()) {
            pos.func_196234_d(0, -1, 0);
        }
        return this.func_226278_cu_() - (double)pos.func_177956_o();
    }

    public void eat(ItemStack stack) {
        this.func_213357_a(this.field_70170_p, stack);
    }

    public ItemStack func_213357_a(World world, ItemStack stack) {
        float max = this.func_110138_aP();
        if (this.func_110143_aJ() < max) {
            this.func_70691_i(Math.max((int)max / 5, 4));
        }
        Vector3d mouth = this.getApproximateMouthPos();
        if (world.field_72995_K) {
            double width = this.func_213311_cf();
            int i = 0;
            while ((double)i < Math.max(width * width * 2.0, 12.0)) {
                Vector3d vec3d1 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1);
                vec3d1 = vec3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                vec3d1 = vec3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                world.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), mouth.field_72450_a + Mafs.nextDouble(this.func_70681_au()) * (width * 0.2), mouth.field_72448_b, mouth.field_72449_c + Mafs.nextDouble(this.func_70681_au()) * (width * 0.2), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
                ++i;
            }
        }
        world.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_213353_d(stack), SoundCategory.NEUTRAL, 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
        Item item = stack.func_77973_b();
        if (item.func_219971_r()) {
            for (Pair pair : item.func_219967_s().func_221464_f()) {
                if (world.field_72995_K || pair.getFirst() == null || !(this.field_70146_Z.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                this.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
            }
        }
        if (item.hasContainerItem(stack)) {
            this.func_70099_a(item.getContainerItem(stack), (float)(mouth.field_72448_b - this.func_226278_cu_()));
        }
        stack.func_190918_g(1);
        return stack;
    }

    public boolean tame(boolean tame, @Nullable PlayerEntity tamer) {
        if (this.func_70909_n()) {
            return true;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (tame && tamer != null && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)tamer)) {
            this.func_193101_c(tamer);
            this.func_70606_j(this.func_110138_aP());
            this.clearAI();
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            return true;
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)6);
        return false;
    }

    public void func_70691_i(float healAmount) {
        super.func_70691_i(healAmount);
        this.field_70170_p.func_72960_a((Entity)this, (byte)8);
    }

    public int getYawRotationSpeed() {
        return this.isFlying() ? 6 : 75;
    }

    public boolean isRiding() {
        return this.func_184187_bx() != null;
    }

    public boolean func_70878_b(AnimalEntity mate) {
        AbstractDragonEntity dragon = (AbstractDragonEntity)mate;
        if (this.func_233684_eK_() || dragon.func_233684_eK_()) {
            return false;
        }
        if (this.hasDataParameter(GENDER) && this.isMale() == dragon.isMale()) {
            return false;
        }
        return super.func_70878_b(mate);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    public void func_234177_a_(ServerWorld world, AnimalEntity mate) {
        ItemStack eggStack = DragonEggItem.getStack(this.func_200600_R());
        ItemEntity eggItem = new ItemEntity((World)world, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), eggStack);
        eggItem.func_213293_j(0.0, (double)(this.func_213302_cg() / 3.0f), 0.0);
        world.func_217376_c((Entity)eggItem);
        ++this.breedCount;
        ++((AbstractDragonEntity)mate).breedCount;
        ServerPlayerEntity serverplayerentity = this.func_191993_do();
        if (serverplayerentity == null && mate.func_191993_do() != null) {
            serverplayerentity = mate.func_191993_do();
        }
        if (serverplayerentity != null) {
            serverplayerentity.func_195066_a(Stats.field_151186_x);
        }
        this.func_70873_a(6000);
        mate.func_70873_a(6000);
        this.func_70875_t();
        mate.func_70875_t();
        if (world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_70681_au().nextInt(7) + 1));
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184179_bs() == passenger && this.func_152114_e((LivingEntity)passenger)) {
            this.clearAI();
            this.setSit(false);
            this.clearHome();
        }
    }

    @Nullable
    public PlayerEntity getControllingPlayer() {
        Entity passenger = this.func_184179_bs();
        if (passenger instanceof PlayerEntity) {
            return (PlayerEntity)passenger;
        }
        return null;
    }

    public void clearAI() {
        this.field_70703_bu = false;
        this.field_70699_by.func_75499_g();
        this.func_70624_b(null);
        this.func_70604_c(null);
        this.func_191989_p(0.0f);
        this.func_70657_f(0.0f);
    }

    public boolean isIdling() {
        return this.func_70661_as().func_75500_f() && this.func_70638_az() == null && !this.func_184207_aI() && !this.func_203005_aq() && !this.isFlying();
    }

    @Nullable
    public SleepController getSleepController() {
        return this.sleepController;
    }

    public Vector3d getApproximateMouthPos() {
        Vector3d position = this.func_174824_e(1.0f).func_178786_a(0.0, 0.75, 0.0);
        double dist = (double)(this.func_213311_cf() / 2.0f) + 0.75;
        return position.func_178787_e(this.func_174806_f(this.field_70125_A, this.field_70759_as).func_186678_a(dist));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)LazySpawnEggItem.getEggFor(this.func_200600_R()));
    }

    public List<LivingEntity> getEntitiesNearby(double radius, Predicate<LivingEntity> filter) {
        return this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(radius), filter.and(e -> e != this));
    }

    public boolean func_184191_r(Entity entity) {
        if (entity == this) {
            return true;
        }
        if (entity instanceof LivingEntity && this.func_152114_e((LivingEntity)entity)) {
            return true;
        }
        if (entity instanceof TameableEntity && this.func_70902_q() != null && this.func_70902_q().equals((Object)((TameableEntity)entity).func_70902_q())) {
            return true;
        }
        return entity.func_184194_a(this.func_96124_cp());
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        this.playSound(soundIn, volume, pitch, false);
    }

    public void playSound(SoundEvent sound, float volume, float pitch, boolean local) {
        if (this.func_174814_R()) {
            return;
        }
        volume *= this.func_70599_aP();
        pitch *= this.func_70647_i();
        if (local) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), sound, this.func_184176_by(), volume, pitch, false);
        } else {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), sound, this.func_184176_by(), volume, pitch);
        }
    }

    public void func_70642_aH() {
        if (!this.func_70608_bn()) {
            super.func_70642_aH();
        }
    }

    public void flapWings() {
        this.playSound((SoundEvent)WRSounds.WING_FLAP.get(), 3.0f, 1.0f, true);
    }

    public void setImmune(DamageSource source) {
        this.immunes.add(source.func_76355_l());
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.isRiding() && source == DamageSource.field_76368_d) {
            return true;
        }
        if (!this.immunes.isEmpty() && this.immunes.contains(source.func_76355_l())) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData data, @Nullable CompoundNBT dataTag) {
        if (this.hasDataParameter(GENDER)) {
            this.setGender(this.func_70681_au().nextBoolean());
        }
        if (this.hasDataParameter(VARIANT)) {
            this.setVariant(this.determineVariant());
        }
        this.applyAttributes();
        return super.func_213386_a(world, difficulty, reason, data, dataTag);
    }

    public void applyAttributes() {
    }

    public int determineVariant() {
        return 0;
    }

    public boolean func_70067_L() {
        return super.func_70067_L() && !this.isRiding();
    }

    public boolean func_184186_bw() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            return this.func_152114_e((LivingEntity)player) && (!this.field_70170_p.field_72995_K || player.func_175144_cb());
        }
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        List passengers = this.func_184188_bt();
        return passengers.isEmpty() ? null : (Entity)passengers.get(0);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public void recievePassengerKeybind(int key, int mods, boolean pressed) {
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() || this.func_70608_bn() || this.isRiding();
    }

    public boolean canFly() {
        return !this.func_70631_g_() && !this.func_204231_K() && !this.isRiding();
    }

    protected float func_175134_bD() {
        if (this.canFly()) {
            return this.func_213302_cg() * this.func_226269_ah_() * 0.6f;
        }
        return super.func_175134_bD();
    }

    public boolean liftOff() {
        if (!this.canFly()) {
            return false;
        }
        if (!this.field_70122_E) {
            return true;
        }
        int heightDiff = this.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING, (int)this.func_226277_ct_(), (int)this.func_226281_cx_()) - (int)this.func_226278_cu_();
        if (heightDiff > 0 && heightDiff <= this.getFlightThreshold()) {
            return false;
        }
        this.setSit(false);
        this.setSleeping(false);
        this.func_70664_aZ();
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.canFly()) {
            return false;
        }
        return super.func_225503_b_(distance - (float)((int)((double)this.func_213302_cg() * 0.8)), damageMultiplier);
    }

    public int getFlightThreshold() {
        return (int)this.func_213302_cg();
    }

    public void setMountCameraAngles(boolean backView, EntityViewRenderEvent.CameraSetup event) {
    }

    public boolean isImmuneToArrows() {
        return false;
    }

    public void addScreenInfo(StaffScreen screen) {
        screen.addAction(StaffAction.HOME);
        screen.addAction(StaffAction.SIT);
        screen.addTooltip(new StringTextComponent(Character.toString('\u2764')).func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)new StringTextComponent(String.format(" %s / %s", (int)(this.func_110143_aJ() / 2.0f), (int)this.func_110138_aP() / 2)).func_240699_a_(TextFormatting.WHITE)).getString());
        if (this.hasDataParameter(GENDER)) {
            boolean isMale = this.isMale();
            screen.addTooltip(new TranslationTextComponent("entity.wyrmroost.dragons.gender." + (isMale ? "male" : "female")).func_240699_a_(isMale ? TextFormatting.DARK_AQUA : TextFormatting.RED).getString());
        }
    }

    public void addContainerInfo(DragonInvContainer container) {
        container.makePlayerSlots(container.playerInv, 17, 136);
    }

    public void onInvContentsChanged(int slot, ItemStack stack, boolean onLoad) {
    }

    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
        if (this.func_233684_eK_() || this.func_70608_bn()) {
            size = size.func_220312_a(1.0f, 0.5f);
        }
        return size;
    }

    protected int func_70693_a(PlayerEntity player) {
        return Math.max((int)((double)(this.func_213311_cf() * this.func_213302_cg()) * 0.25) + this.func_70681_au().nextInt(3), super.func_70693_a(player));
    }

    public boolean func_70877_b(ItemStack stack) {
        return this.isFoodItem(stack);
    }

    public abstract boolean isFoodItem(ItemStack var1);

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        if (animation == null) {
            animation = NO_ANIMATION;
        }
        this.setAnimationTick(0);
        this.animation = animation;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public static boolean canFlyerSpawn(EntityType<? extends AbstractDragonEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_180495_p(pos.func_177977_b()).func_204520_s().func_206888_e();
    }
}

