/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon;

import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.SleepController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.DragonBreedGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.MoveToHomeGoal;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.WRFollowOwnerGoal;
import com.github.wolfshotz.wyrmroost.entities.dragonegg.DragonEggProperties;
import com.github.wolfshotz.wyrmroost.entities.util.AnonymousGoals;
import com.github.wolfshotz.wyrmroost.entities.util.EntityDataEntry;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.registry.WRSounds;
import com.github.wolfshotz.wyrmroost.util.Mafs;
import com.github.wolfshotz.wyrmroost.util.ModUtils;
import com.github.wolfshotz.wyrmroost.util.TickFloat;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class DragonFruitDrakeEntity
extends AbstractDragonEntity
implements IForgeShearable {
    private static final int CROP_GROWTH_RADIUS = 5;
    private static final int CROP_GROWTH_TIME = 1200;
    public static final Animation BITE_ANIMATION = new Animation(15);
    public final TickFloat sitTimer = new TickFloat().setLimit(0.0f, 1.0f);
    private int shearCooldownTime;
    private int napTime;
    private int growCropsTime;
    private TemptGoal temptGoal;

    public DragonFruitDrakeEntity(EntityType<? extends DragonFruitDrakeEntity> dragon, World world) {
        super(dragon, world);
        this.registerDataEntry("ShearTimer", EntityDataEntry.INTEGER, () -> this.shearCooldownTime, v -> {
            this.shearCooldownTime = v;
        });
        this.registerDataEntry("Gender", EntityDataEntry.BOOLEAN, GENDER, this.func_70681_au().nextBoolean());
        this.registerDataEntry("Sleeping", EntityDataEntry.BOOLEAN, SLEEPING, false);
    }

    @Override
    protected SleepController createSleepController() {
        return new SleepController(this).addWakeConditions(() -> --this.napTime <= 0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveToCropsGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new MoveToHomeGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new DragonBreedGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.3, false));
        this.field_70714_bg.func_75776_a(8, (Goal)new WRFollowOwnerGoal(this));
        this.field_70714_bg.func_75776_a(9, (Goal)AnonymousGoals.followParent(this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 7.0f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.temptGoal = new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e})){

            public boolean func_75250_a() {
                return !DragonFruitDrakeEntity.this.func_70909_n() && DragonFruitDrakeEntity.this.func_70631_g_() && super.func_75250_a();
            }
        };
        this.field_70714_bg.func_75776_a(7, (Goal)this.temptGoal);
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{DragonFruitDrakeEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NonTamedTargetGoal((TameableEntity)this, PlayerEntity.class, true, EntityPredicates.field_188444_d::test));
    }

    @Override
    public ActionResultType playerInteraction(PlayerEntity player, Hand hand, ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151097_aZ && this.func_82171_bF()) {
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!this.func_70909_n() && this.func_70631_g_() && this.isFoodItem(stack)) {
            if (!this.field_70170_p.field_72995_K && this.temptGoal.func_75277_f()) {
                this.tame(this.func_70681_au().nextDouble() <= 0.2, player);
                this.eat(stack);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        if (this.func_70909_n() && stack.func_77973_b() == Items.field_151060_bw && this.growCropsTime <= 0) {
            this.eat(stack);
            this.growCropsTime = 1200;
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.playerInteraction(player, hand, stack);
    }

    @Override
    public void func_70636_d() {
        AxisAlignedBB aabb;
        super.func_70636_d();
        this.sitTimer.add(this.func_233684_eK_() || this.func_70608_bn() ? 0.1f : -0.1f);
        this.sleepTimer.add(this.func_70608_bn() ? 0.05f : -0.1f);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70031_b(this.func_70638_az() != null);
            if (this.shearCooldownTime > 0) {
                --this.shearCooldownTime;
            }
            if (this.growCropsTime >= 0) {
                --this.growCropsTime;
                if (this.func_70681_au().nextBoolean()) {
                    IGrowable plant;
                    int z;
                    int y;
                    aabb = this.func_174813_aQ().func_186662_g(5.0);
                    int x = MathHelper.func_76136_a((Random)this.func_70681_au(), (int)((int)aabb.field_72340_a), (int)((int)aabb.field_72336_d));
                    BlockPos pos = new BlockPos(x, y = MathHelper.func_76136_a((Random)this.func_70681_au(), (int)((int)aabb.field_72338_b), (int)((int)aabb.field_72337_e)), z = MathHelper.func_76136_a((Random)this.func_70681_au(), (int)((int)aabb.field_72339_c), (int)((int)aabb.field_72334_f)));
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (block instanceof IGrowable && !(block instanceof GrassBlock) && (plant = (IGrowable)block).func_176473_a((IBlockReader)this.field_70170_p, pos, state, false)) {
                        plant.func_225535_a_((ServerWorld)this.field_70170_p, this.func_70681_au(), pos, state);
                        this.field_70170_p.func_217379_c(2005, pos, 0);
                    }
                }
            }
            if (!this.func_70631_g_() && this.field_70170_p.func_72935_r() && !this.func_70608_bn() && this.func_70681_au().nextDouble() < 0.002) {
                this.napTime = 1200;
                this.setSleeping(true);
            }
        }
        if (this.getAnimation() == BITE_ANIMATION && this.getAnimationTick() == 7 && this.func_184186_bw()) {
            this.attackInBox(this.getOffsetBox(this.func_213311_cf()));
            aabb = this.func_174813_aQ().func_186662_g(2.0).func_191194_a(Mafs.getYawVec(this.field_70759_as, 0.0, 2.0));
            for (BlockPos pos : ModUtils.getBlockPosesInAABB(aabb)) {
                if (!(this.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BushBlock)) continue;
                this.field_70170_p.func_225521_a_(pos, true, (Entity)this);
            }
        }
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return stack.func_77973_b().func_206844_a((ITag)Tags.Items.CROPS) || ModUtils.isItemIn(stack, Items.field_151034_e, Items.field_222112_pR, Items.field_221794_dg, Items.field_151060_bw);
    }

    @Override
    public void recievePassengerKeybind(int key, int mods, boolean pressed) {
        if (key == 1 && pressed) {
            this.setAnimation(BITE_ANIMATION);
        }
    }

    public boolean func_213392_I() {
        return this.func_70909_n();
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return this.field_70173_aa > 2400;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_213302_cg();
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = this.func_200600_R().func_220334_j().func_220313_a(this.func_213355_cm());
        if (this.func_233684_eK_() || this.func_70608_bn()) {
            size = size.func_220312_a(1.0f, 0.7f);
        }
        return size;
    }

    public double func_70042_X() {
        return super.func_70042_X() + 0.1;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.shearCooldownTime <= 0;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        this.func_184185_a(SoundEvents.field_187784_dt, 1.0f, 1.0f);
        this.shearCooldownTime = 12000;
        return Collections.singletonList(new ItemStack((IItemProvider)Items.field_151034_e, 1 + fortune + this.func_70681_au().nextInt(2)));
    }

    @Override
    public void setMountCameraAngles(boolean backView, EntityViewRenderEvent.CameraSetup event) {
        if (backView) {
            event.getInfo().func_216782_a(-0.25, 0.5, 0.0);
        } else {
            event.getInfo().func_216782_a(-1.5, 0.15, 0.0);
        }
    }

    public void func_184609_a(Hand hand) {
        super.func_184609_a(hand);
        this.setAnimation(BITE_ANIMATION);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    @Override
    public int determineVariant() {
        return this.func_70681_au().nextDouble() < 0.008 ? -1 : 0;
    }

    @Override
    protected boolean func_184228_n(Entity passenger) {
        return !this.func_70631_g_() && passenger instanceof LivingEntity && this.func_152114_e((LivingEntity)passenger);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return (SoundEvent)WRSounds.ENTITY_DFD_IDLE.get();
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)WRSounds.ENTITY_DFD_HURT.get();
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return (SoundEvent)WRSounds.ENTITY_DFD_DEATH.get();
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151034_e;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, BITE_ANIMATION};
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData data, @Nullable CompoundNBT dataTag) {
        if (data == null) {
            data = new AgeableEntity.AgeableData(true);
            if (reason == SpawnReason.NATURAL) {
                this.func_70873_a(DragonEggProperties.get(this.func_200600_R()).getGrowthTime());
            }
        }
        return super.func_213386_a(world, difficulty, reason, data, dataTag);
    }

    public static <F extends MobEntity> boolean getSpawnPlacement(EntityType<F> fEntityType, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        BlockState state = world.func_180495_p(pos.func_177977_b());
        return (state.func_203425_a(Blocks.field_196658_i) || state.func_235714_a_((ITag)BlockTags.field_206952_E)) && world.func_226659_b_(pos, 0) > 8;
    }

    public static void setSpawnBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.JUNGLE) {
            event.getSpawns().func_242575_a(EntityClassification.AMBIENT, new MobSpawnInfo.Spawners((EntityType)WREntities.DRAGON_FRUIT_DRAKE.get(), 14, 4, 5));
        }
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 15.0).func_233815_a_(Attributes.field_233821_d_, 0.23).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public static boolean isCrop(Block block) {
        return block instanceof IGrowable && !(block instanceof GrassBlock);
    }

    private class MoveToCropsGoal
    extends MoveToBlockGoal {
        public MoveToCropsGoal() {
            super((CreatureEntity)DragonFruitDrakeEntity.this, 1.0, 10);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return DragonFruitDrakeEntity.this.growCropsTime >= 0 && this.func_179489_g();
        }

        protected int func_203109_a(CreatureEntity creature) {
            return 100;
        }

        public boolean func_75253_b() {
            return DragonFruitDrakeEntity.this.growCropsTime >= 0;
        }

        public void func_75246_d() {
            super.func_75246_d();
            DragonFruitDrakeEntity.this.func_70671_ap().func_220679_a((double)this.field_179494_b.func_177958_n(), (double)this.field_179494_b.func_177956_o(), (double)this.field_179494_b.func_177956_o());
            if (this.field_179493_e >= 200 && DragonFruitDrakeEntity.this.func_70681_au().nextInt(this.field_179493_e) >= 100) {
                this.field_179493_e = 0;
                this.func_179489_g();
            }
        }

        protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return !pos.equals((Object)this.field_179494_b) && DragonFruitDrakeEntity.isCrop(block) && ((IGrowable)block).func_176473_a((IBlockReader)world, pos, state, false);
        }
    }
}

