/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.entities.dragon;

import com.github.wolfshotz.wyrmroost.entities.dragon.AbstractDragonEntity;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.SleepController;
import com.github.wolfshotz.wyrmroost.entities.dragon.helpers.ai.goals.FlyerWanderGoal;
import com.github.wolfshotz.wyrmroost.entities.util.EntityDataEntry;
import com.github.wolfshotz.wyrmroost.registry.WREntities;
import com.github.wolfshotz.wyrmroost.util.TickFloat;
import com.github.wolfshotz.wyrmroost.util.animation.Animation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;

public class FogWraithEntity
extends AbstractDragonEntity {
    private static final DataParameter<Boolean> STEALTH = EntityDataManager.func_187226_a(FogWraithEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final Animation GRAB_AND_ATTACK_ANIMATION = new Animation(400);
    public static final Animation BITE_ANIMATION = new Animation(13);
    public static final Animation SCREECH_ANIMATION = new Animation(100);
    public final TickFloat flightTimer = new TickFloat().setLimit(0.0f, 1.0f);
    public final TickFloat stealthTimer = new TickFloat().setLimit(0.0f, 0.85f);

    public FogWraithEntity(EntityType<? extends AbstractDragonEntity> dragon, World world) {
        super(dragon, world);
        this.registerDataEntry("IsStealth", EntityDataEntry.BOOLEAN, STEALTH, false);
    }

    @Override
    protected SleepController createSleepController() {
        return null;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(9, (Goal)new FlyerWanderGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 10.0f));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.flightTimer.add(this.isFlying() ? 0.1f : -0.1f);
        this.stealthTimer.add(this.isStealth() ? 0.05f : -0.05f);
        Animation animation = this.getAnimation();
        int tick = this.getAnimationTick();
        if (animation == BITE_ANIMATION && tick == 5) {
            this.attackInBox(this.getOffsetBox(2.5f).func_186662_g(0.3));
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity) && entity instanceof LivingEntity) {
            int i = 5;
            switch (this.field_70170_p.func_175659_aa()) {
                case HARD: {
                    i = 12;
                    break;
                }
                case NORMAL: {
                    i = 8;
                    break;
                }
            }
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_82731_v, i * 20, 1));
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76440_q, 500));
            return true;
        }
        return false;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 1.3f;
    }

    @Override
    public boolean isFoodItem(ItemStack stack) {
        return false;
    }

    public boolean isStealth() {
        return (Boolean)this.field_70180_af.func_187225_a(STEALTH);
    }

    public void setStealth(boolean b) {
        this.field_70180_af.func_187227_b(STEALTH, (Object)b);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{GRAB_AND_ATTACK_ANIMATION, BITE_ANIMATION, SCREECH_ANIMATION};
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233821_d_, 0.31).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233824_g_, 2.25).func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233822_e_, 0.27).func_233815_a_((Attribute)WREntities.Attributes.PROJECTILE_DAMAGE.get(), 4.0);
    }
}

