/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfshotz.wyrmroost.items.base;

import com.github.wolfshotz.wyrmroost.registry.WRItems;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public enum ArmorMaterials implements IArmorMaterial
{
    BLUE_GEODE(new int[]{3, 5, 7, 3}, 1.0f, 31, 25, SoundEvents.field_187716_o, (Supplier<Item>)WRItems.BLUE_GEODE),
    RED_GEODE(new int[]{3, 6, 8, 3}, 2.5f, 32, 25, SoundEvents.field_187716_o, (Supplier<Item>)WRItems.RED_GEODE),
    PURPLE_GEODE(new int[]{4, 7, 10, 4}, 4.0f, 45, 28, 0, SoundEvents.field_187716_o, (Supplier<Item>)WRItems.RED_GEODE, Rarity.RARE),
    PLATINUM(new int[]{2, 5, 7, 2}, 0.1f, 20, 10, SoundEvents.field_187725_r, (Supplier<Item>)WRItems.PLATINUM_INGOT),
    DRAKE(new int[]{3, 6, 8, 3}, 1.2f, 32, 9, 0, SoundEvents.field_187728_s, (Supplier<Item>)WRItems.DRAKE_BACKPLATE, Rarity.UNCOMMON);

    private static final int[] DURABILITY_ARRAY;
    private final int durability;
    private final int enchantability;
    private final int knockbackResistance;
    private final int[] dmgReduction;
    private final float toughness;
    private final SoundEvent sound;
    private final Supplier<Item> repairMaterial;
    private final Rarity rarity;

    private ArmorMaterials(int[] dmgReduction, float toughness, int durability, int enchantability, SoundEvent sound, Supplier<Item> repairMaterial) {
        this(dmgReduction, toughness, durability, enchantability, 0, sound, repairMaterial, Rarity.COMMON);
    }

    private ArmorMaterials(int[] dmgReduction, float toughness, int durability, int enchantability, int knockbackResistance, SoundEvent sound, Supplier<Item> repairMaterial, Rarity rarity) {
        this.durability = durability;
        this.dmgReduction = dmgReduction;
        this.enchantability = enchantability;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.sound = sound;
        this.repairMaterial = repairMaterial;
        this.rarity = rarity;
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return DURABILITY_ARRAY[slotIn.func_188454_b()] * this.durability;
    }

    public int func_200902_b(EquipmentSlotType slot) {
        return this.dmgReduction[slot.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.sound;
    }

    public Ingredient func_200898_c() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)this.repairMaterial.get()});
    }

    public String func_200897_d() {
        return this.toString().toLowerCase();
    }

    public float func_200901_e() {
        return this.toughness;
    }

    public float func_230304_f_() {
        return this.knockbackResistance;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    static {
        DURABILITY_ARRAY = new int[]{13, 15, 16, 11};
    }
}

