/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xerca.xercamusic.client.ClientProxy;
import xerca.xercamusic.common.Proxy;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.Triggers;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.entity.Entities;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacket;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacketHandler;
import xerca.xercamusic.common.packets.MusicEndedPacket;
import xerca.xercamusic.common.packets.MusicEndedPacketHandler;
import xerca.xercamusic.common.packets.MusicUpdatePacket;
import xerca.xercamusic.common.packets.MusicUpdatePacketHandler;
import xerca.xercamusic.server.ServerProxy;

@Mod(value="xercamusic")
public class XercaMusic {
    public static final String MODID = "xercamusic";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Proxy proxy = (Proxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel NETWORK_HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("xercamusic", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    private void networkRegistry() {
        int msg_id = 0;
        NETWORK_HANDLER.registerMessage(msg_id++, MusicUpdatePacket.class, MusicUpdatePacket::encode, MusicUpdatePacket::decode, MusicUpdatePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, MusicEndedPacket.class, MusicEndedPacket::encode, MusicEndedPacket::decode, MusicEndedPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id, MusicBoxUpdatePacket.class, MusicBoxUpdatePacket::encode, MusicBoxUpdatePacket::decode, MusicBoxUpdatePacketHandler::handle);
    }

    public XercaMusic() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        this.networkRegistry();
        proxy.preInit();
        Items.setup();
        proxy.init();
        Blocks.setup();
        this.registerTriggers();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"xercamod", (String)"send_note", () -> new ResourceLocation(MODID, "music_sheet"));
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.debug("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    private void registerTriggers() {
        Method method = ObfuscationReflectionHelper.findMethod(CriteriaTriggers.class, (String)"func_192118_a", (Class[])new Class[]{ICriterionTrigger.class});
        method.setAccessible(true);
        for (int i = 0; i < Triggers.TRIGGER_ARRAY.length; ++i) {
            try {
                method.invoke(null, Triggers.TRIGGER_ARRAY[i]);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> T Null() {
        return null;
    }

    @SubscribeEvent
    public void remapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping miss : event.getAllMappings()) {
            LOGGER.info("Missing block entry found: " + miss.key);
            if (miss.key.toString().equals("xercamod:block_metronome")) {
                miss.remap((IForgeRegistryEntry)Blocks.BLOCK_METRONOME);
                continue;
            }
            if (!miss.key.toString().equals("xercamod:music_box")) continue;
            miss.remap((IForgeRegistryEntry)Blocks.MUSIC_BOX);
        }
    }

    @SubscribeEvent
    public void remapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping miss : event.getAllMappings()) {
            LOGGER.info("Missing item entry found: " + miss.key);
            if (miss.key.toString().equals("xercamod:item_metronome")) {
                miss.remap((IForgeRegistryEntry)Blocks.BLOCK_METRONOME.func_199767_j());
            } else if (miss.key.toString().equals("xercamod:music_box")) {
                miss.remap((IForgeRegistryEntry)Blocks.MUSIC_BOX.func_199767_j());
            } else if (miss.key.toString().equals("xercamod:item_note")) {
                miss.remap((IForgeRegistryEntry)Items.MUSIC_SHEET);
            } else if (miss.key.toString().equals("xercamod:item_guitar")) {
                miss.remap((IForgeRegistryEntry)Items.GUITAR);
            } else if (miss.key.toString().equals("xercamod:item_banjo")) {
                miss.remap((IForgeRegistryEntry)Items.BANJO);
            } else if (miss.key.toString().equals("xercamod:item_drum")) {
                miss.remap((IForgeRegistryEntry)Items.DRUM);
            } else if (miss.key.toString().equals("xercamod:item_flute")) {
                miss.remap((IForgeRegistryEntry)Items.FLUTE);
            } else if (miss.key.toString().equals("xercamod:item_god")) {
                miss.remap((IForgeRegistryEntry)Items.GOD);
            } else if (miss.key.toString().equals("xercamod:item_lyre")) {
                miss.remap((IForgeRegistryEntry)Items.LYRE);
            } else if (miss.key.toString().equals("xercamod:item_sansula")) {
                miss.remap((IForgeRegistryEntry)Items.SANSULA);
            } else if (miss.key.toString().equals("xercamod:item_saxophone")) {
                miss.remap((IForgeRegistryEntry)Items.SAXOPHONE);
            } else if (miss.key.toString().equals("xercamod:item_tubular_bell")) {
                miss.remap((IForgeRegistryEntry)Items.TUBULAR_BELL);
            } else if (miss.key.toString().equals("xercamod:item_violin")) {
                miss.remap((IForgeRegistryEntry)Items.VIOLIN);
            } else if (miss.key.toString().equals("xercamod:item_xylophone")) {
                miss.remap((IForgeRegistryEntry)Items.XYLOPHONE);
            }
            if (miss.key.toString().equals("xercamusic:item_metronome")) {
                miss.remap((IForgeRegistryEntry)Blocks.BLOCK_METRONOME.func_199767_j());
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_note")) {
                miss.remap((IForgeRegistryEntry)Items.MUSIC_SHEET);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_guitar")) {
                miss.remap((IForgeRegistryEntry)Items.GUITAR);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_banjo")) {
                miss.remap((IForgeRegistryEntry)Items.BANJO);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_drum")) {
                miss.remap((IForgeRegistryEntry)Items.DRUM);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_flute")) {
                miss.remap((IForgeRegistryEntry)Items.FLUTE);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_god")) {
                miss.remap((IForgeRegistryEntry)Items.GOD);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_lyre")) {
                miss.remap((IForgeRegistryEntry)Items.LYRE);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_sansula")) {
                miss.remap((IForgeRegistryEntry)Items.SANSULA);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_saxophone")) {
                miss.remap((IForgeRegistryEntry)Items.SAXOPHONE);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_tubular_bell")) {
                miss.remap((IForgeRegistryEntry)Items.TUBULAR_BELL);
                continue;
            }
            if (miss.key.toString().equals("xercamusic:item_violin")) {
                miss.remap((IForgeRegistryEntry)Items.VIOLIN);
                continue;
            }
            if (!miss.key.toString().equals("xercamusic:item_xylophone")) continue;
            miss.remap((IForgeRegistryEntry)Items.XYLOPHONE);
        }
    }

    @SubscribeEvent
    public void remapEntities(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping miss : event.getAllMappings()) {
            LOGGER.info("Missing entity entry found: " + miss.key);
            if (!miss.key.toString().equals("xercamod:music_spirit")) continue;
            miss.remap(Entities.MUSIC_SPIRIT);
        }
    }

    @SubscribeEvent
    public void remapSoundEvents(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping miss : event.getAllMappings()) {
            if (!miss.key.func_110624_b().equals("xercamod")) continue;
            if (miss.key.func_110623_a().equals("metronome_set")) {
                miss.remap((IForgeRegistryEntry)SoundEvents.METRONOME_SET);
                continue;
            }
            if (miss.key.func_110623_a().equals("tick")) {
                miss.remap((IForgeRegistryEntry)SoundEvents.TICK);
                continue;
            }
            try {
                String[] part = miss.key.func_110623_a().split("(?<=\\D)(?=\\d)");
                switch (part[0]) {
                    case "banjo": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.banjos[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "guitar": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.guitars[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "drum": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.drums[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "lyre": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.lyres[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "flute": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.flutes[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "saxophone": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.saxophones[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "god": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.gods[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "harp_mc": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.harp_mcs[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "sansula": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.sansulas[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "tubular_bell": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.tubular_bells[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "violin": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.violins[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "xylophone": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.xylophones[Integer.parseInt(part[1]) - 1]);
                        break;
                    }
                    case "cello": {
                        miss.remap((IForgeRegistryEntry)SoundEvents.cellos[Integer.parseInt(part[1]) - 1]);
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
    }
}

