/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.entity.EntityMusicSpirit;
import xerca.xercamusic.common.item.Items;

public class ItemInstrument
extends Item {
    private SoundEvent[] sounds;
    public boolean shouldCutOff;

    ItemInstrument(String name, boolean shouldCutOff) {
        super(new Item.Properties().func_200916_a((ItemGroup)Items.musicTab));
        this.setRegistryName(name);
        this.shouldCutOff = shouldCutOff;
    }

    public SoundEvent getSound(int i) {
        return this.sounds[i];
    }

    public void playMusic(World worldIn, PlayerEntity playerIn, boolean canStop) {
        List musicSpirits = worldIn.func_175647_a(EntityMusicSpirit.class, playerIn.func_174813_aQ().func_186662_g(3.0), entity -> entity.getBody().func_70028_i((Entity)playerIn));
        if (musicSpirits.size() == 0) {
            worldIn.func_217376_c((Entity)new EntityMusicSpirit(worldIn, playerIn));
        } else {
            musicSpirits.forEach(spirit -> spirit.setPlaying(false));
        }
    }

    public void setSounds(SoundEvent[] sounds) {
        this.sounds = sounds;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack heldItem = playerIn.func_184586_b(handIn);
        ItemStack off = playerIn.func_184592_cb();
        if (handIn == Hand.MAIN_HAND && off.func_77973_b() == Items.MUSIC_SHEET) {
            if (!worldIn.field_72995_K) {
                this.playMusic(worldIn, playerIn, true);
            }
        } else {
            int note = (int)(worldIn.field_73012_v.nextGaussian() * 8.0 + 24.0);
            note = Math.max(0, Math.min(47, note));
            worldIn.func_184133_a(playerIn, playerIn.func_180425_c(), this.sounds[note], SoundCategory.PLAYERS, 3.0f, 1.0f);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState iblockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (iblockstate.func_177230_c() == Blocks.MUSIC_BOX && !((Boolean)iblockstate.func_177229_b((IProperty)BlockMusicBox.HAS_INSTRUMENT)).booleanValue()) {
            ItemStack itemstack = context.func_195996_i();
            if (!world.field_72995_K) {
                ((BlockMusicBox)Blocks.MUSIC_BOX).insertInstrument((IWorld)world, blockpos, iblockstate, itemstack.func_77973_b());
                world.func_217378_a(null, 1012, blockpos, 0);
                if (context.func_195999_j() != null && !context.func_195999_j().field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        World world = attacker.field_70170_p;
        if (!world.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                world.func_184133_a(null, target.func_180425_c(), this.sounds[world.field_73012_v.nextInt(48)], SoundCategory.PLAYERS, 3.0f, 1.0f);
            }
        }
        return true;
    }
}

