/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.packets.SingleNotePacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiInstrument
extends Screen {
    private static final ResourceLocation insGuiTextures = new ResourceLocation("xercamusic", "textures/gui/instrument_gui.png");
    private int guiBaseX = 45;
    private int guiBaseY = 80;
    private int pushedButton = -1;
    private int currentKeyboardOctave = 2;
    private static final int guiHeight = 105;
    private static final int guiWidth = 401;
    private static final int guiMarginWidth = 7;
    private static final int guiNoteWidth = 8;
    private static final int guiOctaveWidth = 97;
    private static final int guiOctaveHighlightY = 111;
    private static final int guiOctaveHighlightWidth = 98;
    private static final int guiOctaveHighlightHeight = 92;
    private final PlayerEntity player;
    private final ItemInstrument instrument;
    private NoteSound lastPlayed = null;

    GuiInstrument(PlayerEntity player, ItemInstrument instrument, ITextComponent title) {
        super(title);
        this.player = player;
        this.instrument = instrument;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        this.guiBaseX = (this.width - 401) / 2;
        this.guiBaseY = (this.height - 105) / 2;
    }

    public void tick() {
        super.tick();
    }

    public void render(int mouseX, int mouseY, float f) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(insGuiTextures);
        GuiInstrument.blit((int)this.guiBaseX, (int)this.guiBaseY, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)401, (int)105, (int)512, (int)512);
        if (this.pushedButton >= 0 && this.pushedButton < 48) {
            int pushedOctave = this.pushedButton / 12;
            int x = this.guiBaseX + 7 + this.pushedButton * 8 + pushedOctave;
            int y = this.guiBaseY + 11;
            GuiInstrument.blit((int)x, (int)y, (int)this.getBlitOffset(), (float)402.0f, (float)11.0f, (int)7, (int)82, (int)512, (int)512);
        }
        int octaveHighlightX = this.guiBaseX + 7 + this.currentKeyboardOctave * 97 - 1;
        int octaveHighlightY = this.guiBaseY + 3;
        GuiInstrument.blit((int)octaveHighlightX, (int)octaveHighlightY, (int)this.getBlitOffset(), (float)0.0f, (float)111.0f, (int)98, (int)92, (int)512, (int)512);
    }

    public boolean mouseClicked(double dmouseX, double dmouseY, int mouseButton) {
        int mouseX = (int)Math.round(dmouseX);
        int mouseY = (int)Math.round(dmouseY);
        int buttonBaseX = this.guiBaseX + 7;
        if (mouseX >= buttonBaseX && mouseX <= buttonBaseX + 401 && mouseY >= this.guiBaseY + 9 && mouseY <= this.guiBaseY + 105 - 10) {
            int playNote;
            int octave = (mouseX - buttonBaseX) / 97;
            int note = (mouseX - buttonBaseX) % 97 / 8;
            if (note < 12 && (playNote = octave * 12 + note) >= 0 && playNote < 48) {
                this.playSound(playNote);
                this.pushedButton = playNote;
            }
        }
        return super.mouseClicked((double)mouseX, (double)mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.pushedButton = -1;
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    private void playSound(int note) {
        if (this.instrument.shouldCutOff && this.lastPlayed != null) {
            this.lastPlayed.stopSound();
        }
        SoundEvent noteSound = this.instrument.getSound(note);
        this.lastPlayed = XercaMusic.proxy.playNote(noteSound, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_());
        this.player.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197597_H, this.player.func_226277_ct_() + 0.5, this.player.func_226278_cu_() + 2.2, this.player.func_226281_cx_() + 0.5, (double)note / 24.0, 0.0, 0.0);
        SingleNotePacket pack = new SingleNotePacket(note, this.instrument);
        XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack);
    }

    public boolean mouseDragged(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        return super.mouseDragged(posX, posY, mouseButton, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        int playNote;
        this.setFocused(null);
        super.keyPressed(keyCode, scanCode, modifiers);
        if (scanCode >= 16 && scanCode <= 27 && (playNote = scanCode - 16 + 12 * this.currentKeyboardOctave) >= 0 && playNote < 48 && this.pushedButton != playNote) {
            this.playSound(playNote);
            this.pushedButton = playNote;
        }
        if (scanCode >= 30 && scanCode <= 33) {
            this.currentKeyboardOctave = scanCode - 30;
        }
        return true;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.pushedButton = -1;
        return true;
    }

    public void removed() {
    }
}

