/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.tile_entity.TileEntityMetronome;

public class BlockMetronome
extends Block {
    public static final IntegerProperty BPM = IntegerProperty.func_177719_a((String)"bpm", (int)0, (int)10);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockMetronome() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185848_a));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BPM, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
        this.setRegistryName("block_metronome");
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag = worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((IProperty)POWERED)) {
            if (flag) {
                // empty if block
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void setBpm(BlockState state, World worldIn, BlockPos pos, int bpm) {
        if (!worldIn.field_72995_K && bpm >= 0 && bpm <= 10) {
            state = (BlockState)state.func_206870_a((IProperty)BPM, (Comparable)Integer.valueOf(bpm));
            worldIn.func_180501_a(pos, state, 3);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.METRONOME_SET, SoundCategory.BLOCKS, 1.0f, 1.0f);
        ItemStack note = ItemStack.field_190927_a;
        if (player.func_184586_b(hand).func_77973_b() == Items.MUSIC_SHEET) {
            note = player.func_184586_b(hand);
        } else if (player.func_184592_cb().func_77973_b() == Items.MUSIC_SHEET) {
            note = player.func_184592_cb();
        }
        if (!note.func_190926_b() && note.func_77942_o()) {
            int pause = note.func_77978_p().func_74762_e("pause");
            this.setBpm(state, worldIn, pos, ItemMusicSheet.pauseToBPMLevel[pause]);
            return ActionResultType.SUCCESS;
        }
        state = (BlockState)state.func_177231_a((IProperty)BPM);
        worldIn.func_180501_a(pos, state, 3);
        return ActionResultType.SUCCESS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BPM, POWERED, FACING});
    }

    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileEntityMetronome();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }
}

