/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.block.Blocks;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.tile_entity.TileEntityMetronome;

public class ItemMusicSheet
extends Item {
    public static int[] pauseToBPMLevel = new int[21];

    ItemMusicSheet() {
        super(new Item.Properties().func_200916_a((ItemGroup)Items.musicTab).func_200917_a(1));
        this.setRegistryName("music_sheet");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            XercaMusic.proxy.showMusicGui();
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        String s;
        CompoundNBT nbttagcompound;
        if (stack.func_77942_o() && (nbttagcompound = stack.func_77978_p()) != null && !StringUtils.func_151246_b((String)(s = nbttagcompound.func_74779_i("title")))) {
            return new StringTextComponent(s);
        }
        return super.func_200295_i(stack);
    }

    public static byte[] getMusic(@Nonnull ItemStack stack) {
        CompoundNBT nbttagcompound;
        if (stack.func_77942_o() && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_74764_b("music")) {
            return nbttagcompound.func_74770_j("music");
        }
        return null;
    }

    public static int getPause(@Nonnull ItemStack stack) {
        CompoundNBT nbttagcompound;
        if (stack.func_77942_o() && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_74764_b("pause")) {
            return nbttagcompound.func_74771_c("pause");
        }
        return -1;
    }

    public static int getPrevInstrument(@Nonnull ItemStack stack) {
        CompoundNBT nbttagcompound;
        if (stack.func_77942_o() && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_74764_b("prevIns")) {
            return nbttagcompound.func_74771_c("prevIns");
        }
        return -1;
    }

    public static int getGeneration(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("generation");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            int generation;
            CompoundNBT tag = stack.func_77978_p();
            String s = tag.func_74779_i("author");
            if (!StringUtils.func_151246_b((String)s)) {
                tooltip.add((ITextComponent)new TranslationTextComponent("note.byAuthor", new Object[]{s}));
            }
            if ((generation = tag.func_74762_e("generation")) > 0) {
                tooltip.add(new TranslationTextComponent("note.generation." + (generation - 1), new Object[0]).func_211708_a(TextFormatting.GRAY));
            }
        }
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState iblockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (iblockstate.func_177230_c() == Blocks.MUSIC_BOX && !((Boolean)iblockstate.func_177229_b((IProperty)BlockMusicBox.HAS_MUSIC)).booleanValue()) {
            ItemStack itemstack = context.func_195996_i();
            if (itemstack.func_77942_o() && !world.field_72995_K) {
                ((BlockMusicBox)Blocks.MUSIC_BOX).insertMusic((IWorld)world, blockpos, iblockstate, itemstack.func_77946_l());
                if (context.func_195999_j() != null && !context.func_195999_j().field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        CompoundNBT ntc;
        if (stack.func_77942_o() && (ntc = stack.func_77978_p()).func_74764_b("generation")) {
            int generation = ntc.func_74762_e("generation");
            return generation > 0;
        }
        return false;
    }

    static {
        for (int i = 0; i < TileEntityMetronome.pauseLevels.length; ++i) {
            ItemMusicSheet.pauseToBPMLevel[TileEntityMetronome.pauseLevels[i]] = i;
        }
    }
}

