/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.glfw.GLFW;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.SoundEvents;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.item.Items;
import xerca.xercamusic.common.packets.MusicUpdatePacket;

@OnlyIn(value=Dist.CLIENT)
public class GuiMusicSheet
extends Screen {
    private static final ResourceLocation noteGuiTextures = new ResourceLocation("xercamusic", "textures/gui/music_sheet.png");
    private static final ResourceLocation instrumentTextures = new ResourceLocation("xercamusic", "textures/gui/instruments.png");
    private final PlayerEntity editingPlayer;
    public static final int beatsInTab = 48;
    public static final int tabAmount = 5;
    private static final int totalBeats = 240;
    private static final int noteImageWidth = 180;
    private static final int noteImageHeight = 241;
    private static final int tabHeight = 39;
    private static final int startingX = 20;
    private static final int startingY = 36;
    private static final int endingX = 163;
    private static final int endingY = 230;
    private static final int paletteX = 20;
    private static final int paletteY = 31;
    private static final int paletteWidth = 5;
    private static final int bpmButW = 10;
    private static final int bpmButH = 10;
    private static final int bpmButX = 155;
    private static final int bpmButY = 16;
    private static final int[] octaveColors = new int[]{-65536, -15925504, -16754177, -8716033};
    private static final int[] octaveColorsTrans = new int[]{922681344, 906821376, 905992703, 914030847};
    private int noteImageX;
    private int noteImageY;
    private int currentOctave;
    private boolean isSigned;
    private boolean gettingSigned;
    private boolean previewing;
    private boolean previewStarted;
    private int previewCursor;
    private int editCursor;
    private int editCursorEnd;
    private int selectionStart;
    private int updateCount;
    private String noteTitle;
    private Button bpmUp;
    private Button bpmDown;
    private Button buttonSign;
    private Button buttonCancel;
    private Button buttonFinalize;
    private ChangeableImageButton buttonPreview;
    private ChangeableImageButton buttonHideNeighbors;
    private LockImageButton buttonLockPrevIns;
    private NoteSound lastPlayed;
    private boolean neighborsHidden;
    private boolean prevInsLocked;
    private boolean selfSigned;
    private byte[] music;
    private int length;
    private int bpm;
    private byte pause;
    private boolean dirty;
    private int previewInstrument;
    private String authorName;
    private ArrayList<byte[]> neighborMusics;
    private ArrayList<Integer> neighborPrevInstruments;
    private ArrayList<NoteSound> neighborLastPlayeds;

    private int getCurrentOffhandInsIndex() {
        Item offhand = this.editingPlayer.func_184592_cb().func_77973_b();
        if (offhand instanceof ItemInstrument) {
            ItemInstrument ins = (ItemInstrument)offhand;
            return ArrayUtils.indexOf((Object[])Items.instruments, (Object)((Object)ins));
        }
        return -1;
    }

    GuiMusicSheet(PlayerEntity player, CompoundNBT noteTag, ITextComponent title) {
        super(title);
        int currentSlot;
        boolean added;
        int index;
        this.noteImageX = (this.field_230708_k_ - 180) / 2;
        this.noteImageY = 2;
        this.currentOctave = 1;
        this.noteTitle = "";
        this.lastPlayed = null;
        this.neighborsHidden = false;
        this.prevInsLocked = false;
        this.selfSigned = false;
        this.dirty = false;
        this.previewInstrument = -1;
        this.authorName = null;
        this.neighborMusics = new ArrayList();
        this.neighborPrevInstruments = new ArrayList();
        this.neighborLastPlayeds = new ArrayList();
        this.editingPlayer = player;
        if (noteTag != null && !noteTag.isEmpty()) {
            byte[] nbtMusic = noteTag.func_74770_j("music");
            this.length = noteTag.func_74762_e("length");
            this.pause = noteTag.func_74771_c("pause");
            this.isSigned = noteTag.func_74762_e("generation") > 0;
            this.noteTitle = noteTag.func_74779_i("title");
            this.authorName = noteTag.func_74779_i("author");
            this.prevInsLocked = noteTag.func_74767_n("piLocked");
            if (noteTag.func_74764_b("prevIns")) {
                this.previewInstrument = noteTag.func_74771_c("prevIns");
            }
            if (this.authorName.equals(player.func_200200_C_().getString())) {
                this.selfSigned = true;
            }
            this.music = Arrays.copyOfRange(nbtMusic, 0, 240);
        } else {
            this.isSigned = false;
        }
        if (this.music == null) {
            this.music = new byte[240];
            this.length = 0;
            this.pause = (byte)5;
        }
        this.bpm = 1200 / this.pause;
        this.updateCount = 0;
        if (!this.prevInsLocked && (index = this.getCurrentOffhandInsIndex()) != this.previewInstrument) {
            this.previewInstrument = index;
            this.dirty = true;
        }
        if (added = this.addNeighborSheet(this.getStackInSlot((currentSlot = player.field_71071_by.field_70461_c) - 1))) {
            this.addNeighborSheet(this.getStackInSlot(currentSlot - 2));
        }
        if (added = this.addNeighborSheet(this.getStackInSlot(currentSlot + 1))) {
            this.addNeighborSheet(this.getStackInSlot(currentSlot + 2));
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private boolean addNeighborSheet(ItemStack neighbor) {
        int neighbor_pause;
        if (!neighbor.func_190926_b() && neighbor.func_77973_b() instanceof ItemMusicSheet && (neighbor_pause = ItemMusicSheet.getPause(neighbor)) == this.pause) {
            this.neighborMusics.add(ItemMusicSheet.getMusic(neighbor));
            this.neighborPrevInstruments.add(ItemMusicSheet.getPrevInstrument(neighbor));
            this.neighborLastPlayeds.add(null);
            return true;
        }
        return false;
    }

    private ItemStack getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.editingPlayer.field_71071_by.func_70302_i_()) {
            return this.editingPlayer.field_71071_by.func_70301_a(slot);
        }
        return ItemStack.field_190927_a;
    }

    public void func_231160_c_() {
        this.noteImageX = (this.field_230708_k_ - 180) / 2;
        this.noteImageY = 2;
        if (!this.isSigned) {
            this.bpmUp = (Button)this.func_230480_a_((Widget)new Button(this.noteImageX + 155, this.noteImageY + 16, 10, 10, (ITextComponent)new TranslationTextComponent("note.upButton"), button -> {
                if (!this.isSigned) {
                    this.dirty = true;
                    if (this.pause == 20) {
                        this.pause = (byte)(this.pause - 5);
                    } else if (this.pause == 15) {
                        this.pause = (byte)(this.pause - 3);
                    } else if (this.pause >= 8) {
                        this.pause = (byte)(this.pause - 2);
                    } else if (this.pause >= 2) {
                        this.pause = (byte)(this.pause - 1);
                    }
                    this.bpm = 1200 / this.pause;
                }
            }));
            this.bpmDown = (Button)this.func_230480_a_((Widget)new Button(this.noteImageX + 155, this.noteImageY + 16 + 1 + 10, 10, 10, (ITextComponent)new TranslationTextComponent("note.downButton"), button -> {
                if (!this.isSigned) {
                    this.dirty = true;
                    if (this.pause <= 5) {
                        this.pause = (byte)(this.pause + 1);
                    } else if (this.pause <= 10) {
                        this.pause = (byte)(this.pause + 2);
                    } else if (this.pause == 12) {
                        this.pause = (byte)(this.pause + 3);
                    } else if (this.pause == 15) {
                        this.pause = (byte)(this.pause + 5);
                    }
                    this.bpm = 1200 / this.pause;
                }
            }));
            this.buttonSign = (Button)this.func_230480_a_((Widget)new Button(this.noteImageX - 100, 100, 98, 20, (ITextComponent)new TranslationTextComponent("note.signButton"), button -> {
                if (!this.isSigned) {
                    this.gettingSigned = true;
                    this.updateButtons();
                }
            }));
            this.buttonFinalize = (Button)this.func_230480_a_((Widget)new Button(this.noteImageX - 100, 100, 98, 20, (ITextComponent)new TranslationTextComponent("note.finalizeButton"), button -> {
                if (!this.isSigned) {
                    this.dirty = true;
                    this.isSigned = true;
                    this.field_230706_i_.func_147108_a(null);
                }
            }));
            this.buttonCancel = (Button)this.func_230480_a_((Widget)new Button(this.noteImageX - 100, 130, 98, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> {
                if (!this.isSigned) {
                    this.gettingSigned = false;
                    this.updateButtons();
                }
            }));
        }
        this.buttonPreview = (ChangeableImageButton)this.func_230480_a_((Widget)new ChangeableImageButton(this.noteImageX + 67, 23, 16, 16, 224, 0, 16, noteGuiTextures, button -> {
            if (!this.previewing) {
                this.startPreview();
            } else {
                this.stopPreview();
            }
        }));
        this.buttonHideNeighbors = (ChangeableImageButton)this.func_230480_a_((Widget)new ChangeableImageButton(this.noteImageX + 87, 23, 16, 16, 224, 32, 16, noteGuiTextures, button -> {
            boolean bl = this.neighborsHidden = !this.neighborsHidden;
            if (this.neighborsHidden) {
                this.buttonHideNeighbors.setTexStarts(240, 32);
            } else {
                this.buttonHideNeighbors.setTexStarts(224, 32);
            }
        }));
        this.buttonLockPrevIns = (LockImageButton)this.func_230480_a_((Widget)new LockImageButton(this.noteImageX + 107, 23, 16, 16, this.previewInstrument * 16 + 16, 0, 16, instrumentTextures, button -> {
            int index;
            this.prevInsLocked = !this.prevInsLocked;
            this.dirty = true;
            if (!this.prevInsLocked && (index = this.getCurrentOffhandInsIndex()) != this.previewInstrument) {
                this.previewInstrument = index;
                this.buttonLockPrevIns.setTexStarts(this.previewInstrument * 16 + 16, 0);
            }
        }));
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.isSigned) {
            this.bpmUp.field_230694_p_ = !this.gettingSigned;
            this.bpmDown.field_230694_p_ = this.bpmUp.field_230694_p_;
            this.buttonSign.field_230694_p_ = !this.gettingSigned;
            this.buttonCancel.field_230694_p_ = this.gettingSigned;
            this.buttonFinalize.field_230694_p_ = this.gettingSigned;
            this.buttonFinalize.field_230693_o_ = !this.noteTitle.trim().isEmpty();
        }
        this.buttonPreview.field_230694_p_ = !this.gettingSigned;
        this.buttonLockPrevIns.field_230694_p_ = true;
        this.buttonLockPrevIns.field_230693_o_ = !this.isSigned;
        this.buttonHideNeighbors.field_230694_p_ = this.neighborMusics.size() > 0;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.updateCount;
        if (this.previewing && this.updateCount % this.pause == 0) {
            this.previewStarted = true;
            if (this.previewCursor >= this.length || this.editCursorEnd != this.editCursor && this.previewCursor > this.editCursorEnd) {
                this.stopPreview();
                return;
            }
            this.playPrevSound();
            ++this.previewCursor;
        }
    }

    private void playSound(int note, int previewInstrument) {
        this.playSound(note, previewInstrument, -1);
    }

    private void playSound(int note, int previewInstrument, int neighborId) {
        SoundEvent noteSound;
        if (previewInstrument > 0 && previewInstrument < Items.instruments.length) {
            ItemInstrument ins = Items.instruments[previewInstrument];
            noteSound = ins.getSound(note);
            if (ins.shouldCutOff) {
                if (neighborId >= 0 && neighborId < this.neighborLastPlayeds.size() && this.neighborLastPlayeds.get(neighborId) != null) {
                    this.neighborLastPlayeds.get(neighborId).stopSound();
                } else if (this.lastPlayed != null) {
                    this.lastPlayed.stopSound();
                }
            }
        } else {
            noteSound = SoundEvents.harp_mcs[note];
        }
        NoteSound sound = XercaMusic.proxy.playNote(noteSound, this.editingPlayer.func_226277_ct_(), this.editingPlayer.func_226278_cu_(), this.editingPlayer.func_226281_cx_());
        if (neighborId >= 0 && neighborId < this.neighborLastPlayeds.size()) {
            this.neighborLastPlayeds.set(neighborId, sound);
        } else {
            this.lastPlayed = sound;
        }
    }

    private void playPrevSound() {
        if (this.music[this.previewCursor] != 0 && this.music[this.previewCursor] <= 48) {
            this.playSound(this.music[this.previewCursor] - 1, this.previewInstrument);
        }
        if (!this.neighborsHidden) {
            for (int i = 0; i < this.neighborMusics.size(); ++i) {
                byte[] m = this.neighborMusics.get(i);
                int ins = this.neighborPrevInstruments.get(i);
                if (this.previewCursor >= m.length || m[this.previewCursor] == 0 || m[this.previewCursor] > 48) continue;
                this.playSound(m[this.previewCursor] - 1, ins, i);
            }
        }
    }

    private void drawSigning(MatrixStack matrixStack) {
        int i = this.noteImageX;
        int j = this.noteImageY;
        GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(i + 30), (int)(j + 30), (int)(i + 150), (int)(j + 150), (int)-1);
        String s = this.noteTitle;
        if (!this.isSigned) {
            s = this.updateCount / 6 % 2 == 0 ? s + "" + TextFormatting.BLACK + "_" : s + "" + TextFormatting.GRAY + "_";
        }
        String s1 = I18n.func_135052_a((String)"note.editTitle", (Object[])new Object[0]);
        int k = this.field_230712_o_.func_78256_a(s1);
        this.field_230712_o_.func_238421_b_(matrixStack, s1, (float)(i + 36) + (float)(116 - k) / 2.0f, (float)(j + 16 + 16), 0);
        int l = this.field_230712_o_.func_78256_a(s);
        this.field_230712_o_.func_238421_b_(matrixStack, s, (float)(i + 36) + (float)(116 - l) / 2.0f, (float)(j + 48), 0);
        String s2 = I18n.func_135052_a((String)"note.byAuthor", (Object[])new Object[]{this.editingPlayer.func_200200_C_().getString()});
        int i1 = this.field_230712_o_.func_78256_a(s2);
        this.field_230712_o_.func_238421_b_(matrixStack, TextFormatting.DARK_GRAY + s2, (float)(i + 36 + (116 - i1) / 2), (float)(j + 48 + 10), 0);
        this.field_230712_o_.func_238418_a_((ITextProperties)new TranslationTextComponent("note.finalizeWarning"), i + 36, j + 80, 116, 0);
    }

    private void drawCursor(MatrixStack matrixStack, int cursorX, int color) {
        Note note = new Note(cursorX, 11);
        int x = note.getPixelX(this.noteImageX);
        int y = note.getPixelY(this.noteImageY);
        GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x + 1), (int)y, (int)(x + 2), (int)(y + 36), (int)color);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(noteGuiTextures);
        this.func_238474_b_(matrixStack, this.noteImageX, this.noteImageY, 0, 0, 180, 241);
        if (this.gettingSigned) {
            this.drawSigning(matrixStack);
        } else {
            int y;
            int x_begin;
            int x_end;
            int y2;
            int x2;
            int y1;
            int x1;
            Note endNote;
            Note beginNote;
            int selectionColor;
            this.field_230712_o_.func_238421_b_(matrixStack, "Tempo", (float)(this.noteImageX + 155 - 30), (float)(this.noteImageY + 16), -16777216);
            this.field_230712_o_.func_238421_b_(matrixStack, "" + this.bpm, (float)(this.noteImageX + 155 - 30), (float)(this.noteImageY + 16 + 10), -16777216);
            if (!this.isSigned) {
                this.field_230712_o_.func_238421_b_(matrixStack, "Octave", (float)(this.noteImageX + 20), (float)(this.noteImageY + 31 - 8), -16777216);
                int j = this.currentOctave;
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (i2 == j) continue;
                    GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(this.noteImageX + 20 + i2 * 5), (int)(this.noteImageY + 31), (int)(this.noteImageX + 20 + i2 * 5 + 5), (int)(this.noteImageY + 31 + 5), (int)octaveColors[i2]);
                }
                GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(this.noteImageX + 20 + j * 5 - 1), (int)(this.noteImageY + 31 - 1), (int)(this.noteImageX + 20 + j * 5 + 5 + 1), (int)(this.noteImageY + 31 + 5 + 1), (int)-256);
                GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(this.noteImageX + 20 + j * 5), (int)(this.noteImageY + 31), (int)(this.noteImageX + 20 + j * 5 + 5), (int)(this.noteImageY + 31 + 5), (int)octaveColors[j]);
                this.drawCursor(matrixStack, this.editCursor, -5627358);
                if (this.editCursor != this.editCursorEnd) {
                    this.drawCursor(matrixStack, this.editCursorEnd, -5627358);
                    selectionColor = -2011028822;
                    beginNote = new Note(this.editCursor, 11);
                    endNote = new Note(this.editCursorEnd, 11);
                    x1 = beginNote.getPixelX(this.noteImageX);
                    y1 = beginNote.getPixelY(this.noteImageY);
                    x2 = endNote.getPixelX(this.noteImageX);
                    y2 = endNote.getPixelY(this.noteImageY);
                    if (y1 == y2) {
                        GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)y1, (int)(x2 + 2), (int)(y1 + 36), (int)selectionColor);
                    } else {
                        x_end = new Note(47, 11).getPixelX(this.noteImageX);
                        x_begin = new Note(0, 11).getPixelX(this.noteImageX);
                        GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)y1, (int)(x_end + 2), (int)(y1 + 36), (int)selectionColor);
                        GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x_begin + 1), (int)y2, (int)(x2 + 2), (int)(y2 + 36), (int)selectionColor);
                        for (y = y1 + 39; y <= y2 - 39; y += 39) {
                            GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x_begin + 1), (int)y, (int)(x_end + 2), (int)(y + 36), (int)selectionColor);
                        }
                    }
                }
            } else {
                int k = this.field_230712_o_.func_78256_a(this.noteTitle);
                this.field_230712_o_.func_238421_b_(matrixStack, this.noteTitle, (float)this.noteImageX + (float)(180 - k) / 2.0f, (float)(this.noteImageY + 12), -16777216);
                if (this.selfSigned) {
                    this.drawCursor(matrixStack, this.editCursor, -5627358);
                    if (this.editCursor != this.editCursorEnd) {
                        this.drawCursor(matrixStack, this.editCursorEnd, -5627358);
                        selectionColor = -2011028822;
                        beginNote = new Note(this.editCursor, 11);
                        endNote = new Note(this.editCursorEnd, 11);
                        x1 = beginNote.getPixelX(this.noteImageX);
                        y1 = beginNote.getPixelY(this.noteImageY);
                        x2 = endNote.getPixelX(this.noteImageX);
                        y2 = endNote.getPixelY(this.noteImageY);
                        if (y1 == y2) {
                            GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)y1, (int)(x2 + 2), (int)(y1 + 36), (int)selectionColor);
                        } else {
                            x_end = new Note(47, 11).getPixelX(this.noteImageX);
                            x_begin = new Note(0, 11).getPixelX(this.noteImageX);
                            GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)y1, (int)(x_end + 2), (int)(y1 + 36), (int)selectionColor);
                            GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x_begin + 1), (int)y2, (int)(x2 + 2), (int)(y2 + 36), (int)selectionColor);
                            for (y = y1 + 39; y <= y2 - 39; y += 39) {
                                GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x_begin + 1), (int)y, (int)(x_end + 2), (int)(y + 36), (int)selectionColor);
                            }
                        }
                    }
                }
            }
            if (!this.neighborsHidden) {
                for (byte[] m : this.neighborMusics) {
                    for (int i3 = 0; i3 < m.length; ++i3) {
                        this.drawNote(matrixStack, i3, m, octaveColorsTrans);
                    }
                }
            }
            for (i = 0; i < this.length; ++i) {
                this.drawNote(matrixStack, i, this.music, octaveColors);
            }
        }
        if (this.previewStarted) {
            i = this.previewCursor - 1;
            Note note = new Note(i, 11);
            int x = note.getPixelX(this.noteImageX);
            int y = note.getPixelY(this.noteImageY);
            GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(x + 1), (int)y, (int)(x + 2), (int)(y + 36), (int)-5601246);
            if (this.music[i] != 0) {
                note = new Note(i, (this.music[i] - 1) % 12);
                x = note.getPixelX(this.noteImageX);
                y = note.getPixelY(this.noteImageY);
                GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + 3), (int)(y + 3), (int)-16777216);
            }
        }
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (!this.gettingSigned && !this.isSigned && this.validClick(mouseX - this.noteImageX, mouseY - this.noteImageY)) {
            GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)(mouseX - 1), (int)(mouseY - 1), (int)(mouseX + 2), (int)(mouseY + 2), (int)octaveColors[this.currentOctave]);
        }
        if (this.buttonHideNeighbors.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("note.toggleTooltip"), mouseX, mouseY);
        }
        if (this.buttonLockPrevIns.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("note.lockTooltip"), mouseX, mouseY);
        }
        if (this.buttonPreview.func_230449_g_()) {
            this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("note.previewTooltip"), mouseX, mouseY);
        }
    }

    private void drawNote(MatrixStack matrixStack, int i, byte[] music, int[] octaveColors) {
        if (music[i] != 0) {
            byte value = music[i];
            int height = (value - 1) % 12;
            Note note = new Note(i, height);
            int x = note.getPixelX(this.noteImageX);
            int y = note.getPixelY(this.noteImageY);
            GuiMusicSheet.func_238467_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)(x + 3), (int)(y + 3), (int)octaveColors[(value - 1) / 12]);
        }
    }

    private void startPreview() {
        this.previewStarted = false;
        this.previewing = true;
        this.previewCursor = this.editCursor;
        this.updateCount = 0;
        this.buttonPreview.setTexStarts(240, 0);
    }

    private void stopPreview() {
        this.previewing = false;
        this.previewStarted = false;
        this.buttonPreview.setTexStarts(224, 0);
    }

    private void updateLength() {
        for (int i = this.length - 1; i >= 0; --i) {
            if (this.music[i] == 0) continue;
            this.length = i + 1;
            return;
        }
        this.length = 0;
    }

    public boolean func_231044_a_(double dmouseX, double dmouseY, int mouseButton) {
        Note note;
        int my;
        int mx;
        boolean composing;
        int mouseX = (int)Math.round(dmouseX);
        int mouseY = (int)Math.round(dmouseY);
        boolean viewingSelfSigned = this.isSigned && this.selfSigned;
        boolean bl = composing = !this.isSigned && !this.gettingSigned;
        if (composing || viewingSelfSigned) {
            if (mouseButton == 1 && this.validClick(mx = mouseX - this.noteImageX, my = mouseY - this.noteImageY)) {
                note = new Note();
                note.setNoteCoords(mx, my);
                this.editCursorEnd = this.editCursor = note.getNoteX();
                this.selectionStart = this.editCursor;
            }
            if (mouseButton == 0 && viewingSelfSigned) {
                this.editCursorEnd = this.editCursor;
            }
        }
        if (composing && mouseButton == 0) {
            mx = mouseX - this.noteImageX;
            my = mouseY - this.noteImageY;
            if (this.validClick(mx, my)) {
                note = new Note();
                note.setNoteCoords(mx, my);
                int x = note.getNoteX();
                int y = note.getNoteY();
                if (y == 12) {
                    return false;
                }
                byte value = (byte)(y + 1 + this.currentOctave * 12);
                if (value == this.music[x]) {
                    this.changeNote(x, (byte)0);
                } else {
                    this.changeNote(x, value);
                }
                this.editCursorEnd = this.editCursor;
            }
            if (mouseX >= 20 + this.noteImageX && mouseX < 20 + this.noteImageX + 20 && mouseY >= 31 + this.noteImageY && mouseY < 31 + this.noteImageY + 5) {
                this.currentOctave = (mouseX - (this.noteImageX + 20)) / 5;
                this.editCursorEnd = this.editCursor;
            }
        }
        return super.func_231044_a_((double)mouseX, (double)mouseY, mouseButton);
    }

    public boolean func_231045_a_(double posX, double posY, int mouseButton, double deltaX, double deltaY) {
        int mouseY;
        int my;
        int mouseX;
        int mx;
        if (mouseButton == 1 && this.updateCount > 10 && this.validClick(mx = (mouseX = (int)Math.round(posX)) - this.noteImageX, my = (mouseY = (int)Math.round(posY)) - this.noteImageY)) {
            Note note = new Note();
            note.setNoteCoords(mx, my);
            int noteX = note.getNoteX();
            if (this.selectionStart > noteX) {
                this.editCursor = noteX;
            } else {
                this.editCursorEnd = noteX;
            }
        }
        return super.func_231045_a_(posX, posY, mouseButton, deltaX, deltaY);
    }

    private void changeNote(int x, byte note) {
        this.changeNote(x, note, true);
    }

    private void changeNote(int x, byte note, boolean play) {
        if (note >= 0 && note <= 48) {
            this.music[x] = note;
            if (note != 0) {
                if (play) {
                    this.playSound(note - 1, this.previewInstrument);
                }
                if (x > this.length - 1) {
                    this.length = x + 1;
                }
            } else if (x == this.length - 1) {
                this.updateLength();
            }
            this.dirty = true;
        }
    }

    private void putSpace(int x) {
        int l;
        if (x == 239) {
            return;
        }
        this.addEditCursor(1);
        if (this.length == 0 || this.length <= x) {
            return;
        }
        this.dirty = true;
        boolean full = false;
        if ((l = this.length++) == 240) {
            full = true;
            --l;
        }
        for (int i = l - 1; i >= x; --i) {
            this.music[i + 1] = this.music[i];
        }
        this.music[x] = 0;
        if (full) {
            this.updateLength();
        }
    }

    private void encodeToClipboard() {
        String encodeBytes = Base64.getEncoder().encodeToString(Arrays.copyOfRange(this.music, this.editCursor, this.editCursorEnd + 1));
        GLFW.glfwSetClipboardString((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (CharSequence)encodeBytes);
        this.editCursorEnd = this.editCursor;
    }

    private void decodeFromClipboard() {
        String encodedMusic = GLFW.glfwGetClipboardString((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i());
        if (encodedMusic != null && !encodedMusic.isEmpty()) {
            byte[] musicPiece;
            try {
                musicPiece = Base64.getDecoder().decode(encodedMusic);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            for (byte b : musicPiece) {
                if (b >= 0 && b <= 48) continue;
                XercaMusic.LOGGER.info("User tried to copy invalid data into music: " + b);
                return;
            }
            for (byte b : musicPiece) {
                this.putSpace(this.editCursor);
                this.changeNote(this.editCursor - 1, b, false);
            }
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean viewingSelfSigned;
        this.func_231035_a_(null);
        super.func_231046_a_(keyCode, scanCode, modifiers);
        boolean bl = viewingSelfSigned = this.isSigned && this.selfSigned;
        if (viewingSelfSigned) {
            if (keyCode == 67 && (modifiers & 2) == 2) {
                this.encodeToClipboard();
            }
            if (keyCode == 65 && (modifiers & 2) == 2) {
                this.editCursor = 0;
                this.editCursorEnd = this.length - 1;
            }
        }
        if (!this.isSigned) {
            if (this.gettingSigned) {
                switch (keyCode) {
                    case 259: {
                        if (this.noteTitle.isEmpty()) break;
                        this.noteTitle = this.noteTitle.substring(0, this.noteTitle.length() - 1);
                        this.updateButtons();
                        break;
                    }
                    case 257: {
                        if (this.noteTitle.isEmpty()) break;
                        this.dirty = true;
                        this.isSigned = true;
                        this.field_230706_i_.func_147108_a(null);
                        break;
                    }
                }
                return true;
            }
            int x = this.editCursor;
            boolean resetEditCursorEnd = true;
            switch (keyCode) {
                case 261: {
                    if (this.length == 0 || this.length <= x) break;
                    this.dirty = true;
                    if (this.editCursorEnd == x) {
                        for (int i = x; i < this.length - 1; ++i) {
                            this.music[i] = this.music[i + 1];
                        }
                        this.music[this.length - 1] = 0;
                        --this.length;
                        break;
                    }
                    this.deleteSelected();
                    break;
                }
                case 259: {
                    if (this.editCursorEnd == x) {
                        if (x == 0) break;
                        this.addEditCursor(-1);
                        if (this.length == 0 || this.length < x) break;
                        this.dirty = true;
                        for (int i = x - 1; i < this.length - 1; ++i) {
                            this.music[i] = this.music[i + 1];
                        }
                        this.music[this.length - 1] = 0;
                        --this.length;
                        break;
                    }
                    if (this.length == 0 || this.length < x) break;
                    this.dirty = true;
                    this.deleteSelected();
                    break;
                }
                case 32: {
                    this.putSpace(x);
                    break;
                }
                case 262: {
                    this.addEditCursor(1);
                    if (this.editCursor < 240) break;
                    this.setEditCursor(0);
                    break;
                }
                case 263: {
                    this.addEditCursor(-1);
                    if (this.editCursor >= 0) break;
                    this.setEditCursor(239);
                    break;
                }
                case 264: {
                    this.addEditCursor(48);
                    if (this.editCursor < 240) break;
                    this.addEditCursor(-240);
                    break;
                }
                case 265: {
                    this.addEditCursor(-48);
                    if (this.editCursor >= 0) break;
                    this.addEditCursor(240);
                    break;
                }
                case 257: {
                    if (!this.previewing) {
                        this.startPreview();
                        break;
                    }
                    this.stopPreview();
                    break;
                }
                case 67: {
                    if ((modifiers & 2) != 2) break;
                    this.encodeToClipboard();
                    break;
                }
                case 86: {
                    if ((modifiers & 2) != 2) break;
                    this.decodeFromClipboard();
                    break;
                }
                case 65: {
                    if ((modifiers & 2) != 2) break;
                    this.editCursor = 0;
                    this.editCursorEnd = this.length - 1;
                    resetEditCursorEnd = false;
                    break;
                }
                case 341: 
                case 345: {
                    resetEditCursorEnd = false;
                    break;
                }
                default: {
                    if (scanCode >= 16 && scanCode <= 27) {
                        this.putSpace(x);
                        this.changeNote(x, (byte)(scanCode - 15 + 12 * this.currentOctave));
                        break;
                    }
                    if (scanCode < 30 || scanCode > 33) break;
                    this.currentOctave = scanCode - 30;
                }
            }
            if (resetEditCursorEnd) {
                this.editCursorEnd = this.editCursor;
            }
        }
        return true;
    }

    private void deleteSelected() {
        int diff = this.editCursorEnd - this.editCursor + 1;
        int deleted = 0;
        for (int i = this.editCursor; i < this.length; ++i) {
            if (i + diff < this.length) {
                this.music[i] = this.music[i + diff];
                continue;
            }
            this.music[i] = 0;
            ++deleted;
        }
        this.length -= deleted;
    }

    private void setEditCursor(int x) {
        if (this.editCursor != this.editCursorEnd) {
            this.editCursor = x;
        } else {
            this.editCursor = x;
            this.editCursorEnd = x;
        }
    }

    private void addEditCursor(int x) {
        this.setEditCursor(this.editCursor + x);
    }

    public boolean func_231042_a_(char typedChar, int something) {
        super.func_231042_a_(typedChar, something);
        if (!this.isSigned) {
            if (this.gettingSigned && this.noteTitle.length() < 16 && SharedConstants.func_71566_a((char)typedChar)) {
                this.noteTitle = this.noteTitle + typedChar;
                this.updateButtons();
            }
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        if (scroll != 0.0) {
            this.currentOctave += scroll > 0.0 ? 1 : -1;
            if (this.currentOctave > 3) {
                this.currentOctave = 0;
            } else if (this.currentOctave < 0) {
                this.currentOctave = 3;
            }
            return true;
        }
        return super.func_231043_a_(x, y, scroll);
    }

    public void func_231164_f_() {
        if (this.dirty) {
            MusicUpdatePacket pack = new MusicUpdatePacket(this.music, this.length, this.pause, this.isSigned, this.noteTitle, (byte)this.previewInstrument, this.prevInsLocked);
            XercaMusic.NETWORK_HANDLER.sendToServer((Object)pack);
        }
    }

    private boolean validClick(int x, int y) {
        return x <= 163 && x >= 20 && y <= 230 && y >= 36;
    }

    public class LockImageButton
    extends ChangeableImageButton {
        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, Button.IPressable onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, 256, 256, onClick);
        }

        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.IPressable onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, StringTextComponent.field_240750_d_);
        }

        public LockImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.IPressable onClick, ITextComponent message) {
            super(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, message);
        }

        @Override
        public void func_230431_b_(MatrixStack matrixStack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            int yTexStartNew = this.preRender();
            LockImageButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.xTexStart, (float)yTexStartNew, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.texWidth, (int)this.texHeight);
            if (GuiMusicSheet.this.prevInsLocked) {
                LockImageButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)(this.texHeight - this.field_230689_k_), (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.texWidth, (int)this.texHeight);
            }
            this.postRender();
        }
    }

    public class ChangeableImageButton
    extends Button {
        protected final ResourceLocation resourceLocation;
        protected int xTexStart;
        protected int yTexStart;
        protected final int yDiffText;
        protected final int texWidth;
        protected final int texHeight;

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, Button.IPressable onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, 256, 256, onClick);
        }

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.IPressable onClick) {
            this(x, y, width, height, xTexStart, yTexStart, yDiffText, texture, texWidth, texHeight, onClick, StringTextComponent.field_240750_d_);
        }

        public ChangeableImageButton(int x, int y, int width, int height, int xTexStart, int yTexStart, int yDiffText, ResourceLocation texture, int texWidth, int texHeight, Button.IPressable onClick, ITextComponent message) {
            super(x, y, width, height, message, onClick);
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.xTexStart = xTexStart;
            this.yTexStart = yTexStart;
            this.yDiffText = yDiffText;
            this.resourceLocation = texture;
        }

        public void setTexStarts(int x, int y) {
            this.xTexStart = x;
            this.yTexStart = y;
        }

        protected int preRender() {
            Minecraft lvt_4_1_ = Minecraft.func_71410_x();
            lvt_4_1_.func_110434_K().func_110577_a(this.resourceLocation);
            GlStateManager.func_227731_j_();
            int yTexStartNew = this.yTexStart;
            if (this.func_230449_g_()) {
                yTexStartNew += this.yDiffText;
            }
            return yTexStartNew;
        }

        protected void postRender() {
            GlStateManager.func_227734_k_();
        }

        public void func_230431_b_(MatrixStack matrixStack, int p_230431_2_, int p_230431_3_, float p_230431_4_) {
            int yTexStartNew = this.preRender();
            ChangeableImageButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)this.xTexStart, (float)yTexStartNew, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)this.texWidth, (int)this.texHeight);
            this.postRender();
        }
    }

    private static class Note {
        private int tab;
        private int time;
        private int pitch;

        Note() {
        }

        Note(int time, int pitch) {
            this.time = time;
            this.pitch = pitch;
            this.tab = time / 48;
        }

        int getNoteX() {
            return this.time;
        }

        int getNoteY() {
            return this.pitch;
        }

        void setNoteCoords(int pixelX, int pixelY) {
            int noteX = (pixelX - 20) / 3;
            this.tab = (pixelY - 36) / 39;
            this.time = noteX + this.tab * 48;
            this.pitch = 12 - (pixelY - 36 - this.tab * 39) / 3;
        }

        int getPixelX(int imageX) {
            return imageX + (this.time - this.tab * 48) * 3 + 20;
        }

        int getPixelY(int imageY) {
            return imageY + (12 - this.pitch) * 3 + 36 + this.tab * 39;
        }
    }
}

