/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.block;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.entity.EntityMusicSpirit;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;

public abstract class BlockInstrument
extends Block {
    public BlockInstrument(AbstractBlock.Properties properties) {
        super(properties);
    }

    public abstract ItemInstrument getItemInstrument();

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Vector3d vector3d = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5);
        if (vector3d.func_72438_d(player.func_213303_ch()) > 4.0) {
            return ActionResultType.PASS;
        }
        ItemStack handStack = player.func_184586_b(hand);
        if (handStack.func_77973_b() instanceof ItemMusicSheet) {
            this.playMusic(worldIn, player, true, pos);
            return ActionResultType.SUCCESS;
        }
        ItemStack offhandStack = player.func_184586_b(Hand.values()[(hand.ordinal() + 1) % 2]);
        if (!(offhandStack.func_77973_b() instanceof ItemMusicSheet)) {
            XercaMusic.proxy.showInstrumentGui(this.getItemInstrument());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void playMusic(World worldIn, PlayerEntity playerIn, boolean canStop, BlockPos pos) {
        List musicSpirits = worldIn.func_175647_a(EntityMusicSpirit.class, playerIn.func_174813_aQ().func_186662_g(3.0), entity -> entity.getBody().func_70028_i((Entity)playerIn));
        if (musicSpirits.size() == 0) {
            worldIn.func_217376_c((Entity)new EntityMusicSpirit(worldIn, playerIn, pos, this.getItemInstrument()));
        } else if (canStop) {
            musicSpirits.forEach(spirit -> spirit.setPlaying(false));
        }
    }
}

