/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.tile_entity;

import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xerca.xercamusic.client.NoteSound;
import xerca.xercamusic.common.XercaMusic;
import xerca.xercamusic.common.block.BlockMusicBox;
import xerca.xercamusic.common.item.ItemInstrument;
import xerca.xercamusic.common.item.ItemMusicSheet;
import xerca.xercamusic.common.packets.MusicBoxUpdatePacket;
import xerca.xercamusic.common.tile_entity.TileEntities;

public class TileEntityMusicBox
extends TileEntity
implements ITickableTileEntity {
    private boolean isPlaying = false;
    private boolean oldPoweredState = false;
    private boolean stopPowering = false;
    private ItemStack noteStack = ItemStack.field_190927_a;
    private ItemInstrument instrument;
    private byte[] music;
    private int mLength;
    private int mTime = 0;
    private byte mPause;
    private int age = 0;
    private int poweringAge = 0;
    private NoteSound lastPlayed = null;

    public TileEntityMusicBox() {
        super(TileEntities.MUSIC_BOX);
    }

    public void func_174878_a(BlockPos pos) {
        super.func_174878_a(pos);
    }

    public CompoundNBT func_189515_b(CompoundNBT parent) {
        super.func_189515_b(parent);
        if (!this.noteStack.func_190926_b()) {
            CompoundNBT noteTag = new CompoundNBT();
            this.noteStack.func_77955_b(noteTag);
            parent.func_218657_a("note", (INBT)noteTag);
        }
        if (this.instrument != null) {
            ResourceLocation resourcelocation = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.instrument);
            parent.func_74778_a("instrument_id", resourcelocation == null ? "minecraft:air" : resourcelocation.toString());
        }
        return parent;
    }

    public void func_230337_a_(BlockState state, CompoundNBT parent) {
        super.func_230337_a_(state, parent);
        if (parent.func_150297_b("note", 10)) {
            CompoundNBT noteTag = parent.func_74775_l("note");
            ItemStack note = ItemStack.func_199557_a((CompoundNBT)noteTag);
            this.setNoteStack(note);
        }
        if (parent.func_150297_b("instrument_id", 8)) {
            this.setInstrument((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parent.func_74779_i("instrument_id"))));
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.func_230337_a_(state, nbt);
    }

    private void stopPowering() {
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(false)));
        this.stopPowering = false;
        this.poweringAge = 0;
    }

    public void func_73660_a() {
        if (this.stopPowering) {
            if (this.poweringAge >= 20) {
                this.stopPowering();
                return;
            }
            ++this.poweringAge;
        }
        if (this.noteStack.func_190926_b() || this.instrument == null) {
            return;
        }
        BlockState state = this.func_195044_w();
        if (((Boolean)state.func_177229_b((Property)BlockMusicBox.POWERED)).booleanValue()) {
            if (!this.oldPoweredState) {
                this.isPlaying = !this.isPlaying;
                this.age = 0;
                this.mTime = 0;
                this.poweringAge = 0;
                this.oldPoweredState = true;
            }
        } else if (this.oldPoweredState) {
            this.oldPoweredState = false;
        }
        if (this.isPlaying) {
            if (this.mPause == 0) {
                XercaMusic.LOGGER.error("TileEntityMusicBox mPause is 0! THIS SHOULD NOT HAPPEN!");
                return;
            }
            if (this.age % this.mPause == 0) {
                if (this.mTime >= this.mLength) {
                    this.age = 0;
                    this.mTime = 0;
                    this.poweringAge = 0;
                    this.isPlaying = false;
                    this.stopPowering = true;
                    Direction rightSide = ((Direction)state.func_177229_b((Property)BlockMusicBox.field_185512_D)).func_176746_e();
                    this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockMusicBox.POWERING, (Comparable)Boolean.valueOf(true)));
                    BlockPos neighbor = this.field_174879_c.func_177972_a(rightSide);
                    this.field_145850_b.func_190524_a(neighbor, this.func_195044_w().func_177230_c(), this.field_174879_c);
                    this.field_145850_b.func_175695_a(neighbor, this.func_195044_w().func_177230_c(), rightSide.func_176734_d());
                    return;
                }
                if (this.field_145850_b.field_72995_K && this.mTime < this.music.length && this.music[this.mTime] != 0 && this.music[this.mTime] <= 48) {
                    if (this.instrument.shouldCutOff && this.lastPlayed != null) {
                        this.lastPlayed.stopSound();
                    }
                    this.lastPlayed = XercaMusic.proxy.playNote(this.instrument.getSound(this.music[this.mTime] - 1), this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.5, this.field_174879_c.func_177952_p(), SoundCategory.RECORDS, 4.0f, 1.0f);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 2.2, (double)this.field_174879_c.func_177952_p() + 0.5, (double)(this.music[this.mTime] - 1) / 24.0, 0.0, 0.0);
                }
                ++this.mTime;
            }
        }
        ++this.age;
    }

    public ItemStack getNoteStack() {
        return this.noteStack;
    }

    public void setNoteStack(ItemStack noteStack) {
        if (noteStack.func_77973_b() instanceof ItemMusicSheet) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.updateClient(noteStack, this.instrument);
            }
            this.noteStack = noteStack;
            if (noteStack.func_77942_o() && noteStack.func_77978_p().func_74764_b("music")) {
                CompoundNBT comp = noteStack.func_77978_p();
                this.music = comp.func_74770_j("music");
                this.mLength = comp.func_74762_e("length");
                this.mPause = comp.func_74771_c("pause");
            }
            this.func_70296_d();
        }
    }

    public void removeNoteStack() {
        if (!this.noteStack.func_190926_b()) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.updateClient(ItemStack.field_190927_a, this.instrument);
            }
            this.noteStack = ItemStack.field_190927_a;
            this.func_70296_d();
        }
    }

    public ItemInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Item instrument) {
        if (instrument instanceof ItemInstrument) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.updateClient(null, instrument);
            }
            this.instrument = (ItemInstrument)instrument;
            this.func_70296_d();
        }
    }

    public void removeInstrument() {
        if (this.instrument != null) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.updateClient(null, null);
            }
            this.instrument = null;
            this.func_70296_d();
        }
    }

    private void updateClient(ItemStack noteStack, Item itemInstrument) {
        MusicBoxUpdatePacket packet = new MusicBoxUpdatePacket(this.field_174879_c, noteStack, itemInstrument);
        XercaMusic.NETWORK_HANDLER.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)this.field_145850_b.func_217349_x(this.field_174879_c)), (Object)packet);
    }
}

