/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraftforge.eventbus.EventBusErrorMessage;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.IEventListener;
import net.minecraftforge.fml.AutomaticEventSubscriber;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.event.lifecycle.IModBusEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ScalaModContainer
extends ModContainer {
    private static final Logger LOGGER = LogManager.getLogger(ScalaModContainer.class);
    private final String className;
    private final ClassLoader modClassLoader;
    private final ModFileScanData scanData;
    private final boolean isScalaObject;
    private final IEventBus eventBus;
    private Class<?> modClass;
    private Object modInstance;

    public ScalaModContainer(IModInfo info, String className, ClassLoader modClassLoader, ModFileScanData modFileScanResults) {
        super(info);
        this.className = className;
        this.modClassLoader = modClassLoader;
        LOGGER.debug(Logging.LOADING, "Creating scala container Class: {}, with classLoader {} & {}", (Object)className, (Object)modClassLoader, (Object)((Object)((Object)this)).getClass().getClassLoader());
        this.scanData = modFileScanResults;
        this.isScalaObject = className.endsWith("$");
        this.activityMap.put(ModLoadingStage.CONSTRUCT, this::constructMod);
        this.eventBus = BusBuilder.builder().setExceptionHandler(this::onEventFailed).setTrackPhases(false).markerType(IModBusEvent.class).build();
        this.configHandler = Optional.of(arg_0 -> ((IEventBus)this.eventBus).post(arg_0));
        FMLJavaModLoadingContext contextExtension = ScalaModContainer.createContext(this.getEventBus());
        this.contextExtension = () -> contextExtension;
    }

    private void constructMod() {
        try {
            this.modClass = Class.forName(this.className, true, this.modClassLoader);
            LOGGER.debug(Logging.LOADING, "Scala Class Loaded {} with {}.", this.modClass, (Object)this.modClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(Logging.LOADING, "Failed to load class {}", (Object)this.className, (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmodclass", (Throwable)e, new Object[0]);
        }
        try {
            if (this.isScalaObject) {
                LOGGER.debug(Logging.LOADING, "Scala Mod instance object for {} is about to get via MODULE$ field. {}", (Object)this.modId, (Object)this.modClass.getName());
                this.modInstance = this.modClass.getField("MODULE$").get(null);
                LOGGER.debug(Logging.LOADING, "Scala Mod instance for {} was got. {}", (Object)this.modId, this.modInstance);
            } else {
                LOGGER.debug(Logging.LOADING, "Scala Mod instance for {} is about to create. {}", (Object)this.modId, (Object)this.modClass.getName());
                Constructor<?> constructor = this.modClass.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.modInstance = constructor.newInstance(new Object[0]);
                LOGGER.debug(Logging.LOADING, "Scala Mod instance for {} created. {}", (Object)this.modId, this.modInstance);
            }
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error(Logging.LOADING, "Failed to create/get mod instance. ModID: {}, class {}", (Object)this.modId, (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", (Throwable)e, new Object[]{this.modClass});
        }
        try {
            LOGGER.debug(Logging.LOADING, "Injecting Automatic event subscribers for {}", (Object)this.modId);
            AutomaticEventSubscriber.inject((ModContainer)this, (ModFileScanData)this.scanData, (ClassLoader)this.modClass.getClassLoader());
            LOGGER.debug(Logging.LOADING, "Completed Automatic event subscribers for {}", (Object)this.modId);
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Failed to register automatic subscribers. ModID: {}, class {}", (Object)this.modId, (Object)this.modClass.getName(), (Object)e);
            throw new ModLoadingException(this.modInfo, ModLoadingStage.CONSTRUCT, "fml.modloading.failedtoloadmod", e, new Object[]{this.modClass});
        }
    }

    private void onEventFailed(IEventBus bus, Event event, IEventListener[] listeners, int i, Throwable throwable) {
        LOGGER.error((Message)new EventBusErrorMessage(event, i, listeners, throwable));
    }

    public IEventBus getEventBus() {
        return this.eventBus;
    }

    public boolean matches(Object mod) {
        return mod == this.modInstance;
    }

    public Object getMod() {
        return this.modInstance;
    }

    protected void acceptEvent(Event event) {
        LOGGER.debug(Logging.LOADING, "Firing event for modid {} : {}", (Object)this.modId, (Object)event);
        try {
            this.eventBus.post(event);
            LOGGER.debug(Logging.LOADING, "Fired event for modid {} : {}", (Object)this.modId, (Object)event);
        }
        catch (Throwable e) {
            LOGGER.error(Logging.LOADING, "Caught exception during event {} dispatch for modid {}", (Object)event, (Object)this.modId, (Object)e);
            throw new ModLoadingException(this.modInfo, this.modLoadingStage, "fml.modloading.errorduringevent", e, new Object[0]);
        }
    }

    private static FMLJavaModLoadingContext createContext(IEventBus bus) {
        try {
            FMLJavaModLoadingContext instance = (FMLJavaModLoadingContext)UnsafeHacks.newInstance(FMLJavaModLoadingContext.class);
            FMLModContainer container = (FMLModContainer)UnsafeHacks.newInstance(FMLModContainer.class);
            UnsafeHacks.setField((Field)FMLModContainer.class.getDeclaredField("eventBus"), (Object)container, (Object)bus);
            UnsafeHacks.setField((Field)FMLJavaModLoadingContext.class.getDeclaredField("container"), (Object)instance, (Object)container);
            return instance;
        }
        catch (ReflectiveOperationException e) {
            LOGGER.fatal("Error happened in creating dummy instance.", (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return "ScalaModContainer{modId='" + this.modId + '\'' + ", className='" + this.className + '\'' + ", modClass=" + (this.modClass == null ? "<not initialized>" : this.modClass) + '}';
    }
}

