/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.scala_lib.asm;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScalaLoaderTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger(ScalaLoaderTransformationService.class);

    @Nonnull
    public String name() {
        return "kotori_scala_trans";
    }

    public void initialize(IEnvironment environment) {
    }

    public void beginScanning(IEnvironment environment) {
    }

    public List<Map.Entry<String, Path>> runScan(IEnvironment environment) {
        try {
            Path jarPath = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            LOGGER.debug(LogMarkers.SCAN, "Find `kotori_scala` jar file path. " + jarPath);
            return Collections.singletonList(Pair.of((Object)jarPath.getFileName().toString(), (Object)jarPath));
        }
        catch (URISyntaxException e) {
            LOGGER.error(String.format("Error when getting jar file path. %s", e.getInput()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) {
    }

    @Nonnull
    public List<ITransformer> transformers() {
        return Collections.emptyList();
    }
}

