/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker;

public class Range {
    private final float min;
    private final float max;
    private final float distance;

    public Range(float min, float max) {
        this.min = min;
        this.max = max;
        if (max < min) {
            throw new IllegalArgumentException(String.format("min is grater than max. Min: %f, Max:%f", Float.valueOf(min), Float.valueOf(max)));
        }
        this.distance = max - min;
    }

    public float convert(float f) {
        if (f < this.min) {
            int i = (int)((this.min - f) / this.distance) + 1;
            return this.convert(f + this.distance * (float)i);
        }
        if (f >= this.max) {
            int i = (int)((f - this.max) / this.distance) + 1;
            return this.convert(f - this.distance * (float)i);
        }
        return f;
    }
}

