/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker;

import com.kotori316.marker.IAreaConfigurable;
import com.kotori316.marker.Marker;
import com.kotori316.marker.render.Box;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileFlexMarker
extends TileEntity
implements IAreaConfigurable {
    private BlockPos min = BlockPos.field_177992_a;
    private BlockPos max = BlockPos.field_177992_a;
    @Nullable
    public Box[] boxes;
    @Nullable
    public Box directionBox;
    public Direction direction;

    public TileFlexMarker() {
        super(Marker.Entries.TYPE);
    }

    public void init(Direction facing) {
        this.direction = facing;
        this.min = this.func_174877_v();
        this.max = this.func_174877_v();
        this.move(Movable.LEFT, 5);
        this.move(Movable.RIGHT, 5);
        this.move(Movable.FORWARD, 10);
        this.setRender();
    }

    public void move(Movable movable, int amount) {
        Direction facing = movable.getActualFacing(this.direction);
        BlockPos offset = this.func_174877_v();
        if (facing.func_176743_c() == Direction.AxisDirection.POSITIVE) {
            this.max = this.max.func_177967_a(facing, amount);
            int d = TileFlexMarker.getDistance(this.max, offset, facing.func_176740_k());
            if (d > 64) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, 64);
            } else if (d < 1) {
                this.max = TileFlexMarker.getLimited(this.max, offset, facing, 1);
            }
        } else {
            this.min = this.min.func_177967_a(facing, amount);
            int d = TileFlexMarker.getDistance(offset, this.min, facing.func_176740_k());
            if (d > 64) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, 64);
            } else if (d < 1) {
                this.min = TileFlexMarker.getLimited(this.min, offset, facing, 1);
            }
            if (facing == Direction.DOWN && this.min.func_177956_o() < 0) {
                this.min = new BlockPos(this.min.func_177958_n(), 0, this.min.func_177952_p());
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Runnable setMinMax(BlockPos min, BlockPos max) {
        return () -> {
            this.min = min;
            this.max = max;
            this.setRender();
        };
    }

    private void setRender() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        this.boxes = IAreaConfigurable.getRenderBox(this.min, this.max);
        AxisAlignedBB bb = this.direction == null ? new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) : (this.direction.func_176740_k() == Direction.Axis.X ? new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 0.375 + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.375 + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) : new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() - 0.375 + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.375 + 0.5));
        this.directionBox = Box.apply(bb.func_191194_a(Vector3d.func_237491_b_((Vector3i)this.direction.func_176730_m()).func_186678_a(0.5)), 0.125, 0.125, 0.125, true, true);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74772_a("min", this.min.func_218275_a());
        compound.func_74772_a("max", this.max.func_218275_a());
        compound.func_74778_a("direction", Optional.ofNullable(this.direction).map(Direction::toString).orElse(""));
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.min = BlockPos.func_218283_e((long)compound.func_74763_f("min"));
        this.max = BlockPos.func_218283_e((long)compound.func_74763_f("max"));
        this.direction = Direction.func_176739_a((String)compound.func_74779_i("direction"));
        if (this.func_145830_o()) {
            this.setRender();
        }
    }

    public CompoundNBT func_189517_E_() {
        return super.serializeNBT();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 32768.0;
    }

    public BlockPos min() {
        return this.min == BlockPos.field_177992_a ? this.func_174877_v() : this.min;
    }

    public BlockPos max() {
        return this.max == BlockPos.field_177992_a ? this.func_174877_v() : this.max;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return super.getCapability(cap, side);
    }

    public static int getDistance(BlockPos to, BlockPos from, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return to.func_177958_n() - from.func_177958_n();
            }
            case Y: {
                return to.func_177956_o() - from.func_177956_o();
            }
            case Z: {
                return to.func_177952_p() - from.func_177952_p();
            }
        }
        throw new IllegalStateException(String.format("Other axis? Axis=%s, from=%s, to=%s", axis, from, to));
    }

    public static BlockPos getLimited(BlockPos to, BlockPos from, Direction facing, int limit) {
        switch (facing.func_176740_k()) {
            case X: {
                return new BlockPos(from.func_177958_n(), to.func_177956_o(), to.func_177952_p()).func_177967_a(facing, limit);
            }
            case Y: {
                return new BlockPos(to.func_177958_n(), from.func_177956_o(), to.func_177952_p()).func_177967_a(facing, limit);
            }
            case Z: {
                return new BlockPos(to.func_177958_n(), to.func_177956_o(), from.func_177952_p()).func_177967_a(facing, limit);
            }
        }
        throw new IllegalStateException(String.format("Other axis? Facing=%s, from=%s, to=%s, limit=%d", facing, from, to, limit));
    }

    public static enum Movable {
        UP(facing -> Direction.UP),
        LEFT(Direction::func_176735_f),
        FORWARD(UnaryOperator.identity()),
        RIGHT(Direction::func_176746_e),
        DOWN(facing -> Direction.DOWN);

        private final UnaryOperator<Direction> operator;
        public final String transName;
        private static final Movable[] v;

        private Movable(UnaryOperator<Direction> operator) {
            this.operator = operator;
            this.transName = "gui." + this.name().toLowerCase(Locale.US);
        }

        public Direction getActualFacing(Direction facing) {
            return (Direction)this.operator.apply(facing);
        }

        public static Movable valueOf(int i) {
            return v[i];
        }

        static {
            v = Movable.values();
        }
    }
}

