/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.marker.render;

import com.kotori316.marker.render.Box;
import com.kotori316.marker.render.Buffer;
import com.kotori316.marker.render.ColorBox;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.math.MathHelper;

class BoxY
extends Box {
    final double length;

    BoxY(double startY, double endY, double x, double z, double sizeX, double sizeY, double sizeZ, boolean firstSide, boolean endSide) {
        super(x, startY, z, x, endY, z, sizeX, sizeY, sizeZ, firstSide, endSide);
        this.length = this.dy;
    }

    @Override
    public void render(IVertexBuilder b, MatrixStack matrixStack, TextureAtlasSprite sprite, ColorBox colorBox) {
        int count = MathHelper.func_76128_c((double)(this.length / this.sizeY));
        float minU = sprite.func_94209_e();
        float minV = sprite.func_94206_g();
        float maYU = sprite.func_94214_a(this.sizeY / this.maxSize * 16.0);
        float maXV = sprite.func_94207_b(this.sizeX / this.maxSize * 16.0);
        float maZU = sprite.func_94214_a(this.sizeZ / this.maxSize * 16.0);
        float maZV = sprite.func_94207_b(this.sizeZ / this.maxSize * 16.0);
        int red = colorBox.red;
        int green = colorBox.green;
        int blue = colorBox.blue;
        int alpha = colorBox.alpha;
        Buffer buffer = new Buffer(b, matrixStack);
        if (this.firstSide) {
            buffer.pos(this.endX + this.offX, this.startY, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, minV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maZU, minV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maZU, maXV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, maXV).lightedAndEnd();
        }
        for (int i1 = 0; i1 <= count; ++i1) {
            double i2 = i1 == count ? this.length / this.sizeY : (double)i1 + 1.0;
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * i2, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, minV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * (double)i1, this.endZ - this.offZ).color(red, green, blue, alpha).tex(maYU, minV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * (double)i1, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maYU, maZV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * i2, this.endZ + this.offZ).color(red, green, blue, alpha).tex(minU, maZV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * i2, this.endZ + this.offZ).color(red, green, blue, alpha).tex(minU, minV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * (double)i1, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maYU, minV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * (double)i1, this.endZ - this.offZ).color(red, green, blue, alpha).tex(maYU, maZV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * i2, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, maZV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * i2, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, minV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * (double)i1, this.endZ - this.offZ).color(red, green, blue, alpha).tex(maYU, minV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * (double)i1, this.endZ - this.offZ).color(red, green, blue, alpha).tex(maYU, maXV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * i2, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, maXV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * i2, this.endZ + this.offZ).color(red, green, blue, alpha).tex(minU, minV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.startY + this.sizeY * (double)i1, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maYU, minV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * (double)i1, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maYU, maXV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.startY + this.sizeY * i2, this.endZ + this.offZ).color(red, green, blue, alpha).tex(minU, maXV).lightedAndEnd();
        }
        if (this.endSide) {
            buffer.pos(this.endX - this.offX, this.endY, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, minV).lightedAndEnd();
            buffer.pos(this.endX - this.offX, this.endY, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maZU, minV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.endY, this.endZ + this.offZ).color(red, green, blue, alpha).tex(maZU, maXV).lightedAndEnd();
            buffer.pos(this.endX + this.offX, this.endY, this.endZ - this.offZ).color(red, green, blue, alpha).tex(minU, maXV).lightedAndEnd();
        }
    }
}

