/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.pb;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.base.APacketTile;
import com.yogpc.qp.machines.base.HasInv;
import com.yogpc.qp.machines.base.IDebugSender;
import com.yogpc.qp.machines.pb.PlacerBlock;
import com.yogpc.qp.machines.pb.PlacerContainer;
import com.yogpc.qp.machines.quarry.QuarryFakePlayer;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.packet.TileMessage;
import com.yogpc.qp.utils.Holder;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import scala.Symbol;

public class PlacerTile
extends APacketTile
implements ITickableTileEntity,
HasInv,
IDebugSender,
INamedContainerProvider {
    public static final Symbol SYMBOL = Symbol.apply((String)"Placer");
    public static final String KEY_ITEM = "items";
    public static final String KEY_LAST_PLACED = "last_placed";
    public static final String KEY_RS_MODE = "redstone_mode";
    public static final Map<Direction, Vector3d> DIRECTION_VEC3D_MAP;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    private int lastPlacedIndex = 0;
    public RedstoneMode redstoneMode = RedstoneMode.PULSE;
    private final IItemHandler itemHandler = new InvWrapper((IInventory)this);
    private final LazyOptional<IItemHandler> itemHandlerOpt = LazyOptional.of(() -> this.itemHandler);
    private static final int PULSE_ID = 0;
    private static final int RS_IGNORE_ID = 1;
    private static final int RS_ON_ID = 2;
    private static final int RS_OFF_ID = 3;

    public PlacerTile() {
        super(Holder.placerType());
    }

    public void func_73660_a() {
        Direction facing;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.redstoneMode.isAlways() && this.redstoneMode.shouldWork(() -> this.lambda$tick$0(facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H)))) {
            if (this.field_145850_b.func_175623_d(this.func_174877_v().func_177972_a(facing))) {
                this.placeBlock();
            } else {
                this.breakBlock();
            }
        }
    }

    public void breakBlock() {
        if (this.field_145850_b == null || !this.redstoneMode.canBreak()) {
            return;
        }
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos pos = this.func_174877_v().func_177972_a(facing);
        BlockState state = this.field_145850_b.func_180495_p(pos);
        if (state.func_185887_b((IBlockReader)this.field_145850_b, pos) < 0.0f) {
            return;
        }
        QuarryFakePlayer fake = QuarryFakePlayer.get((ServerWorld)this.field_145850_b, this.func_174877_v());
        fake.func_184611_a(Hand.MAIN_HAND, PlacerTile.getSilkPickaxe());
        List drops = Block.func_220077_a((BlockState)state, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)pos, (TileEntity)this.field_145850_b.func_175625_s(pos), (Entity)fake, (ItemStack)fake.func_184614_ca());
        this.field_145850_b.func_217377_a(pos, false);
        drops.stream().map(s -> ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)s, (boolean)false)).filter(s -> !s.func_190926_b()).forEach(s -> Block.func_180635_a((World)this.field_145850_b, (BlockPos)this.func_174877_v(), (ItemStack)s));
    }

    public void placeBlock() {
        if (this.func_191420_l() || !this.redstoneMode.canPlace()) {
            return;
        }
        Direction facing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos pos = this.func_174877_v().func_177972_a(facing);
        Vector3d hitPos = DIRECTION_VEC3D_MAP.get(facing.func_176734_d()).func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        BlockRayTraceResult rayTrace = new BlockRayTraceResult(hitPos, facing.func_176734_d(), pos, false);
        QuarryFakePlayer fake = QuarryFakePlayer.get((ServerWorld)this.field_145850_b, this.func_174877_v());
        PlacerTile.findEntry(this.inventory, arg_0 -> PlacerTile.lambda$placeBlock$4((PlayerEntity)fake, rayTrace, arg_0), this.lastPlacedIndex).ifPresent(i -> {
            this.lastPlacedIndex = !this.func_70301_a(i).func_190926_b() ? i : PlacerTile.findEntry(this.inventory, s -> !s.func_190926_b() && s.func_77973_b() instanceof BlockItem, i).orElse(0);
            this.func_70296_d();
            this.sendPacket();
        });
        fake.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
    }

    public static <T> OptionalInt findEntry(List<T> check, Predicate<T> filter, int startIndex) {
        int listSize = check.size();
        if (startIndex >= listSize) {
            return OptionalInt.empty();
        }
        return PlacerTile.findEntryInternal(check, filter, startIndex, startIndex, listSize);
    }

    private static <T> OptionalInt findEntryInternal(List<T> check, Predicate<T> filter, int startIndex, int index, int listSize) {
        T value = check.get(index);
        if (filter.test(value)) {
            return OptionalInt.of(index);
        }
        if (index == startIndex - 1 || startIndex == 0 && index == listSize - 1) {
            return OptionalInt.empty();
        }
        int next = index + 1 == listSize ? 0 : index + 1;
        return PlacerTile.findEntryInternal(check, filter, startIndex, next, listSize);
    }

    public static boolean isItemPlaceable(ItemStack stack, PlayerEntity fake, BlockRayTraceResult rayTrace) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        fake.func_184611_a(Hand.MAIN_HAND, stack);
        BlockItemUseContext context = new BlockItemUseContext(new ItemUseContext(fake, Hand.MAIN_HAND, rayTrace));
        return blockItem.func_195942_a(context).func_226247_b_();
    }

    public int getLastPlacedIndex() {
        return this.lastPlacedIndex;
    }

    void sendPacket() {
        PacketHandler.sendToClient(TileMessage.create(this), this.field_145850_b);
    }

    private static ItemStack getSilkPickaxe() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151046_w);
        stack.func_77966_a(Enchantments.field_185306_r, 1);
        return stack;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a(KEY_ITEM, (INBT)ItemStackHelper.func_191282_a((CompoundNBT)new CompoundNBT(), this.inventory));
        compound.func_74768_a(KEY_LAST_PLACED, this.lastPlacedIndex);
        compound.func_74778_a(KEY_RS_MODE, this.redstoneMode.name());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l(KEY_ITEM), this.inventory);
        this.lastPlacedIndex = compound.func_74762_e(KEY_LAST_PLACED);
        try {
            this.redstoneMode = RedstoneMode.valueOf(compound.func_74779_i(KEY_RS_MODE));
        }
        catch (IllegalArgumentException e) {
            QuarryPlus.LOGGER.error("Illegal name was passed to placer mode.", (Throwable)e);
            this.redstoneMode = RedstoneMode.PULSE;
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, this.itemHandlerOpt);
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_200200_C_() {
        return new TranslationTextComponent(this.getDebugName());
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.placer_plus";
    }

    @Override
    public List<? extends ITextComponent> getDebugMessages() {
        return Stream.of("RS Mode: " + this.redstoneMode.toString(), "Last Placed: " + this.getLastPlacedIndex(), "Inv: " + this.inventory.stream().filter(s -> !s.func_190926_b()).count()).map(StringTextComponent::new).collect(Collectors.toList());
    }

    @Override
    public int func_70302_i_() {
        return 9;
    }

    @Override
    public boolean func_191420_l() {
        return this.inventory.stream().allMatch(ItemStack::func_190926_b);
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.func_70302_i_()) {
            return (ItemStack)this.inventory.get(index);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.func_70302_i_()) {
            this.inventory.set(index, (Object)stack);
        }
    }

    @Override
    public boolean func_70300_a(PlayerEntity player) {
        return player.func_70092_e((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p()) <= 64.0;
    }

    @Override
    public void func_174888_l() {
        this.inventory.clear();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public PlacerContainer createMenu(int id, PlayerInventory p, PlayerEntity player) {
        return new PlacerContainer(id, player, this.func_174877_v());
    }

    public void cycleRedstoneMode() {
        this.redstoneMode = RedstoneMode.cycle(this.redstoneMode);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.sendPacket();
        }
    }

    private static /* synthetic */ boolean lambda$placeBlock$4(PlayerEntity fake, BlockRayTraceResult rayTrace, ItemStack i) {
        return PlacerTile.isItemPlaceable(i, fake, rayTrace);
    }

    private /* synthetic */ boolean lambda$tick$0(Direction facing) {
        return PlacerBlock.isPoweredToWork(this.field_145850_b, this.func_174877_v(), facing);
    }

    static {
        EnumMap<Direction, Vector3d> map = new EnumMap<Direction, Vector3d>(Direction.class);
        map.put(Direction.DOWN, new Vector3d(0.5, 0.0, 0.5));
        map.put(Direction.UP, new Vector3d(0.5, 1.0, 0.5));
        map.put(Direction.NORTH, new Vector3d(0.5, 0.5, 0.0));
        map.put(Direction.SOUTH, new Vector3d(0.5, 0.5, 1.0));
        map.put(Direction.EAST, new Vector3d(1.0, 0.5, 0.5));
        map.put(Direction.WEST, new Vector3d(0.0, 0.5, 0.5));
        DIRECTION_VEC3D_MAP = Collections.unmodifiableMap(map);
    }

    public static enum RedstoneMode {
        PULSE(0, true, true),
        PULSE_PLACE_ONLY(0, true, false),
        PULSE_BREAK_ONLY(0, false, true);

        private final int modeID;
        private final boolean placeEnabled;
        private final boolean breakEnabled;

        private RedstoneMode(int modeID, boolean placeEnabled, boolean breakEnabled) {
            this.modeID = modeID;
            this.placeEnabled = placeEnabled;
            this.breakEnabled = breakEnabled;
        }

        public String toString() {
            return this.name().replace('_', ' ');
        }

        public boolean isAlways() {
            return this.modeID == 1 || this.modeID == 2 || this.modeID == 3;
        }

        public boolean isPulse() {
            return this.modeID == 0;
        }

        public boolean canPlace() {
            return this.placeEnabled;
        }

        public boolean canBreak() {
            return this.breakEnabled;
        }

        public boolean isRsOn() {
            return this.modeID == 2;
        }

        public boolean isRsOff() {
            return this.modeID == 3;
        }

        public boolean shouldWork(BooleanSupplier powered) {
            if (this.isRsOn()) {
                return powered.getAsBoolean();
            }
            if (this.isRsOff()) {
                return !powered.getAsBoolean();
            }
            return true;
        }

        public static RedstoneMode cycle(RedstoneMode now) {
            RedstoneMode[] modes = RedstoneMode.values();
            for (int i = 0; i < modes.length; ++i) {
                RedstoneMode mode = modes[i];
                if (mode != now) continue;
                if (i + 1 == modes.length) {
                    return modes[0];
                }
                return modes[i + 1];
            }
            return modes[0];
        }
    }
}

