/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.pump;

import com.yogpc.qp.Config;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.compat.FluidStore;
import com.yogpc.qp.machines.PowerManager;
import com.yogpc.qp.machines.base.APowerTile;
import com.yogpc.qp.machines.base.HasStorage;
import com.yogpc.qp.machines.base.IModule;
import com.yogpc.qp.machines.base.IModule$Done$;
import com.yogpc.qp.machines.base.IModule$NoAction$;
import com.yogpc.qp.machines.base.IModule$NotFinished$;
import com.yogpc.qp.machines.base.IModule$TypeBeforeBreak$;
import com.yogpc.qp.machines.pump.RangeWrapper;
import com.yogpc.qp.machines.pump.TilePump;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.machines.quarry.TileQuarry2;
import com.yogpc.qp.utils.Holder;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraftforge.fluids.FluidStack;
import scala.collection.immutable.Set;
import scala.jdk.javaapi.CollectionConverters;

public abstract class PumpModule
implements IModule {
    public static final String ID = "quarryplus:module_pump";
    private static final Set<IModule.ModuleType> TYPE_SET = CollectionConverters.asScala(Stream.of(IModule$TypeBeforeBreak$.MODULE$).collect(Collectors.toSet())).toSet();

    @Override
    public String id() {
        return ID;
    }

    @Override
    public Set<IModule.ModuleType> calledWhen() {
        return TYPE_SET;
    }

    public static PumpModule fromTile(TilePump pump, APowerTile tile) {
        return new Tile(pump, tile);
    }

    public static PumpModule fromModule(APowerTile connected, IntSupplier unbreaking) {
        return new Module(connected, unbreaking);
    }

    @Override
    public String toString() {
        String simpleName = this.getClass().getName();
        return simpleName.substring(simpleName.lastIndexOf(".") + 1);
    }

    private static class Module
    extends PumpModule {
        private final APowerTile tile;
        private World world;
        private final BlockPos pos;
        private final IntSupplier unbreaking;
        private static final int Y_SIZE = 256;
        private static final int CHUNK_SCALE = 16;
        private byte[][][] blocks;
        private ChunkSection[][][] storageArray;
        private int xOffset;
        private int yOffset;
        private int zOffset;
        private int px;
        private int py = Integer.MIN_VALUE;
        private int cx;
        private int cy = -1;
        private int cz;
        private boolean quarryRange = true;
        private boolean autoChangedRange = false;
        private int block_side_x;
        private int block_side_z;
        private static final int ARRAY_MAX = 524288;
        private static final int[] xb = new int[524288];
        private static final int[] yb = new int[524288];
        private static final int[] zb = new int[524288];
        private static int cp = 0;
        private long fwt;

        public Module(APowerTile connected, IntSupplier unbreaking) {
            this.tile = connected;
            this.world = connected.func_145831_w();
            this.pos = connected.func_174877_v();
            this.unbreaking = unbreaking;
        }

        @Override
        public IModule.Result action(IModule.CalledWhen when) {
            if (when instanceof IModule.BeforeBreak) {
                IModule.BeforeBreak beforeBreak = (IModule.BeforeBreak)when;
                BlockPos target = beforeBreak.pos();
                BlockState state = beforeBreak.world().func_180495_p(target);
                if (TilePump.isLiquid(state)) {
                    this.world = beforeBreak.world();
                    if (this.S_removeLiquids(this.tile, target.func_177958_n(), target.func_177956_o(), target.func_177952_p())) {
                        return IModule$Done$.MODULE$;
                    }
                    return IModule$NotFinished$.MODULE$;
                }
            }
            return IModule$NoAction$.MODULE$;
        }

        private APowerTile G_connected() {
            return this.tile;
        }

        private static void S_put(int x, int y, int z) {
            Module.xb[Module.cp] = x;
            Module.yb[Module.cp] = y;
            Module.zb[Module.cp] = z;
            if (++cp == 524288) {
                cp = 0;
            }
        }

        private void S_searchLiquid(int x, int y, int z) {
            int chunk_side_z;
            int chunk_side_x;
            this.fwt = this.world.func_72820_D();
            int cg = 0;
            cp = 0;
            this.cx = x;
            this.cy = y;
            this.cz = z;
            this.yOffset = y & 0xFFFFFFF0;
            this.py = 255;
            this.px = -1;
            APowerTile tb = this.G_connected();
            RangeWrapper b = null;
            if (tb instanceof TileQuarry || tb instanceof TileQuarry2) {
                b = RangeWrapper.of((Object)tb);
            }
            int range = 0;
            if (b != null && b.yMax != Integer.MIN_VALUE) {
                int z_add;
                chunk_side_x = 1 + (b.xMax >> 4) - (b.xMin >> 4);
                chunk_side_z = 1 + (b.zMax >> 4) - (b.zMin >> 4);
                this.xOffset = b.xMin & 0xFFFFFFF0;
                this.zOffset = b.zMin & 0xFFFFFFF0;
                int x_add = range * 2 + 1 - chunk_side_x;
                if (x_add > 0) {
                    chunk_side_x += x_add;
                    this.xOffset -= ((x_add & 0xFFFFFFFE) << 3) + (x_add % 2 != 0 && (b.xMax + b.xMin + 1) / 2 % 16 <= 8 ? 16 : 0);
                }
                if ((z_add = range * 2 + 1 - chunk_side_z) > 0) {
                    chunk_side_z += z_add;
                    this.zOffset -= ((z_add & 0xFFFFFFFE) << 3) + (z_add % 2 != 0 && (b.zMax + b.zMin + 1) / 2 % 16 <= 8 ? 16 : 0);
                }
            } else {
                this.quarryRange = false;
                chunk_side_x = chunk_side_z = 1 + range * 2;
                this.xOffset = (x >> 4) - range << 4;
                this.zOffset = (z >> 4) - range << 4;
            }
            if (!this.quarryRange) {
                b = null;
            }
            this.block_side_x = chunk_side_x * 16;
            this.block_side_z = chunk_side_z * 16;
            this.blocks = new byte[256 - this.yOffset][this.block_side_x][this.block_side_z];
            this.storageArray = new ChunkSection[chunk_side_x][chunk_side_z][];
            for (int kx = 0; kx < chunk_side_x; ++kx) {
                for (int kz = 0; kz < chunk_side_z; ++kz) {
                    this.storageArray[kx][kz] = this.world.func_72863_F().func_217205_a(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4), true).func_76587_i();
                }
            }
            Module.S_put(x - this.xOffset, y, z - this.zOffset);
            while (cp != cg) {
                ChunkSection ebs_c = this.storageArray[xb[cg] >> 4][zb[cg] >> 4][yb[cg] >> 4];
                if (ebs_c != null) {
                    BlockState b_c = ebs_c.func_177485_a(xb[cg] & 0xF, yb[cg] & 0xF, zb[cg] & 0xF);
                    if (this.blocks[yb[cg] - this.yOffset][xb[cg]][zb[cg]] == 0 && TilePump.isLiquid(b_c)) {
                        this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 63;
                        if ((b != null ? b.xMin & 0xF : 0) < xb[cg]) {
                            Module.S_put(xb[cg] - 1, yb[cg], zb[cg]);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if (xb[cg] < (b != null ? b.xMax - this.xOffset : this.block_side_x - 1)) {
                            Module.S_put(xb[cg] + 1, yb[cg], zb[cg]);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if ((b != null ? b.zMin & 0xF : 0) < zb[cg]) {
                            Module.S_put(xb[cg], yb[cg], zb[cg] - 1);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if (zb[cg] < (b != null ? b.zMax - this.zOffset : this.block_side_z - 1)) {
                            Module.S_put(xb[cg], yb[cg], zb[cg] + 1);
                        } else {
                            this.blocks[Module.yb[cg] - this.yOffset][Module.xb[cg]][Module.zb[cg]] = 127;
                        }
                        if (yb[cg] + 1 < 256) {
                            Module.S_put(xb[cg], yb[cg] + 1, zb[cg]);
                        }
                    }
                }
                if (++cg != 524288) continue;
                cg = 0;
            }
        }

        public boolean S_removeLiquids(APowerTile tile, int x, int y, int z) {
            block18: {
                int bz;
                int bx;
                if (this.cx != x || this.cy != y || this.cz != z || this.py < this.cy || this.world.func_72820_D() - this.fwt > 200L) {
                    this.S_searchLiquid(x, y, z);
                } else {
                    this.storageArray = new ChunkSection[this.storageArray.length][this.storageArray[0].length][];
                    for (int kx = 0; kx < this.storageArray.length; ++kx) {
                        for (int kz = 0; kz < this.storageArray[0].length; ++kz) {
                            this.storageArray[kx][kz] = this.world.func_72863_F().func_217205_a(kx + (this.xOffset >> 4), kz + (this.zOffset >> 4), true).func_76587_i();
                        }
                    }
                }
                int count = 0;
                while (true) {
                    if (this.px == -1) {
                        for (bx = 0; bx < this.block_side_x; ++bx) {
                            for (bz = 0; bz < this.block_side_z; ++bz) {
                                BlockState bb;
                                if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0 || !TilePump.isLiquid(bb = this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF))) continue;
                                ++count;
                            }
                        }
                    } else {
                        BlockPos.Mutable mutableBlockPos = new BlockPos.Mutable();
                        for (bz = 0; bz < this.block_side_z; ++bz) {
                            if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                            BlockState bb = this.storageArray[this.px >> 4][bz >> 4][this.py >> 4].func_177485_a(this.px & 0xF, this.py & 0xF, bz & 0xF);
                            mutableBlockPos.func_181079_c(this.px + this.xOffset, this.py, bz + this.zOffset);
                            if (!TilePump.isLiquid(bb, (Boolean)Config.common().removeOnlySource().get(), this.world, (BlockPos)mutableBlockPos)) continue;
                            ++count;
                        }
                    }
                    if (count <= 0 && ++this.px < this.block_side_x) continue;
                    if (count > 0) break;
                    this.px = -1;
                    if (--this.py < this.cy) break;
                }
                if (count <= 0 || !PowerManager.useEnergyPump(tile, this.unbreaking.getAsInt(), count, this.px == -1 ? (long)count : 0L)) break block18;
                if (this.px == -1) {
                    for (bx = 0; bx < this.block_side_x; ++bx) {
                        for (bz = 0; bz < this.block_side_z; ++bz) {
                            if ((this.blocks[this.py - this.yOffset][bx][bz] & 0x40) == 0) continue;
                            this.drainBlock(bx, bz, Holder.blockFrame().getDammingState());
                            if (!(tile instanceof TileQuarry) && !(tile instanceof TileQuarry2)) continue;
                            RangeWrapper wrapper = RangeWrapper.of((Object)tile);
                            int xTarget = bx + this.xOffset;
                            int zTarget = bz + this.zOffset;
                            if (wrapper.waiting()) {
                                if (wrapper.xMin > xTarget || xTarget > wrapper.xMax || wrapper.zMin > zTarget || zTarget > wrapper.zMax) continue;
                                if (Config.common().debug()) {
                                    QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                                }
                                this.autoChange(true);
                                continue;
                            }
                            if (Config.common().debug() && wrapper.xMin < xTarget && xTarget < wrapper.xMax && wrapper.zMin < zTarget && zTarget < wrapper.zMax) {
                                QuarryPlus.LOGGER.warn(String.format("Quarry placed frame at %d, %d, %d", xTarget, this.py, zTarget));
                            }
                            this.autoChange(false);
                        }
                    }
                } else {
                    for (bz = 0; bz < this.block_side_z; ++bz) {
                        if (this.blocks[this.py - this.yOffset][this.px][bz] == 0) continue;
                        this.drainBlock(this.px, bz, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            return this.py < this.cy;
        }

        private void autoChange(boolean on) {
            if (on) {
                this.autoChangedRange = true;
                this.quarryRange = false;
            } else if (this.autoChangedRange) {
                this.autoChangedRange = false;
                this.quarryRange = true;
            }
        }

        private void drainBlock(int bx, int bz, BlockState tb) {
            BlockState blockState = this.storageArray[bx >> 4][bz >> 4][this.py >> 4].func_177485_a(bx & 0xF, this.py & 0xF, bz & 0xF);
            if (TilePump.isLiquid(blockState)) {
                BlockPos blockPos = new BlockPos(bx + this.xOffset, this.py, bz + this.zOffset);
                FluidState fluidState = this.world.func_204610_c(blockPos);
                if (fluidState.func_206889_d()) {
                    if (this.tile instanceof HasStorage) {
                        HasStorage.Storage storage = ((HasStorage)((Object)this.tile)).getStorage();
                        storage.insertFluid(new FluidStack(fluidState.func_206886_c(), 1000));
                    } else {
                        FluidStore.injectToNearTile(this.world, this.pos, new FluidStack(fluidState.func_206886_c(), 1000));
                    }
                }
                if (blockState.func_185904_a().func_76224_d()) {
                    this.world.func_175656_a(blockPos, tb);
                } else if (blockState.func_177230_c() instanceof IBucketPickupHandler) {
                    ((IBucketPickupHandler)blockState.func_177230_c()).func_204508_a((IWorld)this.world, blockPos, blockState);
                } else {
                    this.world.func_175656_a(blockPos, tb);
                }
            }
        }
    }

    private static class Tile
    extends PumpModule {
        private final TilePump pump;
        private final APowerTile tile;

        public Tile(TilePump pump, APowerTile tile) {
            this.pump = Objects.requireNonNull(pump);
            this.tile = Objects.requireNonNull(tile);
        }

        @Override
        public IModule.Result action(IModule.CalledWhen when) {
            if (when instanceof IModule.BeforeBreak) {
                IModule.BeforeBreak beforeBreak = (IModule.BeforeBreak)when;
                BlockPos target = beforeBreak.pos();
                BlockState state = beforeBreak.world().func_180495_p(target);
                if (TilePump.isLiquid(state)) {
                    if (this.pump.S_removeLiquids(this.tile, target.func_177958_n(), target.func_177956_o(), target.func_177952_p())) {
                        return IModule$Done$.MODULE$;
                    }
                    return IModule$NotFinished$.MODULE$;
                }
            }
            return IModule$NoAction$.MODULE$;
        }
    }
}

