/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.integration.ftbchunks.QuarryChunkProtectionManager;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.quarry.BlockItemEnchantable;
import com.yogpc.qp.machines.quarry.TileMiningWell;
import com.yogpc.qp.utils.Holder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlockMiningWell
extends QPBlock {
    private final ArrayList<ItemStack> drops = new ArrayList();

    public BlockMiningWell() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "miningwellplus", BlockItemEnchantable::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH)).func_206870_a((Property)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (super.func_225533_a_(state, worldIn, pos, player, hand, hit).func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(player, hand, stack, (RayTraceResult)hit)) {
            Optional.ofNullable((TileMiningWell)worldIn.func_175625_s(pos)).ifPresent(TileMiningWell::G_ReInit);
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b() == Holder.itemStatusChecker()) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((IEnchantableTile)worldIn.func_175625_s(pos)).ifPresent(t -> t.sendEnchantMassage(player));
            }
            return ActionResultType.SUCCESS;
        }
        if (stack.func_77973_b() == Holder.itemYSetter()) {
            if (!worldIn.field_72995_K) {
                // empty if block
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            Direction facing = placer.func_184172_bi().func_176734_d();
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            Optional.ofNullable((TileMiningWell)worldIn.func_175625_s(pos)).ifPresent(IEnchantableTile.Util.initConsumer(stack).andThen(QuarryChunkProtectionManager.minerSendProtectionNotification(placer)));
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileMiningWell tile;
            this.drops.clear();
            if (!worldIn.field_72995_K && (tile = (TileMiningWell)worldIn.func_175625_s(pos)) != null) {
                tile.removePipes();
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean b) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, b);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable((TileMiningWell)worldIn.func_175625_s(pos)).ifPresent(TileMiningWell::G_renew_powerConfigure);
        }
    }

    @Override
    public TileEntityType<? extends TileEntity> getTileType() {
        return Holder.miningWellTileType();
    }
}

