/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.compat.BuildcraftHelper;
import com.yogpc.qp.integration.ftbchunks.QuarryChunkProtectionManager;
import com.yogpc.qp.machines.base.IEnchantableTile;
import com.yogpc.qp.machines.base.QPBlock;
import com.yogpc.qp.machines.base.StatusContainer;
import com.yogpc.qp.machines.item.YSetterInteractionObject;
import com.yogpc.qp.machines.quarry.BlockItemEnchantable;
import com.yogpc.qp.machines.quarry.ContainerQuarryModule;
import com.yogpc.qp.machines.quarry.TileQuarry2;
import com.yogpc.qp.utils.Holder;
import java.util.Optional;
import java.util.function.Consumer;
import jp.t2v.lab.syntax.MapStreamSyntax;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockQuarry2
extends QPBlock {
    public BlockQuarry2() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d), "quarry", BlockItemEnchantable::new);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH)).func_206870_a((Property)QPBlock.WORKING(), (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (!worldIn.field_72995_K) {
            Direction facing = placer.func_174811_aO().func_176734_d();
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)facing), 2);
            Consumer consumer = IEnchantableTile.Util.initConsumer(stack);
            Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(TileQuarry2.class)).ifPresent(consumer.andThen(TileQuarry2.requestTicket).andThen(QuarryChunkProtectionManager.sendProtectionNotification(placer)));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, QPBlock.WORKING()});
    }

    @Override
    public TileEntityType<? extends TileEntity> getTileType() {
        return Holder.quarry2();
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable(worldIn.func_175625_s(pos)).flatMap(MapStreamSyntax.optCast(TileQuarry2.class)).ifPresent(TileQuarry2::neighborChanged);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (super.func_225533_a_(state, worldIn, pos, player, hand, hit).func_226247_b_()) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (BuildcraftHelper.isWrench(player, hand, stack, (RayTraceResult)hit)) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileQuarry2)worldIn.func_175625_s(pos)).ifPresent(tileQuarry2 -> tileQuarry2.onActivated(player));
            }
            return ActionResultType.SUCCESS;
        }
        if (!player.func_213453_ef()) {
            if (!worldIn.field_72995_K) {
                Optional.ofNullable((TileQuarry2)worldIn.func_175625_s(pos)).map(t -> {
                    if (stack.func_77973_b() == Holder.itemYSetter()) {
                        return YSetterInteractionObject.apply(t, pos);
                    }
                    if (stack.func_77973_b() == Holder.itemStatusChecker()) {
                        return new StatusContainer.ContainerProvider(pos);
                    }
                    return new ContainerQuarryModule.InteractionObject(pos, "block.quarryplus.quarry");
                }).ifPresent(o -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)o, (BlockPos)pos));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity entity;
            if (!worldIn.field_72995_K && (entity = worldIn.func_175625_s(pos)) instanceof TileQuarry2) {
                TileQuarry2 inventory = (TileQuarry2)entity;
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)inventory.moduleInv());
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }
}

