/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.quarry;

import com.yogpc.qp.machines.quarry.ContainerSolidQuarry;
import com.yogpc.qp.machines.quarry.TileQuarry;
import com.yogpc.qp.utils.Holder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileSolidQuarry
extends TileQuarry
implements INamedContainerProvider {
    public static final String GUI_ID = "quarryplus:gui_solidquarry";
    private static final long fuelEfficiency = 4000000L;
    private ItemStack fuel = ItemStack.field_190927_a;
    private int fuelCount = 0;
    public final IIntArray fuelCountAccessor = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileSolidQuarry.this.fuelCount;
                }
                case 1: {
                    return (int)(TileSolidQuarry.this.getStoredEnergy() / 100000L);
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    TileSolidQuarry.this.fuelCount = value;
                    break;
                }
                case 1: {
                    TileSolidQuarry.this.setStoredEnergy((long)value * 100000L);
                    break;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public TileSolidQuarry() {
        super(Holder.solidQuarryType());
    }

    @Override
    public boolean canReceive() {
        return false;
    }

    @Override
    protected void getEnergyInTick() {
        if (this.fuelCount > 0) {
            if (this.getEnergy(4000000L, false) == 4000000L) {
                --this.fuelCount;
                this.getEnergy(4000000L, true);
            }
        } else {
            int burn = ForgeHooks.getBurnTime((ItemStack)this.fuel);
            if (burn > 0) {
                this.fuelCount += burn / 5;
                if (this.fuel.hasContainerItem() && this.fuel.func_190916_E() == 1) {
                    this.func_70299_a(0, this.fuel.getContainerItem());
                } else {
                    this.func_70298_a(0, 1);
                }
            }
        }
    }

    @Override
    protected BlockState S_getFillBlock() {
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public void read(CompoundNBT nbt) {
        super.read(nbt);
        this.fuelCount = nbt.func_74762_e("fuelCount");
        this.fuel = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("fuel"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("fuelCount", this.fuelCount);
        nbt.func_218657_a("fuel", (INBT)this.fuel.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Override
    public String getDebugName() {
        return "block.quarryplus.solidquarry";
    }

    @Override
    public boolean func_70300_a(PlayerEntity player) {
        return player.field_70170_p.func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public int func_70302_i_() {
        return 2;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.fuel;
        }
        return super.func_70301_a(i - 1);
    }

    @Override
    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack temp = this.fuel;
            this.fuel = ItemStack.field_190927_a;
            return temp;
        }
        return super.func_70304_b(index - 1);
    }

    @Override
    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0) {
            this.fuel = stack;
        } else {
            super.func_70299_a(index - 1, stack);
        }
    }

    @Override
    public ItemStack func_70298_a(int index, int count) {
        if (index == 0) {
            if (this.fuel.func_190916_E() <= count) {
                return this.func_70304_b(0);
            }
            return this.fuel.func_77979_a(count);
        }
        return super.func_70298_a(index - 1, count);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && FurnaceTileEntity.func_213991_b((ItemStack)stack);
    }

    @Override
    public void func_174888_l() {
        this.fuel = ItemStack.field_190927_a;
        super.func_174888_l();
    }

    @Override
    public boolean func_191420_l() {
        return super.func_191420_l() && this.fuel.func_190926_b();
    }

    @Override
    public IItemHandlerModifiable createHandler() {
        return new InvWrapper(this){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 0) {
                    ItemStack stackInSlot = this.getInv().func_70301_a(slot);
                    if (stackInSlot.func_77973_b() == Items.field_151133_ar) {
                        if (simulate) {
                            if (stackInSlot.func_190916_E() < amount) {
                                return stackInSlot.func_77946_l();
                            }
                            ItemStack copy = stackInSlot.func_77946_l();
                            copy.func_190920_e(amount);
                            return copy;
                        }
                        int m = Math.min(stackInSlot.func_190916_E(), amount);
                        ItemStack decrStackSize = this.getInv().func_70298_a(slot, m);
                        this.getInv().func_70296_d();
                        return decrStackSize;
                    }
                    return ItemStack.field_190927_a;
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    @Override
    protected boolean isWorking() {
        return super.isWorking() && (this.fuelCount > 0 || !this.fuel.func_190926_b());
    }

    @Override
    public List<ITextComponent> getDebugMessages() {
        List<ITextComponent> list = super.getDebugMessages();
        list.add((ITextComponent)new StringTextComponent("FuelCount : " + this.fuelCount));
        return list;
    }

    public Container createMenu(int id, PlayerInventory i, PlayerEntity p) {
        return new ContainerSolidQuarry(id, p, this.field_174879_c);
    }
}

