/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.mods.adlods.Commands;
import com.endertech.minecraft.mods.adlods.deposit.Deposit;
import com.endertech.minecraft.mods.adlods.deposit.DepositGenerator;
import com.endertech.minecraft.mods.adlods.vanilla.VanillaController;
import java.nio.file.Path;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.Mod;

@Mod(value="adlods")
public class AdLods
extends ForgeMod {
    public static final String ID = "adlods";
    public static final String NAME = "Large Ore Deposits";
    private static AdLods instance;
    public final DepositGenerator generator;
    public final VanillaController controller;

    public AdLods() {
        instance = this;
        this.generator = new DepositGenerator(this);
        this.controller = new VanillaController(this);
        this.mainConfigInit();
    }

    public static AdLods getInstance() {
        return instance;
    }

    public String getId() {
        return ID;
    }

    public ForgeMod.RequiredSide getRequiredSide() {
        return ForgeMod.RequiredSide.SERVER;
    }

    public void commonInit() {
    }

    public void mainConfigInit() {
        UnitConfig config = UnitConfig.in((Path)this.getConfigsDir(), (String)this.getId());
        String category = "Server";
        String deposits = Names.dotted().join(new String[]{"Server", "Deposits"});
        Deposit.globalSizeMultiplier = config.getFloat(deposits, "globalSizeMultiplier", 1.0f, FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)), "Size multiplier to be applied to all deposits.");
        Deposit.globalSpawnRateMultiplier = config.getFloat(deposits, "globalSpawnRateMultiplier", 1.0f, FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(10.0f)), "Spawn rate multiplier to be applied to all deposits.");
        config.save();
    }

    public void updateReloadedTags() {
        this.generator.loadDeposits();
        this.controller.loadOres();
    }

    protected void serverStopped(MinecraftServer server) {
        this.controller.unloadOres();
    }

    public void registerCommands(ServerCommand command) {
        String deposit = "deposit";
        command.requires(ServerCommand.OpLevel.NORMAL);
        command.task("list").executes(Commands::listDeposits, "deposits").executes(Commands::listGenerated, "generated");
        command.task("add").executes(context -> Commands.addDeposit(context, false), new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS)});
        command.task("addspec").executes(context -> Commands.addDeposit(context, true), new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"rarity", (IntBounds)Deposit.Rarity.BOUNDS), ServerCommand.Arg.bounds((String)"size", (IntBounds)Deposit.Size.BOUNDS), ServerCommand.Arg.bounds((String)"altitude", (IntBounds)Deposit.Altitude.BOUNDS), ServerCommand.Arg.string((String)"oreId (in quotes)")});
        command.task("remove").executes(Commands::removeDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit")});
        command.task("gen").executes(Commands::generateDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit")}).executes(Commands::generateDepositAtChunk, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"chunkX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"chunkZ", (IntBounds)IntBounds.INTEGER)});
        command.task("genat").executes(Commands::generateDepositAtPos, new ServerCommand.Arg[]{ServerCommand.Arg.integer((String)"posX", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.integer((String)"posZ", (IntBounds)IntBounds.INTEGER), ServerCommand.Arg.string((String)"deposit")});
        command.task("test").executes(Commands::testDeposit, new ServerCommand.Arg[]{ServerCommand.Arg.string((String)"deposit"), ServerCommand.Arg.integer((String)"amount", (IntBounds)Deposit.Size.BOUNDS)});
        command.task("reload").executes(Commands::reloadConfigs, new ServerCommand.Arg[0]);
        command.task("strip").executes(Commands::stripChunk, "chunk").executes(Commands::stripChunksAround, "around");
        command.task("dress").executes(Commands::dressChunk, "chunk").executes(Commands::dressChunksAround, "around").executes(Commands::dressAllChunks, "all");
        command.register();
    }
}

