/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.forge.core.ForgeMod;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public abstract class AbstractGenerator
extends Feature<NoFeatureConfig> {
    protected final ConfiguredFeature<?, ?> configuredFeature;

    public AbstractGenerator(ForgeMod mod, String name) {
        super(NoFeatureConfig.field_236558_a_);
        this.setRegistryName(mod.getId(), name);
        this.configuredFeature = this.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215022_h.func_227446_a_((IPlacementConfig)new NoPlacementConfig()));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::doAdditions);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::doRemovals);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, this::doOther);
    }

    public abstract boolean generateAt(ISeedReader var1, ChunkPos var2);

    public abstract void doAdditions(BiomeLoadingEvent var1);

    public abstract void doRemovals(BiomeLoadingEvent var1);

    public abstract void doOther(BiomeLoadingEvent var1);

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        return this.generateAt(world, new ChunkPos(pos));
    }
}

