/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adlods.world;

import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.GameWorld;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Stripper {
    protected static final Map<World, Stripper> strippers = new ConcurrentHashMap<World, Stripper>();
    protected final Map<ChunkPos, BlockState[][][]> strippedChunks = new ConcurrentHashMap<ChunkPos, BlockState[][][]>();

    public static Stripper getFor(World world) {
        Stripper stripper = strippers.get(world);
        if (stripper == null) {
            stripper = new Stripper();
            strippers.put(world, stripper);
        }
        return stripper;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        strippers.remove(event.getWorld());
    }

    public void stripChunk(World world, ChunkPos chunkPos, BiPredicate<World, BlockPos> isOreBlock) {
        if (this.strippedChunks.containsKey(chunkPos)) {
            return;
        }
        BlockState[][][] data = new BlockState[16][ChunkBounds.DEFAULT_HEIGHT][16];
        ChunkBounds bounds = ChunkBounds.from((ChunkPos)chunkPos);
        bounds.forEach(pos -> {
            BlockState state;
            BlockPos rel = bounds.relative((BlockPos)pos);
            if (pos.func_177956_o() <= 0 || GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos) || isOreBlock.test(world, (BlockPos)pos) || world.func_175625_s((BlockPos)pos) != null) {
                return;
            }
            data[rel.func_177958_n()][rel.func_177956_o()][rel.func_177952_p()] = state = world.func_180495_p((BlockPos)pos);
            world.func_180501_a((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), 50);
        });
        this.strippedChunks.put(chunkPos, data);
    }

    public void stripChunksAround(World world, ChunkPos centerPos, BiPredicate<World, BlockPos> isOreBlock) {
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.stripChunk(world, chunkPos, isOreBlock);
        }
    }

    public void dressChunk(World world, ChunkPos chunkPos) {
        this.dressChunk(world, chunkPos, true);
    }

    public void dressChunksAround(World world, ChunkPos centerPos) {
        for (ChunkPos chunkPos : GameWorld.Positions.getAroundHoriz((ChunkPos)centerPos, (boolean)true, (ChunkPos[])new ChunkPos[]{centerPos})) {
            this.dressChunk(world, chunkPos);
        }
    }

    public void dressAllChunks(World world) {
        for (ChunkPos chunkPos : this.strippedChunks.keySet()) {
            this.dressChunk(world, chunkPos, false);
        }
        this.strippedChunks.clear();
    }

    protected void dressChunk(World world, ChunkPos chunkPos, boolean removeEntry) {
        if (!this.strippedChunks.containsKey(chunkPos)) {
            return;
        }
        BlockState[][][] data = this.strippedChunks.get(chunkPos);
        ChunkBounds bounds = ChunkBounds.from((ChunkPos)chunkPos);
        bounds.forEach(pos -> {
            BlockPos rel = bounds.relative((BlockPos)pos);
            BlockState state = data[rel.func_177958_n()][rel.func_177956_o()][rel.func_177952_p()];
            if (state != null) {
                world.func_180501_a((BlockPos)pos, state, 2);
            }
        });
        if (removeEntry) {
            this.strippedChunks.remove(chunkPos);
        }
    }
}

